/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.MainHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.TreeTraversal;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ChameleonSyntaxHighlightingPass
extends GeneralHighlightingPass {
    private ChameleonSyntaxHighlightingPass(@NotNull Project project, @NotNull PsiFile file2, @NotNull Document document, @NotNull ProperTextRange restrictRange, @NotNull ProperTextRange priorityRange, @Nullable Editor editor, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        if (project == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(1);
        }
        if (document == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(2);
        }
        if (restrictRange == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(3);
        }
        if (priorityRange == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(4);
        }
        if (highlightInfoProcessor == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(5);
        }
        super(project, file2, document, restrictRange.getStartOffset(), restrictRange.getEndOffset(), true, priorityRange, editor, highlightInfoProcessor);
    }

    @Override
    public void collectInformationWithProgress(@NotNull ProgressIndicator progress2) {
        if (progress2 == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(6);
        }
        SyntaxTraverser s = (SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)this.myFile).filter(o -> {
            IElementType type = PsiUtilCore.getElementType((PsiElement)o);
            return type instanceof ILazyParseableElementType && !(type instanceof IFileElementType);
        });
        ArrayList lazyOutside = new ArrayList(100);
        ArrayList<PsiElement> lazyInside = new ArrayList<PsiElement>(100);
        ArrayList outside = new ArrayList(100);
        ArrayList inside = new ArrayList(100);
        for (PsiElement e : s) {
            (e.getTextRange().intersects((TextRange)this.myPriorityRange) ? lazyInside : lazyOutside).add(e);
        }
        for (PsiElement e : lazyInside) {
            this.collectHighlights(e, inside, outside, this.myPriorityRange);
        }
        this.myHighlightInfoProcessor.highlightsInsideVisiblePartAreProduced(this.myHighlightingSession, this.getEditor(), inside, (TextRange)this.myPriorityRange, this.myRestrictRange, this.getId());
        for (PsiElement e : lazyOutside) {
            this.collectHighlights(e, inside, outside, this.myPriorityRange);
        }
        this.myHighlightInfoProcessor.highlightsOutsideVisiblePartAreProduced(this.myHighlightingSession, this.getEditor(), outside, (TextRange)this.myPriorityRange, this.myRestrictRange, this.getId());
        this.myHighlights.addAll(inside);
        this.myHighlights.addAll(outside);
    }

    private void collectHighlights(@NotNull PsiElement element2, @NotNull List<? super HighlightInfo> inside, @NotNull List<? super HighlightInfo> outside, @NotNull ProperTextRange priorityRange) {
        if (element2 == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(7);
        }
        if (inside == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(8);
        }
        if (outside == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(9);
        }
        if (priorityRange == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(10);
        }
        EditorColorsScheme scheme = (EditorColorsScheme)ObjectUtils.notNull((Object)this.getColorsScheme(), (Object)EditorColorsManager.getInstance().getGlobalScheme());
        TextAttributes defaultAttrs = scheme.getAttributes(HighlighterColors.TEXT);
        Language language = (Language)ILazyParseableElementType.LANGUAGE_KEY.get((UserDataHolder)element2.getNode());
        if (language == null) {
            return;
        }
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)this.myProject, (VirtualFile)this.myFile.getVirtualFile());
        for (PsiElement token : SyntaxTraverser.psiTraverser((PsiElement)element2).traverse(TreeTraversal.LEAVES_DFS)) {
            TextAttributes forcedAttributes;
            List<? super HighlightInfo> result2;
            TextRange tr = token.getTextRange();
            if (tr.isEmpty()) continue;
            IElementType type = PsiUtilCore.getElementType((PsiElement)token);
            TextAttributesKey[] keys2 = syntaxHighlighter.getTokenHighlights(type);
            TextAttributes attributes = null;
            for (TextAttributesKey key : keys2) {
                TextAttributes attrs2 = scheme.getAttributes(key);
                if (attrs2 == null) continue;
                attributes = attributes == null ? attrs2 : TextAttributes.merge((TextAttributes)attributes, (TextAttributes)attrs2);
            }
            List<? super HighlightInfo> list2 = result2 = priorityRange.contains(tr) ? inside : outside;
            if (attributes == null || attributes.isEmpty() || attributes.equals((Object)defaultAttrs)) {
                forcedAttributes = TextAttributes.ERASE_MARKER;
            } else {
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT).range(tr).textAttributes(TextAttributes.ERASE_MARKER).createUnconditionally();
                result2.add(info);
                forcedAttributes = new TextAttributes(attributes.getForegroundColor(), attributes.getBackgroundColor(), attributes.getEffectColor(), attributes.getEffectType(), attributes.getFontType());
            }
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT).range(tr).textAttributes(forcedAttributes).createUnconditionally();
            result2.add(info);
        }
    }

    @Override
    protected void applyInformationWithProgress() {
    }

    @Override
    @Nullable
    protected String getPresentableName() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictRange";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inside";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outside";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "collectInformationWithProgress";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "collectHighlights";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class Factory
    implements MainHighlightingPassFactory,
    TextEditorHighlightingPassFactoryRegistrar {
        Factory() {
        }

        @Override
        public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
            if (registrar == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (project == null) {
                Factory.$$$reportNull$$$0(1);
            }
            registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{4}, false, -1);
        }

        @Override
        @NotNull
        public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
            if (file2 == null) {
                Factory.$$$reportNull$$$0(2);
            }
            if (editor == null) {
                Factory.$$$reportNull$$$0(3);
            }
            Project project = file2.getProject();
            TextRange restrict = FileStatusMap.getDirtyTextRange(editor, 4);
            if (restrict == null) {
                return new ProgressableTextEditorHighlightingPass.EmptyPass(project, editor.getDocument());
            }
            ProperTextRange priority = VisibleHighlightingPassFactory.calculateVisibleRange(editor);
            return new ChameleonSyntaxHighlightingPass(project, file2, editor.getDocument(), ProperTextRange.create((Segment)restrict), priority, editor, new DefaultHighlightInfoProcessor());
        }

        @Override
        @NotNull
        public TextEditorHighlightingPass createMainHighlightingPass(@NotNull PsiFile file2, @NotNull Document document, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
            if (file2 == null) {
                Factory.$$$reportNull$$$0(4);
            }
            if (document == null) {
                Factory.$$$reportNull$$$0(5);
            }
            if (highlightInfoProcessor == null) {
                Factory.$$$reportNull$$$0(6);
            }
            ProperTextRange range2 = ProperTextRange.from((int)0, (int)document.getTextLength());
            return new ChameleonSyntaxHighlightingPass(file2.getProject(), file2, document, range2, range2, null, highlightInfoProcessor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "registrar";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlightInfoProcessor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass$Factory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerHighlightingPassFactory";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createHighlightingPass";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createMainHighlightingPass";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

