/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.intellij.serialization.Binding;
import com.intellij.serialization.BindingInitializationContext;
import com.intellij.serialization.ClassUtil;
import com.intellij.serialization.IonBindingProducerKt;
import com.intellij.serialization.MapBinding;
import com.intellij.serialization.MapBinding$WhenMappings;
import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.ObjectSerializerKt;
import com.intellij.serialization.ReadContext;
import com.intellij.serialization.SerializationException;
import com.intellij.serialization.StringBinding;
import com.intellij.serialization.WriteContext;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0016J \u0010\f\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u000eH\u0016J,\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0002J2\u0010\u0017\u001a\u00020\u00102\u0016\u0010\u0018\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00192\u0006\u0010\u0005\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u001cH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/serialization/MapBinding;", "Lcom/intellij/serialization/Binding;", "keyType", "Ljava/lang/reflect/Type;", "valueType", "context", "Lcom/intellij/serialization/BindingInitializationContext;", "(Ljava/lang/reflect/Type;Ljava/lang/reflect/Type;Lcom/intellij/serialization/BindingInitializationContext;)V", "isKeyComparable", "", "keyBinding", "valueBinding", "deserialize", "", "Lcom/intellij/serialization/ReadContext;", "hostObject", "", "property", "Lcom/intellij/serialization/MutableAccessor;", "read", "type", "Lcom/amazon/ion/IonType;", "binding", "readInto", "result", "", "serialize", "obj", "Lcom/intellij/serialization/WriteContext;", "intellij.platform.objectSerializer"})
public final class MapBinding
implements Binding {
    private final Binding keyBinding;
    private final Binding valueBinding;
    private final boolean isKeyComparable;

    /*
     * WARNING - void declaration
     */
    @Override
    public void serialize(@NotNull Object obj2, @NotNull WriteContext context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map map = (Map)obj2;
        IonWriter writer = context.getWriter();
        if (context.getFilter().getSkipEmptyMap() && map.isEmpty()) {
            writer.writeInt(0L);
            return;
        }
        Function3<Object, Object, Boolean, Unit> $fun$writeEntry$1 = new Function3<Object, Object, Boolean, Unit>(this, writer, context){
            final /* synthetic */ MapBinding this$0;
            final /* synthetic */ IonWriter $writer;
            final /* synthetic */ WriteContext $context;

            public final void invoke(@Nullable Object key, @Nullable Object value, boolean isStringKey) {
                if (isStringKey) {
                    if (key == null) {
                        throw (Throwable)new SerializationException("null string keys not supported");
                    }
                    this.$writer.setFieldName((String)key);
                } else if (key == null) {
                    this.$writer.writeNull();
                } else {
                    MapBinding.access$getKeyBinding$p(this.this$0).serialize(key, this.$context);
                }
                if (value == null) {
                    this.$writer.writeNull();
                } else {
                    MapBinding.access$getValueBinding$p(this.this$0).serialize(value, this.$context);
                }
            }
            {
                this.this$0 = mapBinding;
                this.$writer = ionWriter;
                this.$context = writeContext;
                super(3);
            }
        };
        boolean isStringKey = this.keyBinding instanceof StringBinding;
        writer.stepIn(isStringKey ? IonType.STRUCT : IonType.LIST);
        if (context.getConfiguration().getOrderMapEntriesByKeys() && this.isKeyComparable && !(map instanceof SortedMap) && !(map instanceof LinkedHashMap)) {
            Object[] keys = ArrayUtil.toObjectArray((Collection)map.keySet());
            Arrays.sort(keys, serialize.2.INSTANCE);
            for (Object key : keys) {
                Map map2 = map;
                boolean bl = false;
                $fun$writeEntry$1.invoke(key, map2.get(key), isStringKey);
            }
        } else if (map instanceof THashMap) {
            ((THashMap)map).forEachEntry(new TObjectObjectProcedure<K, V>($fun$writeEntry$1, isStringKey){
                final /* synthetic */ serialize.1 $writeEntry$1;
                final /* synthetic */ boolean $isStringKey;

                public final boolean execute(@Nullable Object k, @Nullable Object v) {
                    this.$writeEntry$1.invoke(k, v, this.$isStringKey);
                    return true;
                }
                {
                    this.$writeEntry$1 = var1_1;
                    this.$isStringKey = bl;
                }
            });
        } else {
            Map $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Map map3 = $this$forEach$iv;
            boolean bl = false;
            Iterator iterator = map3.entrySet().iterator();
            while (iterator.hasNext()) {
                void key;
                Map.Entry element$iv;
                Map.Entry $dstr$key$value = element$iv = iterator.next();
                boolean bl2 = false;
                Map.Entry entry = $dstr$key$value;
                boolean bl3 = false;
                Object k = entry.getKey();
                entry = $dstr$key$value;
                bl3 = false;
                Object value = entry.getValue();
                $fun$writeEntry$1.invoke((Object)key, value, isStringKey);
            }
        }
        writer.stepOut();
    }

    @Override
    public void deserialize(@NotNull Object hostObject, @NotNull MutableAccessor property, @NotNull ReadContext context) {
        Intrinsics.checkNotNullParameter((Object)hostObject, (String)"hostObject");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getReader().getType() == IonType.NULL) {
            property.set(hostObject, null);
            return;
        }
        Map result = TypeIntrinsics.asMutableMap((Object)property.readUnsafe(hostObject));
        if (result != null && ClassUtil.isMutableMap((Map)result)) {
            result.clear();
        } else {
            result = (Map)new THashMap();
            property.set(hostObject, (Object)result);
        }
        this.readInto(result, context, hostObject);
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull ReadContext context, @Nullable Object hostObject) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        THashMap result = new THashMap();
        this.readInto((Map)result, context, hostObject);
        return result;
    }

    private final void readInto(Map<Object, Object> result, ReadContext context, Object hostObject) {
        IonReader reader = context.getReader();
        if (reader.getType() == IonType.INT) {
            ObjectSerializerKt.getLOG().assertTrue(context.getReader().intValue() == 0);
            return;
        }
        boolean isStringKeys = reader.getType() == IonType.STRUCT;
        reader.stepIn();
        while (true) {
            if (isStringKeys) {
                IonType type;
                if (reader.next() == null) {
                    break;
                }
                String key = reader.getFieldName();
                Object value = this.read(type, this.valueBinding, context, hostObject);
                result.put(key, value);
                continue;
            }
            IonType ionType = reader.next();
            if (ionType == null) {
                break;
            }
            Object key = this.read(ionType, this.keyBinding, context, hostObject);
            IonType ionType2 = reader.next();
            if (ionType2 == null) {
                break;
            }
            Object value = this.read(ionType2, this.valueBinding, context, hostObject);
            result.put(key, value);
        }
        reader.stepOut();
    }

    private final Object read(IonType type, Binding binding, ReadContext context, Object hostObject) {
        Object object;
        switch (MapBinding$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                object = null;
                break;
            }
            default: {
                object = binding.deserialize(context, hostObject);
            }
        }
        return object;
    }

    public MapBinding(@NotNull Type keyType, @NotNull Type valueType, @NotNull BindingInitializationContext context) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.keyBinding = IonBindingProducerKt.createElementBindingByType(keyType, context);
        this.valueBinding = IonBindingProducerKt.createElementBindingByType(valueType, context);
        this.isKeyComparable = Comparable.class.isAssignableFrom(ClassUtil.typeToClass((Type)keyType));
    }

    @Override
    public void serialize(@NotNull Object hostObject, @NotNull MutableAccessor property, @NotNull WriteContext context) {
        Intrinsics.checkNotNullParameter((Object)hostObject, (String)"hostObject");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Binding.DefaultImpls.serialize(this, hostObject, property, context);
    }

    @Override
    @NotNull
    public Type createCacheKey(@Nullable Class<?> aClass, @NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return Binding.DefaultImpls.createCacheKey(this, aClass, type);
    }

    @Override
    public void init(@NotNull Type originalType, @NotNull BindingInitializationContext context) {
        Intrinsics.checkNotNullParameter((Object)originalType, (String)"originalType");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Binding.DefaultImpls.init(this, originalType, context);
    }

    public static final /* synthetic */ Binding access$getKeyBinding$p(MapBinding $this) {
        return $this.keyBinding;
    }

    public static final /* synthetic */ Binding access$getValueBinding$p(MapBinding $this) {
        return $this.valueBinding;
    }
}

