/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.configuration;

import com.intellij.application.options.ModulesCombo;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.JavaRunConfigurationBase;
import com.intellij.execution.application.JavaSettingsEditorBase;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit2.configuration.JUnitConfigurable;
import com.intellij.execution.junit2.configuration.JUnitTestKindFragment;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.ui.CommonJavaFragments;
import com.intellij.execution.ui.CommonParameterFragments;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.ModuleClasspathCombo;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.execution.ui.VariantTagFragment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.rt.execution.junit.RepeatCount;
import java.awt.Component;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class JUnitSettingsEditor
extends JavaSettingsEditorBase<JUnitConfiguration> {
    public JUnitSettingsEditor(JUnitConfiguration runConfiguration) {
        super((JavaRunConfigurationBase)runConfiguration);
    }

    protected void customizeFragments(List<SettingsEditorFragment<JUnitConfiguration, ?>> fragments, SettingsEditorFragment<JUnitConfiguration, ModuleClasspathCombo> moduleClasspath, CommonParameterFragments<JUnitConfiguration> commonParameterFragments) {
        DefaultJreSelector jreSelector = DefaultJreSelector.fromModuleDependencies((ModuleClasspathCombo)((ModuleClasspathCombo)moduleClasspath.component()), (boolean)false);
        SettingsEditorFragment jrePath = CommonJavaFragments.createJrePath((DefaultJreSelector)jreSelector);
        fragments.add(jrePath);
        fragments.add(this.createShortenClasspath((ModuleClasspathCombo)moduleClasspath.component(), jrePath, false));
        if (FilenameIndex.getFilesByName((Project)((JUnitConfiguration)this.mySettings).getProject(), (String)"module-info.java", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)((JUnitConfiguration)this.mySettings).getProject())).length > 0) {
            fragments.add(SettingsEditorFragment.createTag((String)"test.use.module.path", (String)ExecutionBundle.message((String)"do.not.use.module.path.tag", (Object[])new Object[0]), (String)ExecutionBundle.message((String)"group.java.options", (Object[])new Object[0]), configuration -> !configuration.isUseModulePath(), (configuration, value) -> configuration.setUseModulePath(value == false)));
        }
        ConfigurationModuleSelector moduleSelector = new ConfigurationModuleSelector(this.getProject(), (ModulesCombo)moduleClasspath.component());
        JUnitTestKindFragment testKind = new JUnitTestKindFragment(this.getProject(), moduleSelector);
        fragments.add(testKind);
        String group = JUnitBundle.message("test.group", new Object[0]);
        VariantTagFragment scopeFragment = VariantTagFragment.createFragment((String)"testScope", (String)JUnitBundle.message("search.scope.name", new Object[0]), (String)group, () -> new TestSearchScope[]{TestSearchScope.WHOLE_PROJECT, TestSearchScope.SINGLE_MODULE, TestSearchScope.MODULE_WITH_DEPENDENCIES}, configuration -> configuration.getTestSearchScope(), (configuration, scope) -> configuration.setSearchScope((TestSearchScope)scope), configuration -> configuration.getTestSearchScope() != TestSearchScope.WHOLE_PROJECT);
        scopeFragment.setVariantNameProvider(scope -> scope == TestSearchScope.WHOLE_PROJECT ? JUnitBundle.message("search.scope.project", new Object[0]) : (scope == TestSearchScope.SINGLE_MODULE ? JUnitBundle.message("search.scope.module", new Object[0]) : JUnitBundle.message("search.scope.module.deps", new Object[0])));
        scopeFragment.addSettingsEditorListener(editor -> {
            boolean disableModuleClasspath = testKind.disableModuleClasspath(scopeFragment.getSelectedVariant() == TestSearchScope.WHOLE_PROJECT);
            moduleClasspath.setSelected(!disableModuleClasspath);
            if (disableModuleClasspath) {
                ((ModuleClasspathCombo)moduleClasspath.component()).setSelectedModule(null);
            }
        });
        fragments.add((SettingsEditorFragment<JUnitConfiguration, ?>)scopeFragment);
        VariantTagFragment repeat = VariantTagFragment.createFragment((String)"repeat", (String)JUnitBundle.message("repeat.name", new Object[0]), (String)group, () -> RepeatCount.REPEAT_TYPES, configuration -> configuration.getRepeatMode(), (configuration, mode) -> configuration.setRepeatMode((String)mode), configuration -> !"Once".equals(configuration.getRepeatMode()));
        fragments.add((SettingsEditorFragment<JUnitConfiguration, ?>)repeat);
        LabeledComponent countField = LabeledComponent.create((JComponent)new JTextField(), (String)JUnitBundle.message("repeat.count.label", new Object[0]), (String)"West");
        SettingsEditorFragment countFragment = new SettingsEditorFragment("count", null, null, (JComponent)countField, (configuration, field) -> ((JTextField)field.getComponent()).setText(String.valueOf(configuration.getRepeatCount())), (configuration, field) -> {
            try {
                configuration.setRepeatCount(Integer.parseInt(((JTextField)field.getComponent()).getText()));
            }
            catch (NumberFormatException e) {
                configuration.setRepeatCount(1);
            }
        }, configuration -> "N Times".equals(configuration.getRepeatMode()));
        fragments.add(countFragment);
        repeat.addSettingsEditorListener(editor -> countFragment.setSelected("N Times".equals(repeat.getSelectedVariant())));
        repeat.setToggleListener(s -> {
            if ("N Times".equals(s)) {
                IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)countFragment.getEditorComponent(), false);
            }
        });
        Supplier<String[]> variantsProvider = () -> JUnitConfigurable.getForkModel(testKind.getTestKind(), repeat.getSelectedVariant());
        VariantTagFragment forkMode = VariantTagFragment.createFragment((String)"forkMode", (String)JUnitBundle.message("fork.mode.name", new Object[0]), (String)group, variantsProvider, configuration -> configuration.getForkMode(), (configuration, s) -> configuration.setForkMode((String)s), configuration -> !"none".equals(configuration.getForkMode()));
        fragments.add((SettingsEditorFragment<JUnitConfiguration, ?>)forkMode);
        testKind.addSettingsEditorListener(editor -> {
            int selectedType = testKind.getTestKind();
            forkMode.setSelectedVariant((Object)JUnitConfigurable.updateForkMethod(selectedType, (String)forkMode.getSelectedVariant()));
            scopeFragment.setRemovable(selectedType == 3 || selectedType == 0 || selectedType == 7 || selectedType == 5);
        });
    }
}

