/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang;

import com.intellij.DynamicBundle;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.IntelliLangBundle;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.jetbrains.annotations.NotNull;

public class AdvancedSettingsUI
implements SearchableConfigurable {
    private final Configuration.AdvancedConfiguration myConfiguration;
    private AdvancedSettingsPanel myPanel;
    private final Project myProject;

    public AdvancedSettingsUI(@NotNull Project project, Configuration configuration) {
        if (project == null) {
            AdvancedSettingsUI.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myConfiguration = configuration.getAdvancedConfiguration();
    }

    public JComponent createComponent() {
        this.myPanel = new AdvancedSettingsPanel();
        return this.myPanel.myRoot;
    }

    public void apply() throws ConfigurationException {
        this.myPanel.apply();
    }

    public boolean isModified() {
        return this.myPanel.isModified();
    }

    public void reset() {
        this.myPanel.reset();
    }

    public void disposeUIResources() {
        this.myPanel = null;
    }

    public String getDisplayName() {
        return IntelliLangBundle.message("configurable.AdvancedSettingsUI.display.name", new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.settings.injection.advanced";
    }

    @NotNull
    public String getId() {
        return "IntelliLang.Advanced";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/intelliLang/AdvancedSettingsUI", "<init>"));
    }

    public class AdvancedSettingsPanel {
        private JPanel myRoot;
        private JRadioButton myNoInstrumentation;
        private JRadioButton myAssertInstrumentation;
        private JRadioButton myExceptionInstrumentation;
        private JPanel myLanguageAnnotationPanel;
        private JPanel myPatternAnnotationPanel;
        private JPanel mySubstAnnotationPanel;
        private JRadioButton myDfaOff;
        private JRadioButton myAnalyzeReferences;
        private JRadioButton myUseDfa;
        private JRadioButton myLookForAssignments;
        private JCheckBox myIncludeUncomputableOperandsAsCheckBox;
        private JCheckBox mySourceModificationAllowedCheckBox;
        private final ReferenceEditorWithBrowseButton myAnnotationField;
        private final ReferenceEditorWithBrowseButton myPatternField;
        private final ReferenceEditorWithBrowseButton mySubstField;

        public AdvancedSettingsPanel() {
            Project project = AdvancedSettingsUI.this.myProject;
            Function function = s -> PsiUtilEx.createDocument(s, AdvancedSettingsUI.this.myProject);
            Configuration.AdvancedConfiguration advancedConfiguration = AdvancedSettingsUI.this.myConfiguration;
            this.$$$setupUI$$$();
            this.myAnnotationField = new ReferenceEditorWithBrowseButton(null, project, function, advancedConfiguration.getLanguageAnnotationClass());
            this.myAnnotationField.addActionListener((ActionListener)new BrowseClassListener(AdvancedSettingsUI.this.myProject, this.myAnnotationField));
            this.myAnnotationField.setEnabled(!AdvancedSettingsUI.this.myProject.isDefault());
            this.addField(this.myLanguageAnnotationPanel, this.myAnnotationField);
            this.myPatternField = new ReferenceEditorWithBrowseButton(null, AdvancedSettingsUI.this.myProject, s -> PsiUtilEx.createDocument(s, AdvancedSettingsUI.this.myProject), AdvancedSettingsUI.this.myConfiguration.getPatternAnnotationClass());
            this.myPatternField.addActionListener((ActionListener)new BrowseClassListener(AdvancedSettingsUI.this.myProject, this.myPatternField));
            this.myPatternField.setEnabled(!AdvancedSettingsUI.this.myProject.isDefault());
            this.addField(this.myPatternAnnotationPanel, this.myPatternField);
            this.mySubstField = new ReferenceEditorWithBrowseButton(null, AdvancedSettingsUI.this.myProject, s -> PsiUtilEx.createDocument(s, AdvancedSettingsUI.this.myProject), AdvancedSettingsUI.this.myConfiguration.getPatternAnnotationClass());
            this.mySubstField.addActionListener((ActionListener)new BrowseClassListener(AdvancedSettingsUI.this.myProject, this.mySubstField));
            this.mySubstField.setEnabled(!AdvancedSettingsUI.this.myProject.isDefault());
            this.addField(this.mySubstAnnotationPanel, this.mySubstField);
        }

        private void addField(JPanel panel, ReferenceEditorWithBrowseButton field) {
            Component component;
            panel.add((Component)field, "Center");
            Component[] components = panel.getParent().getComponents();
            int index = Arrays.asList(components).indexOf(panel);
            if (index > 0 && (component = components[index - 1]) instanceof JLabel) {
                ((JLabel)component).setLabelFor((Component)field);
            }
        }

        public boolean isModified() {
            if (this.getInstrumentation() != AdvancedSettingsUI.this.myConfiguration.getInstrumentation()) {
                return true;
            }
            if (!this.myAnnotationField.getText().equals(AdvancedSettingsUI.this.myConfiguration.getLanguageAnnotationClass())) {
                return true;
            }
            if (!this.myPatternField.getText().equals(AdvancedSettingsUI.this.myConfiguration.getPatternAnnotationClass())) {
                return true;
            }
            if (!this.mySubstField.getText().equals(AdvancedSettingsUI.this.myConfiguration.getSubstAnnotationClass())) {
                return true;
            }
            if (!AdvancedSettingsUI.this.myConfiguration.getDfaOption().equals((Object)this.getDfaOption())) {
                return true;
            }
            if (AdvancedSettingsUI.this.myConfiguration.isIncludeUncomputablesAsLiterals() != this.myIncludeUncomputableOperandsAsCheckBox.isSelected()) {
                return true;
            }
            return AdvancedSettingsUI.this.myConfiguration.isSourceModificationAllowed() != this.mySourceModificationAllowedCheckBox.isSelected();
        }

        @NotNull
        private Configuration.InstrumentationType getInstrumentation() {
            if (this.myNoInstrumentation.isSelected()) {
                Configuration.InstrumentationType instrumentationType = Configuration.InstrumentationType.NONE;
                if (instrumentationType == null) {
                    AdvancedSettingsPanel.$$$reportNull$$$0(0);
                }
                return instrumentationType;
            }
            if (this.myAssertInstrumentation.isSelected()) {
                Configuration.InstrumentationType instrumentationType = Configuration.InstrumentationType.ASSERT;
                if (instrumentationType == null) {
                    AdvancedSettingsPanel.$$$reportNull$$$0(1);
                }
                return instrumentationType;
            }
            if (this.myExceptionInstrumentation.isSelected()) {
                Configuration.InstrumentationType instrumentationType = Configuration.InstrumentationType.EXCEPTION;
                if (instrumentationType == null) {
                    AdvancedSettingsPanel.$$$reportNull$$$0(2);
                }
                return instrumentationType;
            }
            assert (false);
            if (null == null) {
                AdvancedSettingsPanel.$$$reportNull$$$0(3);
            }
            return null;
        }

        public void apply() throws ConfigurationException {
            AdvancedSettingsUI.this.myConfiguration.setInstrumentationType(this.getInstrumentation());
            AdvancedSettingsUI.this.myConfiguration.setLanguageAnnotation(this.myAnnotationField.getText());
            AdvancedSettingsUI.this.myConfiguration.setPatternAnnotation(this.myPatternField.getText());
            AdvancedSettingsUI.this.myConfiguration.setSubstAnnotation(this.mySubstField.getText());
            AdvancedSettingsUI.this.myConfiguration.setDfaOption(this.getDfaOption());
            AdvancedSettingsUI.this.myConfiguration.setIncludeUncomputablesAsLiterals(this.myIncludeUncomputableOperandsAsCheckBox.isSelected());
            AdvancedSettingsUI.this.myConfiguration.setSourceModificationAllowed(this.mySourceModificationAllowedCheckBox.isSelected());
        }

        @NotNull
        private Configuration.DfaOption getDfaOption() {
            if (this.myDfaOff.isSelected()) {
                Configuration.DfaOption dfaOption = Configuration.DfaOption.OFF;
                if (dfaOption == null) {
                    AdvancedSettingsPanel.$$$reportNull$$$0(4);
                }
                return dfaOption;
            }
            if (this.myAnalyzeReferences.isSelected()) {
                Configuration.DfaOption dfaOption = Configuration.DfaOption.RESOLVE;
                if (dfaOption == null) {
                    AdvancedSettingsPanel.$$$reportNull$$$0(5);
                }
                return dfaOption;
            }
            if (this.myLookForAssignments.isSelected()) {
                Configuration.DfaOption dfaOption = Configuration.DfaOption.ASSIGNMENTS;
                if (dfaOption == null) {
                    AdvancedSettingsPanel.$$$reportNull$$$0(6);
                }
                return dfaOption;
            }
            if (this.myUseDfa.isSelected()) {
                Configuration.DfaOption dfaOption = Configuration.DfaOption.DFA;
                if (dfaOption == null) {
                    AdvancedSettingsPanel.$$$reportNull$$$0(7);
                }
                return dfaOption;
            }
            Configuration.DfaOption dfaOption = Configuration.DfaOption.OFF;
            if (dfaOption == null) {
                AdvancedSettingsPanel.$$$reportNull$$$0(8);
            }
            return dfaOption;
        }

        public void reset() {
            this.myAnnotationField.setText(AdvancedSettingsUI.this.myConfiguration.getLanguageAnnotationClass());
            this.myPatternField.setText(AdvancedSettingsUI.this.myConfiguration.getPatternAnnotationClass());
            this.mySubstField.setText(AdvancedSettingsUI.this.myConfiguration.getSubstAnnotationClass());
            this.myNoInstrumentation.setSelected(AdvancedSettingsUI.this.myConfiguration.getInstrumentation() == Configuration.InstrumentationType.NONE);
            this.myAssertInstrumentation.setSelected(AdvancedSettingsUI.this.myConfiguration.getInstrumentation() == Configuration.InstrumentationType.ASSERT);
            this.myExceptionInstrumentation.setSelected(AdvancedSettingsUI.this.myConfiguration.getInstrumentation() == Configuration.InstrumentationType.EXCEPTION);
            this.setDfaOption(AdvancedSettingsUI.this.myConfiguration.getDfaOption());
            this.myIncludeUncomputableOperandsAsCheckBox.setSelected(AdvancedSettingsUI.this.myConfiguration.isIncludeUncomputablesAsLiterals());
            this.mySourceModificationAllowedCheckBox.setSelected(AdvancedSettingsUI.this.myConfiguration.isSourceModificationAllowed());
        }

        private void setDfaOption(@NotNull Configuration.DfaOption dfaOption) {
            if (dfaOption == null) {
                AdvancedSettingsPanel.$$$reportNull$$$0(9);
            }
            switch (dfaOption) {
                case OFF: {
                    this.myDfaOff.setSelected(true);
                    break;
                }
                case RESOLVE: {
                    this.myAnalyzeReferences.setSelected(true);
                    break;
                }
                case ASSIGNMENTS: {
                    this.myLookForAssignments.setSelected(true);
                    break;
                }
                case DFA: {
                    this.myUseDfa.setSelected(true);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 9: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 9: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/plugins/intelliLang/AdvancedSettingsUI$AdvancedSettingsPanel";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dfaOption";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstrumentation";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDfaOption";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/plugins/intelliLang/AdvancedSettingsUI$AdvancedSettingsPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "setDfaOption";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 9: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JRadioButton jRadioButton;
            JRadioButton jRadioButton2;
            JRadioButton jRadioButton3;
            JRadioButton jRadioButton4;
            JRadioButton jRadioButton5;
            JRadioButton jRadioButton6;
            JRadioButton jRadioButton7;
            JPanel jPanel;
            JPanel jPanel2;
            JPanel jPanel3;
            JPanel jPanel4;
            this.myRoot = jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/IntelliLangBundle", AdvancedSettingsPanel.class).getString("settings.annotation.classes"), (int)0, (int)0, null, null));
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/IntelliLangBundle", AdvancedSettingsPanel.class).getString("settings.language.annotation.class"));
            jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myLanguageAnnotationPanel = jPanel3 = new JPanel();
            jPanel3.setLayout(new BorderLayout(0, 0));
            jPanel5.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            JLabel jLabel2 = new JLabel();
            this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/IntelliLangBundle", AdvancedSettingsPanel.class).getString("settings.pattern.annotation.class"));
            jPanel5.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myPatternAnnotationPanel = jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout(0, 0));
            jPanel5.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            JLabel jLabel3 = new JLabel();
            this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/IntelliLangBundle", AdvancedSettingsPanel.class).getString("settings.substitution.annotation.class"));
            jPanel5.add((Component)jLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.mySubstAnnotationPanel = jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout(0, 0));
            jPanel5.add((Component)jPanel, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new BorderLayout(0, 0));
            jPanel.add((Component)jPanel6, "Center");
            JPanel jPanel7 = new JPanel();
            jPanel7.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel4.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel7.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/IntelliLangBundle", AdvancedSettingsPanel.class).getString("settings.runtime.pattern.validation"), (int)0, (int)0, null, null));
            this.myNoInstrumentation = jRadioButton7 = new JRadioButton();
            this.$$$loadButtonText$$$(jRadioButton7, DynamicBundle.getBundle((String)"messages/IntelliLangBundle", AdvancedSettingsPanel.class).getString("settings.no.runtime.instrumentation"));
            jPanel7.add((Component)jRadioButton7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myAssertInstrumentation = jRadioButton6 = new JRadioButton();
            this.$$$loadButtonText$$$(jRadioButton6, DynamicBundle.getBundle((String)"messages/IntelliLangBundle", AdvancedSettingsPanel.class).getString("settings.instrument.with.assertions"));
            jPanel7.add((Component)jRadioButton6, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myExceptionInstrumentation = jRadioButton5 = new JRadioButton();
            this.$$$loadButtonText$$$(jRadioButton5, DynamicBundle.getBundle((String)"messages/IntelliLangBundle", AdvancedSettingsPanel.class).getString("settings.instrument.with.illegal.argument.exception"));
            jPanel7.add((Component)jRadioButton5, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JPanel jPanel8 = new JPanel();
            jPanel8.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel8.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel4.add((Component)jPanel8, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel8.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/IntelliLangBundle", AdvancedSettingsPanel.class).getString("settings.performance"), (int)0, (int)0, null, null));
            this.myDfaOff = jRadioButton4 = new JRadioButton();
            this.$$$loadButtonText$$$(jRadioButton4, DynamicBundle.getBundle((String)"messages/IntelliLangBundle", AdvancedSettingsPanel.class).getString("settings.do.not.analyze.anything"));
            jPanel8.add((Component)jRadioButton4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myAnalyzeReferences = jRadioButton3 = new JRadioButton();
            this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/IntelliLangBundle", AdvancedSettingsPanel.class).getString("settings.analyze.references"));
            jPanel8.add((Component)jRadioButton3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myLookForAssignments = jRadioButton2 = new JRadioButton();
            this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/IntelliLangBundle", AdvancedSettingsPanel.class).getString("settings.look.for.variable.assignments"));
            jPanel8.add((Component)jRadioButton2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myUseDfa = jRadioButton = new JRadioButton();
            jRadioButton.setSelected(false);
            this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/IntelliLangBundle", AdvancedSettingsPanel.class).getString("settings.use.dataflow.analysis"));
            jPanel8.add((Component)jRadioButton, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myIncludeUncomputableOperandsAsCheckBox = jCheckBox2 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/IntelliLangBundle", AdvancedSettingsPanel.class).getString("settings.convert.undefined.operands.to.text"));
            jPanel4.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.mySourceModificationAllowedCheckBox = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/IntelliLangBundle", AdvancedSettingsPanel.class).getString("settings.add.language.annotation.or.comment"));
            jPanel4.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel4.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButton7);
            buttonGroup.add(jRadioButton6);
            buttonGroup.add(jRadioButton5);
            buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButton4);
            buttonGroup.add(jRadioButton3);
            buttonGroup.add(jRadioButton);
            buttonGroup.add(jRadioButton2);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myRoot;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private static final class BrowseClassListener
    implements ActionListener {
        private final Project myProject;
        private final ReferenceEditorWithBrowseButton myField;

        private BrowseClassListener(Project project, ReferenceEditorWithBrowseButton annotationField) {
            this.myProject = project;
            this.myField = annotationField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeClassChooserFactory factory = TreeClassChooserFactory.getInstance((Project)this.myProject);
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
            PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(this.myField.getText(), scope);
            TreeClassChooser chooser = factory.createNoInnerClassesScopeChooser(IntelliLangBundle.message("dialog.title.select.annotation.class", new Object[0]), scope, new ClassFilter(){

                public boolean isAccepted(PsiClass aClass) {
                    return aClass.isAnnotationType();
                }
            }, aClass);
            chooser.showDialog();
            PsiClass psiClass = chooser.getSelected();
            if (psiClass != null) {
                this.myField.setText(psiClass.getQualifiedName());
            }
        }
    }
}

