/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.registry.impl;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.file.FileWatcher;
import org.gradle.internal.impldep.com.google.common.collect.HashMultiset;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Multiset;
import org.gradle.internal.snapshot.CompleteDirectorySnapshot;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.watch.WatchingNotSupportedException;
import org.gradle.internal.watch.registry.FileWatcherUpdater;
import org.gradle.internal.watch.registry.SnapshotCollectingDiffListener;
import org.gradle.internal.watch.registry.impl.CheckIfNonEmptySnapshotVisitor;
import org.gradle.internal.watch.registry.impl.SnapshotWatchedDirectoryFinder;
import org.gradle.internal.watch.registry.impl.WatchableHierarchies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonHierarchicalFileWatcherUpdater
implements FileWatcherUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonHierarchicalFileWatcherUpdater.class);
    private final Multiset<String> watchedDirectories = HashMultiset.create();
    private final Map<String, ImmutableList<String>> watchedDirectoriesForSnapshot = new HashMap<String, ImmutableList<String>>();
    private final FileWatcher fileWatcher;
    private final WatchableHierarchies watchableHierarchies;

    public NonHierarchicalFileWatcherUpdater(FileWatcher fileWatcher, Predicate<String> watchFilter) {
        this.fileWatcher = fileWatcher;
        this.watchableHierarchies = new WatchableHierarchies(watchFilter);
    }

    @Override
    public void virtualFileSystemContentsChanged(Collection<CompleteFileSystemLocationSnapshot> removedSnapshots, Collection<CompleteFileSystemLocationSnapshot> addedSnapshots, SnapshotHierarchy root) {
        HashMap<String, Integer> changedWatchedDirectories = new HashMap<String, Integer>();
        removedSnapshots.stream().filter(this.watchableHierarchies::shouldWatch).forEach(snapshot -> {
            ImmutableList<String> previousWatchedRoots = this.watchedDirectoriesForSnapshot.remove(snapshot.getAbsolutePath());
            previousWatchedRoots.forEach(path -> NonHierarchicalFileWatcherUpdater.decrement(path, changedWatchedDirectories));
            snapshot.accept(new SubdirectoriesToWatchVisitor(path -> NonHierarchicalFileWatcherUpdater.decrement(path, changedWatchedDirectories)));
        });
        addedSnapshots.stream().filter(this.watchableHierarchies::shouldWatch).forEach(snapshot -> {
            ImmutableList directoriesToWatchForRoot = ImmutableList.copyOf((Collection)SnapshotWatchedDirectoryFinder.getDirectoriesToWatch(snapshot).stream().map(Path::toString).collect(Collectors.toList()));
            this.watchedDirectoriesForSnapshot.put(snapshot.getAbsolutePath(), (ImmutableList<String>)directoriesToWatchForRoot);
            directoriesToWatchForRoot.forEach(path -> NonHierarchicalFileWatcherUpdater.increment(path, changedWatchedDirectories));
            snapshot.accept(new SubdirectoriesToWatchVisitor(path -> NonHierarchicalFileWatcherUpdater.increment(path, changedWatchedDirectories)));
        });
        this.updateWatchedDirectories(changedWatchedDirectories);
    }

    @Override
    public void registerWatchableHierarchy(File watchableHierarchy, SnapshotHierarchy root) {
        this.watchableHierarchies.registerWatchableHierarchy(watchableHierarchy, root);
    }

    @Override
    public SnapshotHierarchy buildFinished(SnapshotHierarchy root, int maximumNumberOfWatchedHierarchies) {
        WatchableHierarchies.Invalidator invalidator = (location, currentRoot) -> {
            SnapshotCollectingDiffListener diffListener = new SnapshotCollectingDiffListener();
            SnapshotHierarchy invalidatedRoot = currentRoot.invalidate(location, diffListener);
            diffListener.publishSnapshotDiff((removedSnapshots, addedSnapshots) -> this.virtualFileSystemContentsChanged(removedSnapshots, addedSnapshots, invalidatedRoot));
            return invalidatedRoot;
        };
        SnapshotHierarchy newRoot = this.watchableHierarchies.removeWatchedHierarchiesOverLimit(root, hierarchy -> this.containsSnapshots((Path)hierarchy, root), maximumNumberOfWatchedHierarchies, invalidator);
        newRoot = this.watchableHierarchies.removeUnwatchedSnapshots(newRoot, invalidator);
        LOGGER.info("Watching {} directories to track changes", (Object)this.watchedDirectories.entrySet().size());
        return newRoot;
    }

    @Override
    public int getNumberOfWatchedHierarchies() {
        return this.watchableHierarchies.getWatchableHierarchies().size();
    }

    private boolean containsSnapshots(Path location, SnapshotHierarchy root) {
        CheckIfNonEmptySnapshotVisitor checkIfNonEmptySnapshotVisitor = new CheckIfNonEmptySnapshotVisitor(this.watchableHierarchies);
        root.visitSnapshotRoots(location.toString(), checkIfNonEmptySnapshotVisitor);
        return !checkIfNonEmptySnapshotVisitor.isEmpty();
    }

    private void updateWatchedDirectories(Map<String, Integer> changedWatchDirectories) {
        if (changedWatchDirectories.isEmpty()) {
            return;
        }
        HashSet<File> directoriesToStopWatching = new HashSet<File>();
        HashSet<File> directoriesToStartWatching = new HashSet<File>();
        changedWatchDirectories.forEach((absolutePath, value) -> {
            int contained;
            int count = value;
            if (count < 0) {
                int toRemove = -count;
                int contained2 = this.watchedDirectories.remove(absolutePath, toRemove);
                if (contained2 <= toRemove) {
                    directoriesToStopWatching.add(new File((String)absolutePath));
                }
            } else if (count > 0 && (contained = this.watchedDirectories.add(absolutePath, count)) == 0) {
                directoriesToStartWatching.add(new File((String)absolutePath));
            }
        });
        if (this.watchedDirectories.isEmpty()) {
            LOGGER.info("Not watching anything anymore");
        }
        LOGGER.info("Watching {} directories to track changes", (Object)this.watchedDirectories.entrySet().size());
        try {
            if (!directoriesToStopWatching.isEmpty()) {
                this.fileWatcher.stopWatching(directoriesToStopWatching);
            }
            if (!directoriesToStartWatching.isEmpty()) {
                this.fileWatcher.startWatching(directoriesToStartWatching);
            }
        }
        catch (NativeException e) {
            if (e.getMessage().contains("Already watching path: ")) {
                throw new WatchingNotSupportedException("Unable to watch same file twice via different paths: " + e.getMessage(), e);
            }
            throw e;
        }
    }

    private static void decrement(String path, Map<String, Integer> changedWatchedDirectories) {
        changedWatchedDirectories.compute(path, (key, value) -> value == null ? -1 : value - 1);
    }

    private static void increment(String path, Map<String, Integer> changedWatchedDirectories) {
        changedWatchedDirectories.compute(path, (key, value) -> value == null ? 1 : value + 1);
    }

    private class SubdirectoriesToWatchVisitor
    implements FileSystemSnapshotVisitor {
        private final Consumer<String> subDirectoryToWatchConsumer;
        private boolean root;

        public SubdirectoriesToWatchVisitor(Consumer<String> subDirectoryToWatchConsumer) {
            this.subDirectoryToWatchConsumer = subDirectoryToWatchConsumer;
            this.root = true;
        }

        @Override
        public boolean preVisitDirectory(CompleteDirectorySnapshot directorySnapshot) {
            if (this.root) {
                this.root = false;
                return true;
            }
            if (NonHierarchicalFileWatcherUpdater.this.watchableHierarchies.ignoredForWatching(directorySnapshot)) {
                return false;
            }
            this.subDirectoryToWatchConsumer.accept(directorySnapshot.getAbsolutePath());
            return true;
        }

        @Override
        public void visitFile(CompleteFileSystemLocationSnapshot fileSnapshot) {
        }

        @Override
        public void postVisitDirectory(CompleteDirectorySnapshot directorySnapshot) {
        }
    }
}

