/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.Closeable;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.function.Consumer;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.GlobalCacheLocations;
import org.gradle.cache.PersistentCache;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.ClasspathBuilder;
import org.gradle.internal.classpath.ClasspathFileTransformer;
import org.gradle.internal.classpath.ClasspathTransformerCacheFactory;
import org.gradle.internal.classpath.ClasspathWalker;
import org.gradle.internal.classpath.CompositeTransformer;
import org.gradle.internal.classpath.CopyingClasspathFileTransformer;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.classpath.InstrumentingClasspathFileTransformer;
import org.gradle.internal.classpath.InstrumentingTransformer;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.file.FileAccessTracker;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.vfs.FileSystemAccess;

public class DefaultCachedClasspathTransformer
implements CachedClasspathTransformer,
Closeable {
    private final PersistentCache cache;
    private final FileAccessTracker fileAccessTracker;
    private final ClasspathWalker classpathWalker;
    private final ClasspathBuilder classpathBuilder;
    private final FileSystemAccess fileSystemAccess;
    private final GlobalCacheLocations globalCacheLocations;
    private final ManagedExecutor executor;

    public DefaultCachedClasspathTransformer(CacheRepository cacheRepository, ClasspathTransformerCacheFactory classpathTransformerCacheFactory, FileAccessTimeJournal fileAccessTimeJournal, ClasspathWalker classpathWalker, ClasspathBuilder classpathBuilder, FileSystemAccess fileSystemAccess, ExecutorFactory executorFactory, GlobalCacheLocations globalCacheLocations) {
        this.classpathWalker = classpathWalker;
        this.classpathBuilder = classpathBuilder;
        this.fileSystemAccess = fileSystemAccess;
        this.globalCacheLocations = globalCacheLocations;
        this.cache = classpathTransformerCacheFactory.createCache(cacheRepository, fileAccessTimeJournal);
        this.fileAccessTracker = classpathTransformerCacheFactory.createFileAccessTracker(fileAccessTimeJournal);
        this.executor = executorFactory.create("jar transforms");
    }

    @Override
    public ClassPath transform(ClassPath classPath, CachedClasspathTransformer.StandardTransform transform) {
        return this.transformFiles(classPath, this.fileTransformerFor(transform));
    }

    @Override
    public ClassPath transform(ClassPath classPath, CachedClasspathTransformer.StandardTransform transform, CachedClasspathTransformer.Transform additional) {
        return this.transformFiles(classPath, new InstrumentingClasspathFileTransformer(this.classpathWalker, this.classpathBuilder, new CompositeTransformer(additional, this.transformerFor(transform))));
    }

    @Override
    public Collection<URL> transform(Collection<URL> urls, CachedClasspathTransformer.StandardTransform transform) {
        if (urls.isEmpty()) {
            return ImmutableList.of();
        }
        ClasspathFileTransformer transformer = this.fileTransformerFor(transform);
        return (Collection)this.cache.useCache(() -> {
            HashSet<HashCode> seen = new HashSet<HashCode>();
            ArrayList<CacheOperation> operations = new ArrayList<CacheOperation>(urls.size());
            for (URL url : urls) {
                operations.add(this.cached(url, transformer, seen));
            }
            ImmutableList.Builder cachedFiles = ImmutableList.builderWithExpectedSize((int)urls.size());
            for (CacheOperation operation : operations) {
                operation.collectUrl(arg_0 -> ((ImmutableList.Builder)cachedFiles).add(arg_0));
            }
            return cachedFiles.build();
        });
    }

    private ClassPath transformFiles(ClassPath classPath, ClasspathFileTransformer transformer) {
        if (classPath.isEmpty()) {
            return classPath;
        }
        return this.cache.useCache(() -> {
            List<File> originalFiles = classPath.getAsFiles();
            ArrayList<CacheOperation> operations = new ArrayList<CacheOperation>(originalFiles.size());
            HashSet<HashCode> seen = new HashSet<HashCode>();
            for (File file : originalFiles) {
                operations.add(this.cached(file, transformer, seen));
            }
            ArrayList<File> cachedFiles = new ArrayList<File>(originalFiles.size());
            for (CacheOperation operation : operations) {
                operation.collect(cachedFiles::add);
            }
            return DefaultClassPath.of(cachedFiles);
        });
    }

    private CachedClasspathTransformer.Transform transformerFor(CachedClasspathTransformer.StandardTransform transform) {
        if (transform == CachedClasspathTransformer.StandardTransform.BuildLogic) {
            return new InstrumentingTransformer();
        }
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    private ClasspathFileTransformer fileTransformerFor(CachedClasspathTransformer.StandardTransform transform) {
        switch (transform) {
            case BuildLogic: {
                return new InstrumentingClasspathFileTransformer(this.classpathWalker, this.classpathBuilder, new InstrumentingTransformer());
            }
            case None: {
                return new CopyingClasspathFileTransformer(this.globalCacheLocations);
            }
        }
        throw new IllegalArgumentException();
    }

    private CacheOperation cached(URL original, ClasspathFileTransformer transformer, Set<HashCode> seen) {
        if (original.getProtocol().equals("file")) {
            try {
                return this.cached(new File(original.toURI()), transformer, seen);
            }
            catch (URISyntaxException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }
        return new RetainUrl(original);
    }

    private CacheOperation cached(File original, ClasspathFileTransformer transformer, Set<HashCode> seen) {
        CompleteFileSystemLocationSnapshot snapshot = this.fileSystemAccess.read(original.getAbsolutePath(), s -> s);
        HashCode contentHash = snapshot.getHash();
        if (snapshot.getType() == FileType.Missing) {
            return new EmptyOperation();
        }
        if (this.shouldUseFromCache(original)) {
            if (!seen.add(contentHash)) {
                return new EmptyOperation();
            }
            TransformFile operation = new TransformFile(transformer, original, snapshot, this.cache.getBaseDir());
            operation.schedule(this.executor);
            return operation;
        }
        return new RetainFile(original);
    }

    private boolean shouldUseFromCache(File original) {
        return !original.toPath().startsWith(this.cache.getBaseDir().toPath());
    }

    @Override
    public void close() {
        CompositeStoppable.stoppable(this.executor, this.cache).stop();
    }

    private class TransformFile
    implements CacheOperation {
        private final SynchronousQueue<Object> queue;
        private final ClasspathFileTransformer transformer;
        private final File original;
        private final CompleteFileSystemLocationSnapshot snapshot;
        private final File cacheDir;

        public TransformFile(ClasspathFileTransformer transformer, File original, CompleteFileSystemLocationSnapshot snapshot, File cacheDir) {
            this.transformer = transformer;
            this.original = original;
            this.snapshot = snapshot;
            this.cacheDir = cacheDir;
            this.queue = new SynchronousQueue();
        }

        public void schedule(Executor executor) {
            executor.execute(() -> {
                try {
                    try {
                        File result = this.transformer.transform(this.original, this.snapshot, this.cacheDir);
                        this.queue.put(result);
                    }
                    catch (Throwable t) {
                        this.queue.put(t);
                    }
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            });
        }

        @Override
        public void collect(Consumer<File> consumer) {
            Object message2;
            try {
                message2 = this.queue.take();
            }
            catch (InterruptedException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
            if (message2 instanceof Throwable) {
                throw UncheckedException.throwAsUncheckedException((Throwable)message2);
            }
            File result = (File)message2;
            if (!result.equals(this.original)) {
                DefaultCachedClasspathTransformer.this.fileAccessTracker.markAccessed(result);
            }
            consumer.accept(result);
        }
    }

    private static class EmptyOperation
    implements CacheOperation {
        private EmptyOperation() {
        }

        @Override
        public void collect(Consumer<File> consumer) {
        }
    }

    private static class RetainFile
    implements CacheOperation {
        private final File original;

        public RetainFile(File original) {
            this.original = original;
        }

        @Override
        public void collect(Consumer<File> consumer) {
            consumer.accept(this.original);
        }
    }

    private static class RetainUrl
    implements CacheOperation {
        private final URL original;

        public RetainUrl(URL original) {
            this.original = original;
        }

        @Override
        public void collect(Consumer<File> consumer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void collectUrl(Consumer<URL> consumer) {
            consumer.accept(this.original);
        }
    }

    static interface CacheOperation {
        public void collect(Consumer<File> var1);

        default public void collectUrl(Consumer<URL> consumer) {
            this.collect(file -> {
                try {
                    consumer.accept(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            });
        }
    }
}

