/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal.plugins;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublicationRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.plugin.management.internal.InvalidPluginRequestException;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.resolve.internal.PluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolveContext;
import org.gradle.plugin.use.resolve.internal.PluginResolver;
import org.gradle.plugin.use.resolve.internal.PluginResolverContributor;
import org.gradle.plugin.use.resolve.internal.local.PluginPublication;

public class CompositeBuildPluginResolverContributor
implements PluginResolverContributor {
    private final BuildStateRegistry buildRegistry;
    private final BuildState consumingBuild;
    private static final Resolution UNKNOWN = new Resolution(null);
    private final Map<PluginId, Resolution> results = new HashMap<PluginId, Resolution>();

    public CompositeBuildPluginResolverContributor(BuildStateRegistry buildRegistry, BuildState consumingBuild) {
        this.buildRegistry = buildRegistry;
        this.consumingBuild = consumingBuild;
    }

    @Override
    public void collectResolversInto(Collection<PluginResolver> resolvers) {
        resolvers.add(new CompositeBuildPluginResolver());
    }

    private static class Resolution {
        @Nullable
        final PluginResolution pluginResolution;

        Resolution(@Nullable PluginResolution pluginResolution) {
            this.pluginResolution = pluginResolution;
        }
    }

    private static class LocalPluginResolution
    implements PluginResolution {
        private final PluginId pluginId;
        private final ProjectInternal producingProject;

        LocalPluginResolution(PluginId pluginId, ProjectInternal producingProject) {
            this.pluginId = pluginId;
            this.producingProject = producingProject;
        }

        @Override
        public PluginId getPluginId() {
            return this.pluginId;
        }

        @Override
        public void execute(PluginResolveContext context) {
            context.addLegacy(this.pluginId, this.producingProject.getDependencies().create(this.producingProject));
        }
    }

    private class CompositeBuildPluginResolver
    implements PluginResolver {
        private CompositeBuildPluginResolver() {
        }

        @Override
        public void resolve(PluginRequestInternal pluginRequest, PluginResolutionResult result) throws InvalidPluginRequestException {
            Resolution resolution = (Resolution)CompositeBuildPluginResolverContributor.this.results.get(pluginRequest.getId());
            if (resolution == null) {
                for (IncludedBuildState includedBuildState : CompositeBuildPluginResolverContributor.this.buildRegistry.getIncludedBuilds()) {
                    if (includedBuildState == CompositeBuildPluginResolverContributor.this.consumingBuild || includedBuildState.isImplicitBuild()) continue;
                    Resolution pluginResolution = includedBuildState.withState(gradleInternal -> {
                        ProjectPublicationRegistry publicationRegistry = gradleInternal.getServices().get(ProjectPublicationRegistry.class);
                        for (ProjectPublicationRegistry.Reference<PluginPublication> reference : publicationRegistry.getPublications(PluginPublication.class)) {
                            PluginId pluginId = reference.get().getPluginId();
                            if (!pluginId.equals(pluginRequest.getId())) continue;
                            return new Resolution(new LocalPluginResolution(pluginId, reference.getProducingProject()));
                        }
                        return UNKNOWN;
                    });
                    CompositeBuildPluginResolverContributor.this.results.put(pluginRequest.getId(), pluginResolution);
                    if (pluginResolution == UNKNOWN) continue;
                    result.found("Included Builds", pluginResolution.pluginResolution);
                    return;
                }
            } else if (resolution != UNKNOWN) {
                result.found("Included Builds", resolution.pluginResolution);
                return;
            }
            if (!CompositeBuildPluginResolverContributor.this.buildRegistry.getIncludedBuilds().isEmpty()) {
                result.notFound("Included Builds", "None of the included builds contain this plugin");
            }
        }
    }
}

