/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import org.gradle.internal.impldep.com.google.common.cache.Cache;
import org.gradle.internal.impldep.com.google.common.cache.RemovalCause;
import org.gradle.internal.impldep.com.google.common.cache.RemovalListener;
import org.gradle.internal.impldep.com.google.common.cache.RemovalNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoggingEvictionListener
implements RemovalListener<Object, Object> {
    private static Logger logger = LoggerFactory.getLogger(LoggingEvictionListener.class);
    private static final String EVICTION_MITIGATION_MESSAGE = "\nPerformance may suffer from in-memory cache misses. Increase max heap size of Gradle build process to reduce cache misses.";
    volatile int evictionCounter;
    private final String cacheId;
    private Cache<Object, Object> cache;
    private final int maxSize;
    private final int logInterval;

    LoggingEvictionListener(String cacheId, int maxSize) {
        this.cacheId = cacheId;
        this.maxSize = maxSize;
        this.logInterval = maxSize / 10;
    }

    public void setCache(Cache<Object, Object> cache2) {
        this.cache = cache2;
    }

    public void onRemoval(RemovalNotification<Object, Object> notification) {
        if (notification.getCause() == RemovalCause.SIZE) {
            if (this.evictionCounter % this.logInterval == 0) {
                logger.info("Cache entries evicted. In-memory cache of {}: Size{{}} MaxSize{{}}, {} {}", new Object[]{this.cacheId, this.cache.size(), this.maxSize, this.cache.stats(), EVICTION_MITIGATION_MESSAGE});
            }
            ++this.evictionCounter;
        }
    }
}

