/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.Transformer;
import org.gradle.cache.FileLock;
import org.gradle.cache.internal.InMemoryCacheController;
import org.gradle.cache.internal.MultiProcessSafeAsyncPersistentIndexedCache;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.cache.Cache;
import org.gradle.internal.impldep.com.google.common.util.concurrent.Runnables;
import org.gradle.internal.impldep.com.google.common.util.concurrent.UncheckedExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InMemoryDecoratedCache<K, V>
implements MultiProcessSafeAsyncPersistentIndexedCache<K, V>,
InMemoryCacheController {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryDecoratedCache.class);
    private static final Object NULL = new Object();
    private final MultiProcessSafeAsyncPersistentIndexedCache<K, V> delegate;
    private final Cache<Object, Object> inMemoryCache;
    private final String cacheId;
    private final AtomicReference<FileLock.State> fileLockStateReference;

    public InMemoryDecoratedCache(MultiProcessSafeAsyncPersistentIndexedCache<K, V> delegate, Cache<Object, Object> inMemoryCache, String cacheId, AtomicReference<FileLock.State> fileLockStateReference) {
        this.delegate = delegate;
        this.inMemoryCache = inMemoryCache;
        this.cacheId = cacheId;
        this.fileLockStateReference = fileLockStateReference;
    }

    public String toString() {
        return "{in-memory-cache cache: " + this.delegate + "}";
    }

    @Override
    public V get(final K key) {
        Object value;
        try {
            value = this.inMemoryCache.get(key, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Object out = InMemoryDecoratedCache.this.delegate.get(key);
                    return out == null ? NULL : out;
                }
            });
        }
        catch (ExecutionException | UncheckedExecutionException e) {
            throw UncheckedException.throwAsUncheckedException(e.getCause());
        }
        if (value == NULL) {
            return null;
        }
        return (V)Cast.uncheckedCast(value);
    }

    @Override
    public V get(final K key, final Transformer<? extends V, ? super K> producer, final Runnable completion) {
        Object value;
        final AtomicReference<Runnable> completionRef = new AtomicReference<Runnable>(completion);
        try {
            boolean wasNull;
            value = this.inMemoryCache.getIfPresent(key);
            boolean bl = wasNull = value == NULL;
            if (wasNull) {
                this.inMemoryCache.invalidate(key);
            } else if (value != null) {
                Object t = Cast.uncheckedCast(value);
                return (V)t;
            }
            value = this.inMemoryCache.get(key, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Object out;
                    if (!wasNull && (out = InMemoryDecoratedCache.this.delegate.get(key)) != null) {
                        return out;
                    }
                    Object value = producer.transform(key);
                    InMemoryDecoratedCache.this.delegate.putLater(key, value, completion);
                    completionRef.set(Runnables.doNothing());
                    return value;
                }
            });
        }
        catch (ExecutionException | UncheckedExecutionException e) {
            throw UncheckedException.throwAsUncheckedException(e.getCause());
        }
        finally {
            completionRef.get().run();
        }
        if (value == NULL) {
            return null;
        }
        return (V)Cast.uncheckedCast(value);
    }

    @Override
    public void putLater(K key, V value, Runnable completion) {
        this.inMemoryCache.put(key, value);
        this.delegate.putLater(key, value, completion);
    }

    @Override
    public void removeLater(K key, Runnable completion) {
        this.inMemoryCache.put(key, NULL);
        this.delegate.removeLater(key, completion);
    }

    @Override
    public void afterLockAcquire(FileLock.State currentCacheState) {
        boolean outOfDate = false;
        FileLock.State previousState = this.fileLockStateReference.get();
        if (previousState == null) {
            outOfDate = true;
        } else if (currentCacheState.hasBeenUpdatedSince(previousState)) {
            LOG.info("Invalidating in-memory cache of {}", (Object)this.cacheId);
            outOfDate = true;
        }
        if (outOfDate) {
            this.inMemoryCache.invalidateAll();
        }
        this.delegate.afterLockAcquire(currentCacheState);
    }

    @Override
    public void finishWork() {
        this.delegate.finishWork();
    }

    @Override
    public void beforeLockRelease(FileLock.State currentCacheState) {
        this.fileLockStateReference.set(currentCacheState);
        this.delegate.beforeLockRelease(currentCacheState);
    }

    @Override
    public String getCacheId() {
        return this.cacheId;
    }

    @Override
    public void clearInMemoryCache() {
        this.inMemoryCache.invalidateAll();
    }
}

