/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal.jni;

import java.io.File;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.NativeIntegration;
import net.rubygrapefruit.platform.file.FileWatchEvent;
import net.rubygrapefruit.platform.file.FileWatcher;
import net.rubygrapefruit.platform.internal.jni.InsufficientResourcesForWatchingException;
import net.rubygrapefruit.platform.internal.jni.NativeLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileEventFunctions
implements NativeIntegration {
    public static String getVersion() {
        return AbstractFileEventFunctions.getVersion0();
    }

    private static native String getVersion0();

    public void invalidateLogLevelCache() {
        this.invalidateLogLevelCache0();
    }

    private native void invalidateLogLevelCache0();

    public abstract AbstractWatcherBuilder newWatcher(BlockingQueue<FileWatchEvent> var1);

    public static class FileWatcherTimeoutException
    extends FileWatcherException {
        public FileWatcherTimeoutException(String message2) {
            super(message2);
        }
    }

    public static class FileWatcherException
    extends NativeException {
        public FileWatcherException(String message2) {
            super(message2);
        }
    }

    private static class TerminationEvent
    implements FileWatchEvent {
        public static final TerminationEvent INSTANCE = new TerminationEvent();

        private TerminationEvent() {
        }

        public void handleEvent(FileWatchEvent.Handler handler) {
            handler.handleTerminated();
        }

        public String toString() {
            return "TERMINATE";
        }
    }

    private static class FailureEvent
    implements FileWatchEvent {
        private final Throwable failure;

        public FailureEvent(Throwable failure) {
            this.failure = failure;
        }

        public void handleEvent(FileWatchEvent.Handler handler) {
            handler.handleFailure(this.failure);
        }

        public String toString() {
            return "FAILURE " + this.failure.getMessage();
        }
    }

    private static class UnknownEvent
    implements FileWatchEvent {
        private final String path;

        public UnknownEvent(String path) {
            this.path = path;
        }

        public void handleEvent(FileWatchEvent.Handler handler) {
            handler.handleUnknownEvent(this.path);
        }

        public String toString() {
            return "UNKNOWN " + this.path;
        }
    }

    private static class OverflowEvent
    implements FileWatchEvent {
        private final FileWatchEvent.OverflowType type;
        private final String path;

        public OverflowEvent(FileWatchEvent.OverflowType type, @Nullable String path) {
            this.type = type;
            this.path = path;
        }

        public void handleEvent(FileWatchEvent.Handler handler) {
            handler.handleOverflow(this.type, this.path);
        }

        public String toString() {
            return "OVERFLOW (" + (Object)((Object)this.type) + ") at " + this.path;
        }
    }

    private static class ChangeEvent
    implements FileWatchEvent {
        private final FileWatchEvent.ChangeType type;
        private final String path;

        public ChangeEvent(FileWatchEvent.ChangeType type, String path) {
            this.type = type;
            this.path = path;
        }

        public void handleEvent(FileWatchEvent.Handler handler) {
            handler.handleChangeEvent(this.type, this.path);
        }

        public String toString() {
            return (Object)((Object)this.type) + " " + this.path;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NativeFileWatcher
    implements FileWatcher {
        private final Object server;
        private final Thread processorThread;
        private boolean shutdown;

        public NativeFileWatcher(final Object server, long startTimeout, TimeUnit startTimeoutUnit) throws InterruptedException {
            this.server = server;
            final CountDownLatch runLoopInitialized = new CountDownLatch(1);
            this.processorThread = new Thread("File watcher server"){

                public void run() {
                    NativeFileWatcher.this.initializeRunLoop0(server);
                    runLoopInitialized.countDown();
                    NativeFileWatcher.this.executeRunLoop0(server);
                }
            };
            this.processorThread.setDaemon(true);
            this.processorThread.start();
            boolean started = runLoopInitialized.await(startTimeout, startTimeoutUnit);
            if (!started) {
                throw new FileWatcherTimeoutException("Starting the watcher timed out");
            }
        }

        private native void initializeRunLoop0(Object var1);

        private native void executeRunLoop0(Object var1);

        @Override
        public void startWatching(Collection<File> paths) {
            this.ensureOpen();
            this.startWatching0(this.server, NativeFileWatcher.toAbsolutePaths(paths));
        }

        private native void startWatching0(Object var1, String[] var2);

        @Override
        public boolean stopWatching(Collection<File> paths) {
            this.ensureOpen();
            return this.stopWatching0(this.server, NativeFileWatcher.toAbsolutePaths(paths));
        }

        private native boolean stopWatching0(Object var1, String[] var2);

        private static String[] toAbsolutePaths(Collection<File> files2) {
            String[] paths = new String[files2.size()];
            int index = 0;
            for (File file : files2) {
                paths[index++] = file.getAbsolutePath();
            }
            return paths;
        }

        @Override
        public void shutdown() {
            this.ensureOpen();
            this.shutdown = true;
            this.shutdown0(this.server);
        }

        private native void shutdown0(Object var1);

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            long timeoutInMillis = unit.toMillis(timeout);
            long startTime = System.currentTimeMillis();
            boolean successful = this.awaitTermination0(this.server, timeoutInMillis);
            if (successful) {
                long endTime = System.currentTimeMillis();
                long remainingTimeout = timeoutInMillis - (endTime - startTime);
                this.processorThread.join(remainingTimeout);
                return !this.processorThread.isAlive();
            }
            return false;
        }

        private native boolean awaitTermination0(Object var1, long var2);

        private void ensureOpen() {
            if (this.shutdown) {
                throw new IllegalStateException("Watcher already closed");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NativeFileWatcherCallback {
        private final BlockingQueue<FileWatchEvent> eventQueue;

        public NativeFileWatcherCallback(BlockingQueue<FileWatchEvent> eventQueue) {
            this.eventQueue = eventQueue;
        }

        public void reportChangeEvent(int typeIndex, String path) {
            FileWatchEvent.ChangeType type = FileWatchEvent.ChangeType.values()[typeIndex];
            this.queueEvent(new ChangeEvent(type, path), false);
        }

        public void reportUnknownEvent(String path) {
            this.queueEvent(new UnknownEvent(path), false);
        }

        public void reportOverflow(@Nullable String path) {
            this.signalOverflow(FileWatchEvent.OverflowType.OPERATING_SYSTEM, path);
        }

        public void reportFailure(Throwable ex) {
            this.queueEvent(new FailureEvent(ex), true);
        }

        public void reportTermination() {
            this.queueEvent(TerminationEvent.INSTANCE, true);
        }

        private void queueEvent(FileWatchEvent event, boolean deliverOnOverflow) {
            if (!this.eventQueue.offer(event)) {
                NativeLogger.LOGGER.info("Event queue overflow, dropping all events");
                this.signalOverflow(FileWatchEvent.OverflowType.EVENT_QUEUE, null);
                if (deliverOnOverflow) {
                    this.forceQueueEvent(event);
                }
            }
        }

        private void signalOverflow(FileWatchEvent.OverflowType type, @Nullable String path) {
            this.eventQueue.clear();
            this.forceQueueEvent(new OverflowEvent(type, path));
        }

        private void forceQueueEvent(FileWatchEvent event) {
            boolean eventPublished = this.eventQueue.offer(event);
            if (!eventPublished) {
                NativeLogger.LOGGER.severe("Couldn't queue event: " + event);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractWatcherBuilder {
        public static final long DEFAULT_START_TIMEOUT_IN_SECONDS = 5L;
        private final BlockingQueue<FileWatchEvent> eventQueue;

        public AbstractWatcherBuilder(BlockingQueue<FileWatchEvent> eventQueue) {
            this.eventQueue = eventQueue;
        }

        public FileWatcher start() throws InterruptedException {
            return this.start(5L, TimeUnit.SECONDS);
        }

        public FileWatcher start(long startTimeout, TimeUnit startTimeoutUnit) throws InterruptedException, InsufficientResourcesForWatchingException {
            Object server = this.startWatcher(new NativeFileWatcherCallback(this.eventQueue));
            return new NativeFileWatcher(server, startTimeout, startTimeoutUnit);
        }

        protected abstract Object startWatcher(NativeFileWatcherCallback var1);
    }
}

