/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.parser.GradleDslNameConverter;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.google.common.base.Splitter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleNameElement {
    @NotNull
    public static final Pattern INDEX_PATTERN = Pattern.compile("\\[(.+?)\\]|(.+?)(?=\\[)");
    @NotNull
    private static final Pattern SPACES = Pattern.compile("\\s+");
    @Nullable
    private PsiElement myNameElement;
    @Nullable
    private String myLocalName;
    @Nullable
    private String myFakeName;
    @Nullable
    private String myName;
    @Nullable
    private String myOriginalName;

    @NotNull
    public static GradleNameElement from(@NotNull PsiElement element, GradleDslNameConverter converter) {
        if (element == null) {
            GradleNameElement.$$$reportNull$$$0(0);
        }
        return new GradleNameElement(element, converter);
    }

    @NotNull
    public static GradleNameElement empty() {
        return new GradleNameElement(null, null);
    }

    @NotNull
    public static GradleNameElement create(@NotNull String name) {
        if (name == null) {
            GradleNameElement.$$$reportNull$$$0(1);
        }
        return new GradleNameElement(name, false);
    }

    @NotNull
    public static GradleNameElement fake(@NotNull String name) {
        if (name == null) {
            GradleNameElement.$$$reportNull$$$0(2);
        }
        return new GradleNameElement(name, true);
    }

    @NotNull
    public static GradleNameElement copy(@NotNull GradleNameElement element) {
        if (element == null) {
            GradleNameElement.$$$reportNull$$$0(3);
        }
        return new GradleNameElement(element);
    }

    private GradleNameElement(@Nullable PsiElement element, GradleDslNameConverter converter) {
        this.myName = null;
        this.setUpFrom(element, converter);
    }

    private GradleNameElement(@NotNull String name, boolean isFake) {
        if (name == null) {
            GradleNameElement.$$$reportNull$$$0(4);
        }
        this.myName = null;
        if (isFake) {
            this.myFakeName = name;
        } else {
            this.myLocalName = name;
        }
        this.myOriginalName = name;
    }

    private GradleNameElement(@NotNull GradleNameElement element) {
        if (element == null) {
            GradleNameElement.$$$reportNull$$$0(5);
        }
        this.myName = null;
        this.myLocalName = element.myLocalName;
        this.myFakeName = element.myFakeName;
        this.myOriginalName = element.myOriginalName;
    }

    public void commitNameChange(@Nullable PsiElement nameElement, GradleDslNameConverter converter, GradleDslElement context) {
        this.setUpFrom(nameElement, converter);
        this.canonize(converter.modelNameForParent(this.fullName(), context));
    }

    @NotNull
    public String fullName() {
        List<String> parts = this.qualifyingParts();
        parts.add(this.name());
        String string = GradleNameElement.createNameFromParts(parts);
        if (string == null) {
            GradleNameElement.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public List<String> fullNameParts() {
        List list = Splitter.on((String)".").splitToList((CharSequence)this.fullName());
        if (list == null) {
            GradleNameElement.$$$reportNull$$$0(7);
        }
        return list;
    }

    public static String createNameFromParts(@NotNull List<String> parts) {
        if (parts == null) {
            GradleNameElement.$$$reportNull$$$0(8);
        }
        return String.join((CharSequence)".", parts);
    }

    @NotNull
    public List<String> qualifyingParts() {
        String name = this.findName();
        if (name == null) {
            return new ArrayList<String>();
        }
        List nameSegments = Splitter.on((char)'.').splitToList((CharSequence)name);
        List<String> list = nameSegments.subList(0, nameSegments.size() - 1).stream().map(GradleNameElement::convertNameToKey).collect(Collectors.toList());
        if (list == null) {
            GradleNameElement.$$$reportNull$$$0(9);
        }
        return list;
    }

    public boolean isQualified() {
        String name = this.findName();
        if (name == null) {
            return false;
        }
        return name.contains(".");
    }

    @NotNull
    public String name() {
        String name = this.findName();
        if (name == null) {
            return "";
        }
        int lastDotIndex = name.lastIndexOf(46) + 1;
        return GradleNameElement.convertNameToKey(name.substring(lastDotIndex));
    }

    @Nullable
    public PsiElement getNamedPsiElement() {
        return this.myNameElement;
    }

    @Nullable
    public String getLocalName() {
        return this.myLocalName;
    }

    @Nullable
    public String getOriginalName() {
        return this.myOriginalName;
    }

    public void rename(@NotNull String newName) {
        if (newName == null) {
            GradleNameElement.$$$reportNull$$$0(10);
        }
        if (!this.isFake()) {
            this.myLocalName = newName;
        } else {
            this.myFakeName = newName;
        }
        this.myName = null;
    }

    public void canonize(@NotNull String newName) {
        if (newName == null) {
            GradleNameElement.$$$reportNull$$$0(11);
        }
        this.rename(newName);
        this.myOriginalName = newName;
    }

    public boolean isEmpty() {
        String name = this.findName();
        return name == null || name.isEmpty();
    }

    public boolean isFake() {
        return this.myNameElement == null && this.myFakeName != null;
    }

    @NotNull
    public String toString() {
        String string = this.fullName();
        if (string == null) {
            GradleNameElement.$$$reportNull$$$0(12);
        }
        return string;
    }

    public boolean containsPropertyReference(@NotNull String propertyReference) {
        String indexName;
        String name;
        if (propertyReference == null) {
            GradleNameElement.$$$reportNull$$$0(13);
        }
        if (propertyReference.equals(name = this.name())) {
            return true;
        }
        Matcher matcher = INDEX_PATTERN.matcher(propertyReference);
        if (matcher.find() && matcher.groupCount() > 0 && (indexName = matcher.group(0)).equals(name)) {
            return true;
        }
        List<String> parts = Arrays.asList(propertyReference.split("\\."));
        if (!parts.isEmpty() && parts.get(0).equals(name)) {
            return true;
        }
        return parts.size() > 1 && parts.get(0).equals(ExtDslElement.EXT.name) && parts.get(1).equals(name);
    }

    @Nullable
    private String findName() {
        if (this.myName != null) {
            return this.myName;
        }
        String name = null;
        if (this.myLocalName != null) {
            name = this.myLocalName;
        }
        if (name == null && this.myFakeName != null) {
            name = this.myFakeName;
        }
        if (name != null) {
            name = SPACES.matcher(name).replaceAll("");
        }
        this.myName = name;
        return name;
    }

    @NotNull
    public static String convertNameToKey(@NotNull String str) {
        if (str == null) {
            GradleNameElement.$$$reportNull$$$0(14);
        }
        String string = StringUtil.unquoteString((String)str);
        if (string == null) {
            GradleNameElement.$$$reportNull$$$0(15);
        }
        return string;
    }

    private void setUpFrom(@Nullable PsiElement element, GradleDslNameConverter converter) {
        this.myNameElement = element;
        if (this.myNameElement instanceof PsiNamedElement) {
            this.myLocalName = ((PsiNamedElement)this.myNameElement).getName();
        } else if (this.myNameElement != null) {
            this.myLocalName = converter.psiToName(this.myNameElement);
        }
        this.myOriginalName = this.myLocalName;
        this.myName = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/elements/GradleNameElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyReference";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/elements/GradleNameElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fullName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fullNameParts";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifyingParts";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "convertNameToKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fake";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 15: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createNameFromParts";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canonize";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "containsPropertyReference";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "convertNameToKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

