/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Incubating;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.TestLauncher;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.internal.daemon.DaemonState;
import org.jetbrains.plugins.gradle.internal.daemon.GradleDaemonServices;
import org.jetbrains.plugins.gradle.service.project.DistributionFactoryExt;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

@Service
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 \u00112\u00020\u0001:\u0004\u0011\u0012\u0013\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\nH\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/gradle/GradleConnectorService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "connectorsMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/jetbrains/plugins/gradle/GradleConnectorService$GradleProjectConnection;", "disconnectGradleConnections", "", "dispose", "getConnection", "Lorg/gradle/tooling/ProjectConnection;", "connectorParams", "Lorg/jetbrains/plugins/gradle/GradleConnectorService$ConnectorParams;", "stopIdleDaemonsOfOldVersions", "Companion", "ConnectorParams", "GradleProjectConnection", "WrappedConnection", "intellij.gradle.common"})
@ApiStatus.Internal
public final class GradleConnectorService
implements Disposable {
    private final ConcurrentHashMap<String, GradleProjectConnection> connectorsMap;
    private static final Logger LOG;
    private static final boolean DISABLE_STOP_OLD_IDLE_DAEMONS;
    public static final Companion Companion;

    public void dispose() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return;
        }
        this.disconnectGradleConnections();
        this.stopIdleDaemonsOfOldVersions();
    }

    /*
     * WARNING - void declaration
     */
    private final void stopIdleDaemonsOfOldVersions() {
        if (DISABLE_STOP_OLD_IDLE_DAEMONS) {
            return;
        }
        try {
            Project[] projectArray = ProjectUtil.getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"ProjectUtil.getOpenProjects()");
            Project[] projectArray2 = projectArray;
            boolean bl = false;
            if (projectArray2.length == 0) {
                void $this$filterTo$iv$iv;
                GradleVersion gradleVersion_6_5 = GradleVersion.version((String)"6.5");
                List<DaemonState> list = GradleDaemonServices.getDaemonsStatus();
                Intrinsics.checkNotNullExpressionValue(list, (String)"GradleDaemonServices.getDaemonsStatus()");
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String string;
                    DaemonState it = (DaemonState)element$iv$iv;
                    boolean bl2 = false;
                    DaemonState daemonState = it;
                    Intrinsics.checkNotNullExpressionValue((Object)daemonState, (String)"it");
                    Intrinsics.checkNotNullExpressionValue((Object)daemonState.getStatus(), (String)"it.status");
                    boolean bl3 = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                    if (!(Intrinsics.areEqual((Object)string3, (Object)"idle") && GradleVersion.version((String)it.getVersion()).compareTo(gradleVersion_6_5) < 0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List idleDaemons = (List)destination$iv$iv;
                Collection collection = idleDaemons;
                boolean bl4 = false;
                if (!collection.isEmpty()) {
                    GradleDaemonServices.stopDaemons(idleDaemons);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to stop Gradle daemons during project close", (Throwable)e);
        }
    }

    private final void disconnectGradleConnections() {
        Collection<GradleProjectConnection> collection = this.connectorsMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"connectorsMap.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GradleProjectConnection p1 = (GradleProjectConnection)element$iv;
            boolean bl = false;
            p1.disconnect();
        }
        this.connectorsMap.clear();
    }

    private final ProjectConnection getConnection(ConnectorParams connectorParams) {
        GradleProjectConnection gradleProjectConnection = this.connectorsMap.compute(connectorParams.getProjectPath(), new BiFunction<String, GradleProjectConnection, GradleProjectConnection>(connectorParams){
            final /* synthetic */ ConnectorParams $connectorParams;

            @Nullable
            public final GradleProjectConnection apply(@NotNull String $noName_0, @Nullable GradleProjectConnection conn) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                GradleProjectConnection gradleProjectConnection = conn;
                if (Intrinsics.areEqual((Object)this.$connectorParams, (Object)(gradleProjectConnection != null ? gradleProjectConnection.getParams() : null))) {
                    return conn;
                }
                GradleConnector newConnector = org.jetbrains.plugins.gradle.GradleConnectorService$Companion.access$createConnector(GradleConnectorService.Companion, this.$connectorParams);
                ProjectConnection newConnection = newConnector.connect();
                boolean bl = newConnection != null;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = "Can't create connection to the target project via gradle tooling api. Project path: '" + this.$connectorParams.getProjectPath() + '\'';
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                if (conn != null && Intrinsics.areEqual((Object)this.$connectorParams, (Object)conn.getParams()) ^ true) {
                    ProjectConnection projectConnection = conn.getConnection();
                    if (projectConnection == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.plugins.gradle.GradleConnectorService.WrappedConnection");
                    }
                    WrappedConnection unwrappedConnection = (WrappedConnection)projectConnection;
                    unwrappedConnection.getDelegate().close();
                }
                WrappedConnection wrappedConnection = new WrappedConnection(newConnection);
                return new GradleProjectConnection(this.$connectorParams, newConnector, wrappedConnection);
            }
            {
                this.$connectorParams = connectorParams;
            }
        });
        Intrinsics.checkNotNull((Object)gradleProjectConnection);
        return gradleProjectConnection.getConnection();
    }

    public GradleConnectorService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.connectorsMap = new ConcurrentHashMap();
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GradleConnectorService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        DISABLE_STOP_OLD_IDLE_DAEMONS = Boolean.getBoolean("idea.gradle.disableStopIdleDaemonsOnProjectClose");
    }

    @JvmStatic
    private static final GradleConnectorService getInstance(String projectPath, ExternalSystemTaskId taskId) {
        return GradleConnectorService.Companion.getInstance(projectPath, taskId);
    }

    @JvmStatic
    public static final <R> R withGradleConnection(@NotNull String projectPath, @Nullable ExternalSystemTaskId taskId, @Nullable GradleExecutionSettings executionSettings, @Nullable ExternalSystemTaskNotificationListener listener2, @Nullable CancellationToken cancellationToken, @NotNull Function<ProjectConnection, R> function) {
        return Companion.withGradleConnection(projectPath, taskId, executionSettings, listener2, cancellationToken, function);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/GradleConnectorService$GradleProjectConnection;", "", "params", "Lorg/jetbrains/plugins/gradle/GradleConnectorService$ConnectorParams;", "connector", "Lorg/gradle/tooling/GradleConnector;", "connection", "Lorg/gradle/tooling/ProjectConnection;", "(Lorg/jetbrains/plugins/gradle/GradleConnectorService$ConnectorParams;Lorg/gradle/tooling/GradleConnector;Lorg/gradle/tooling/ProjectConnection;)V", "getConnection", "()Lorg/gradle/tooling/ProjectConnection;", "getConnector", "()Lorg/gradle/tooling/GradleConnector;", "getParams", "()Lorg/jetbrains/plugins/gradle/GradleConnectorService$ConnectorParams;", "disconnect", "", "intellij.gradle.common"})
    private static final class GradleProjectConnection {
        @NotNull
        private final ConnectorParams params;
        @NotNull
        private final GradleConnector connector;
        @NotNull
        private final ProjectConnection connection;

        public final void disconnect() {
            try {
                this.connector.disconnect();
            }
            catch (Exception e) {
                LOG.warn("Failed to disconnect Gradle connector during project close. Project path: '" + this.params.getProjectPath() + '\'', (Throwable)e);
            }
        }

        @NotNull
        public final ConnectorParams getParams() {
            return this.params;
        }

        @NotNull
        public final GradleConnector getConnector() {
            return this.connector;
        }

        @NotNull
        public final ProjectConnection getConnection() {
            return this.connection;
        }

        public GradleProjectConnection(@NotNull ConnectorParams params, @NotNull GradleConnector connector, @NotNull ProjectConnection connection) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            this.params = params;
            this.connector = connector;
            this.connection = connection;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0011\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007H\u0096\u0001Jk\u0010\u0006\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u0001H\nH\n \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u0001H\nH\n\u0018\u00010\t0\t\"\u0010\b\u0000\u0010\n*\n \b*\u0004\u0018\u00010\u000b0\u000b2*\u0010\f\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u0001H\nH\n \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u0001H\nH\n\u0018\u00010\r0\rH\u0096\u0001J\b\u0010\u000e\u001a\u00020\u000fH\u0016JT\u0010\u0010\u001a\n \b*\u0004\u0018\u0001H\nH\n\"\u0010\b\u0000\u0010\n*\n \b*\u0004\u0018\u00010\u000b0\u000b2*\u0010\f\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u0001H\nH\n \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u0001H\nH\n\u0018\u00010\u00110\u0011H\u0096\u0001\u00a2\u0006\u0002\u0010\u0012Jw\u0010\u0010\u001a\u00020\u000f\"\u0010\b\u0000\u0010\n*\n \b*\u0004\u0018\u00010\u000b0\u000b2*\u0010\f\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u0001H\nH\n \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u0001H\nH\n\u0018\u00010\u00110\u00112.\u0010\u0013\u001a*\u0012\u000e\b\u0000\u0012\n \b*\u0004\u0018\u0001H\nH\n \b*\u0014\u0012\u000e\b\u0000\u0012\n \b*\u0004\u0018\u0001H\nH\n\u0018\u00010\u00140\u0014H\u0096\u0001Jk\u0010\u0015\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u0001H\nH\n \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u0001H\nH\n\u0018\u00010\u00160\u0016\"\u0010\b\u0000\u0010\n*\n \b*\u0004\u0018\u00010\u000b0\u000b2*\u0010\f\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u0001H\nH\n \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u0001H\nH\n\u0018\u00010\u00110\u0011H\u0096\u0001J\u0011\u0010\u0017\u001a\n \b*\u0004\u0018\u00010\u00180\u0018H\u0096\u0001J\u0011\u0010\u0019\u001a\n \b*\u0004\u0018\u00010\u001a0\u001aH\u0096\u0001J5\u0010\u001b\u001a\u00020\u000f2*\u0010\f\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u001d0\u001d \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u001d0\u001d\u0018\u00010\u001e0\u001cH\u0097\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/gradle/GradleConnectorService$WrappedConnection;", "Lorg/gradle/tooling/ProjectConnection;", "delegate", "(Lorg/gradle/tooling/ProjectConnection;)V", "getDelegate", "()Lorg/gradle/tooling/ProjectConnection;", "action", "Lorg/gradle/tooling/BuildActionExecuter$Builder;", "kotlin.jvm.PlatformType", "Lorg/gradle/tooling/BuildActionExecuter;", "T", "", "p0", "Lorg/gradle/tooling/BuildAction;", "close", "", "getModel", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "p1", "Lorg/gradle/tooling/ResultHandler;", "model", "Lorg/gradle/tooling/ModelBuilder;", "newBuild", "Lorg/gradle/tooling/BuildLauncher;", "newTestLauncher", "Lorg/gradle/tooling/TestLauncher;", "notifyDaemonsAboutChangedPaths", "", "Ljava/nio/file/Path;", "", "intellij.gradle.common"})
    private static final class WrappedConnection
    implements ProjectConnection {
        @NotNull
        private final ProjectConnection delegate;

        public void close() {
            throw (Throwable)new IllegalStateException("This connection should not be closed explicitly.");
        }

        @NotNull
        public final ProjectConnection getDelegate() {
            return this.delegate;
        }

        public WrappedConnection(@NotNull ProjectConnection delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.delegate = delegate;
        }

        public BuildActionExecuter.Builder action() {
            return this.delegate.action();
        }

        public <T> BuildActionExecuter<T> action(BuildAction<T> p0) {
            return this.delegate.action(p0);
        }

        public <T> T getModel(Class<T> p0) {
            return (T)this.delegate.getModel(p0);
        }

        public <T> void getModel(Class<T> p0, ResultHandler<? super T> p1) {
            this.delegate.getModel(p0, p1);
        }

        public <T> ModelBuilder<T> model(Class<T> p0) {
            return this.delegate.model(p0);
        }

        public BuildLauncher newBuild() {
            return this.delegate.newBuild();
        }

        public TestLauncher newTestLauncher() {
            return this.delegate.newTestLauncher();
        }

        @Incubating
        public void notifyDaemonsAboutChangedPaths(List<Path> p0) {
            this.delegate.notifyDaemonsAboutChangedPaths(p0);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u001e\b\u0082\b\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010#\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010$\u001a\u0004\u0018\u00010\rH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0017Jl\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u00c6\u0001\u00a2\u0006\u0002\u0010&J\u0013\u0010'\u001a\u00020\u000b2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020\rH\u00d6\u0001J\t\u0010*\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0015\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\u0015\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0012\u00a8\u0006+"}, d2={"Lorg/jetbrains/plugins/gradle/GradleConnectorService$ConnectorParams;", "", "projectPath", "", "serviceDirectory", "distributionType", "Lorg/jetbrains/plugins/gradle/settings/DistributionType;", "gradleHome", "javaHome", "wrapperPropertyFile", "verboseProcessing", "", "ttlMs", "", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/plugins/gradle/settings/DistributionType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Integer;)V", "getDistributionType", "()Lorg/jetbrains/plugins/gradle/settings/DistributionType;", "getGradleHome", "()Ljava/lang/String;", "getJavaHome", "getProjectPath", "getServiceDirectory", "getTtlMs", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getVerboseProcessing", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getWrapperPropertyFile", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/plugins/gradle/settings/DistributionType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Integer;)Lorg/jetbrains/plugins/gradle/GradleConnectorService$ConnectorParams;", "equals", "other", "hashCode", "toString", "intellij.gradle.common"})
    private static final class ConnectorParams {
        @NotNull
        private final String projectPath;
        @Nullable
        private final String serviceDirectory;
        @Nullable
        private final DistributionType distributionType;
        @Nullable
        private final String gradleHome;
        @Nullable
        private final String javaHome;
        @Nullable
        private final String wrapperPropertyFile;
        @Nullable
        private final Boolean verboseProcessing;
        @Nullable
        private final Integer ttlMs;

        @NotNull
        public final String getProjectPath() {
            return this.projectPath;
        }

        @Nullable
        public final String getServiceDirectory() {
            return this.serviceDirectory;
        }

        @Nullable
        public final DistributionType getDistributionType() {
            return this.distributionType;
        }

        @Nullable
        public final String getGradleHome() {
            return this.gradleHome;
        }

        @Nullable
        public final String getJavaHome() {
            return this.javaHome;
        }

        @Nullable
        public final String getWrapperPropertyFile() {
            return this.wrapperPropertyFile;
        }

        @Nullable
        public final Boolean getVerboseProcessing() {
            return this.verboseProcessing;
        }

        @Nullable
        public final Integer getTtlMs() {
            return this.ttlMs;
        }

        public ConnectorParams(@NotNull String projectPath, @Nullable String serviceDirectory, @Nullable DistributionType distributionType, @Nullable String gradleHome, @Nullable String javaHome, @Nullable String wrapperPropertyFile, @Nullable Boolean verboseProcessing, @Nullable Integer ttlMs) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            this.projectPath = projectPath;
            this.serviceDirectory = serviceDirectory;
            this.distributionType = distributionType;
            this.gradleHome = gradleHome;
            this.javaHome = javaHome;
            this.wrapperPropertyFile = wrapperPropertyFile;
            this.verboseProcessing = verboseProcessing;
            this.ttlMs = ttlMs;
        }

        @NotNull
        public final String component1() {
            return this.projectPath;
        }

        @Nullable
        public final String component2() {
            return this.serviceDirectory;
        }

        @Nullable
        public final DistributionType component3() {
            return this.distributionType;
        }

        @Nullable
        public final String component4() {
            return this.gradleHome;
        }

        @Nullable
        public final String component5() {
            return this.javaHome;
        }

        @Nullable
        public final String component6() {
            return this.wrapperPropertyFile;
        }

        @Nullable
        public final Boolean component7() {
            return this.verboseProcessing;
        }

        @Nullable
        public final Integer component8() {
            return this.ttlMs;
        }

        @NotNull
        public final ConnectorParams copy(@NotNull String projectPath, @Nullable String serviceDirectory, @Nullable DistributionType distributionType, @Nullable String gradleHome, @Nullable String javaHome, @Nullable String wrapperPropertyFile, @Nullable Boolean verboseProcessing, @Nullable Integer ttlMs) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            return new ConnectorParams(projectPath, serviceDirectory, distributionType, gradleHome, javaHome, wrapperPropertyFile, verboseProcessing, ttlMs);
        }

        public static /* synthetic */ ConnectorParams copy$default(ConnectorParams connectorParams, String string, String string2, DistributionType distributionType, String string3, String string4, String string5, Boolean bl, Integer n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = connectorParams.projectPath;
            }
            if ((n2 & 2) != 0) {
                string2 = connectorParams.serviceDirectory;
            }
            if ((n2 & 4) != 0) {
                distributionType = connectorParams.distributionType;
            }
            if ((n2 & 8) != 0) {
                string3 = connectorParams.gradleHome;
            }
            if ((n2 & 0x10) != 0) {
                string4 = connectorParams.javaHome;
            }
            if ((n2 & 0x20) != 0) {
                string5 = connectorParams.wrapperPropertyFile;
            }
            if ((n2 & 0x40) != 0) {
                bl = connectorParams.verboseProcessing;
            }
            if ((n2 & 0x80) != 0) {
                n = connectorParams.ttlMs;
            }
            return connectorParams.copy(string, string2, distributionType, string3, string4, string5, bl, n);
        }

        @NotNull
        public String toString() {
            return "ConnectorParams(projectPath=" + this.projectPath + ", serviceDirectory=" + this.serviceDirectory + ", distributionType=" + (Object)((Object)this.distributionType) + ", gradleHome=" + this.gradleHome + ", javaHome=" + this.javaHome + ", wrapperPropertyFile=" + this.wrapperPropertyFile + ", verboseProcessing=" + this.verboseProcessing + ", ttlMs=" + this.ttlMs + ")";
        }

        public int hashCode() {
            String string = this.projectPath;
            String string2 = this.serviceDirectory;
            DistributionType distributionType = this.distributionType;
            String string3 = this.gradleHome;
            String string4 = this.javaHome;
            String string5 = this.wrapperPropertyFile;
            Boolean bl = this.verboseProcessing;
            Integer n = this.ttlMs;
            return (((((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (distributionType != null ? ((Object)((Object)distributionType)).hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (string5 != null ? string5.hashCode() : 0)) * 31 + (bl != null ? ((Object)bl).hashCode() : 0)) * 31 + (n != null ? ((Object)n).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ConnectorParams)) break block3;
                    ConnectorParams connectorParams = (ConnectorParams)object;
                    if (!Intrinsics.areEqual((Object)this.projectPath, (Object)connectorParams.projectPath) || !Intrinsics.areEqual((Object)this.serviceDirectory, (Object)connectorParams.serviceDirectory) || !Intrinsics.areEqual((Object)((Object)this.distributionType), (Object)((Object)connectorParams.distributionType)) || !Intrinsics.areEqual((Object)this.gradleHome, (Object)connectorParams.gradleHome) || !Intrinsics.areEqual((Object)this.javaHome, (Object)connectorParams.javaHome) || !Intrinsics.areEqual((Object)this.wrapperPropertyFile, (Object)connectorParams.wrapperPropertyFile) || !Intrinsics.areEqual((Object)this.verboseProcessing, (Object)connectorParams.verboseProcessing) || !Intrinsics.areEqual((Object)this.ttlMs, (Object)connectorParams.ttlMs)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0003J]\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u0002H\u00130\u001bH\u0007\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/gradle/GradleConnectorService$Companion;", "", "()V", "DISABLE_STOP_OLD_IDLE_DAEMONS", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createConnector", "Lorg/gradle/tooling/GradleConnector;", "connectorParams", "Lorg/jetbrains/plugins/gradle/GradleConnectorService$ConnectorParams;", "getInstance", "Lorg/jetbrains/plugins/gradle/GradleConnectorService;", "projectPath", "", "taskId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "withGradleConnection", "R", "executionSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;", "listener", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "cancellationToken", "Lorg/gradle/tooling/CancellationToken;", "function", "Ljava/util/function/Function;", "Lorg/gradle/tooling/ProjectConnection;", "(Ljava/lang/String;Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;Lorg/gradle/tooling/CancellationToken;Ljava/util/function/Function;)Ljava/lang/Object;", "intellij.gradle.common"})
    public static final class Companion {
        @JvmStatic
        private final GradleConnectorService getInstance(String projectPath, ExternalSystemTaskId taskId) {
            Project project;
            ExternalSystemTaskId externalSystemTaskId = taskId;
            Object object = project = externalSystemTaskId != null ? externalSystemTaskId.findProject() : null;
            if (project == null) {
                Project[] projectArray = ProjectUtil.getOpenProjects();
                int n = projectArray.length;
                for (int j = 0; j < n; ++j) {
                    String projectBasePath;
                    Project openProject;
                    Project project2 = openProject = projectArray[j];
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"openProject");
                    if (project2.getBasePath() == null) {
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)projectBasePath, (String)"openProject.basePath ?: continue");
                    if (!FileUtil.isAncestor((String)projectBasePath, (String)projectPath, (boolean)false)) continue;
                    project = openProject;
                    break;
                }
            }
            Project project3 = project;
            return project3 != null ? (GradleConnectorService)project3.getService(GradleConnectorService.class) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final <R> R withGradleConnection(@NotNull String projectPath, @Nullable ExternalSystemTaskId taskId, @Nullable GradleExecutionSettings executionSettings, @Nullable ExternalSystemTaskNotificationListener listener2, @Nullable CancellationToken cancellationToken, @NotNull Function<ProjectConnection, R> function) {
            R r;
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter(function, (String)"function");
            GradleExecutionSettings gradleExecutionSettings = executionSettings;
            GradleExecutionSettings gradleExecutionSettings2 = executionSettings;
            GradleExecutionSettings gradleExecutionSettings3 = executionSettings;
            GradleExecutionSettings gradleExecutionSettings4 = executionSettings;
            GradleExecutionSettings gradleExecutionSettings5 = executionSettings;
            GradleExecutionSettings gradleExecutionSettings6 = executionSettings;
            GradleExecutionSettings gradleExecutionSettings7 = executionSettings;
            ConnectorParams connectionParams = new ConnectorParams(projectPath, gradleExecutionSettings != null ? gradleExecutionSettings.getServiceDirectory() : null, gradleExecutionSettings2 != null ? gradleExecutionSettings2.getDistributionType() : null, gradleExecutionSettings3 != null ? gradleExecutionSettings3.getGradleHome() : null, gradleExecutionSettings4 != null ? gradleExecutionSettings4.getJavaHome() : null, gradleExecutionSettings5 != null ? gradleExecutionSettings5.getWrapperPropertyFile() : null, gradleExecutionSettings6 != null ? Boolean.valueOf(gradleExecutionSettings6.isVerboseProcessing()) : null, gradleExecutionSettings7 != null ? Integer.valueOf((int)gradleExecutionSettings7.getRemoteProcessIdleTtlInMs()) : null);
            GradleConnectorService connectionService = this.getInstance(projectPath, taskId);
            if (connectionService != null) {
                ProjectConnection connection = connectionService.getConnection(connectionParams);
                return function.apply(connection);
            }
            GradleConnector newConnector = this.createConnector(connectionParams);
            ProjectConnection connection = newConnector.connect();
            Closeable closeable = (Closeable)connection;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                ProjectConnection p1 = (ProjectConnection)closeable;
                boolean bl3 = false;
                r = function.apply(p1);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return r;
        }

        public static /* synthetic */ Object withGradleConnection$default(Companion companion, String string, ExternalSystemTaskId externalSystemTaskId, GradleExecutionSettings gradleExecutionSettings, ExternalSystemTaskNotificationListener externalSystemTaskNotificationListener, CancellationToken cancellationToken, Function function, int n, Object object) {
            if ((n & 4) != 0) {
                gradleExecutionSettings = null;
            }
            if ((n & 8) != 0) {
                externalSystemTaskNotificationListener = null;
            }
            if ((n & 0x10) != 0) {
                cancellationToken = null;
            }
            return companion.withGradleConnection(string, externalSystemTaskId, gradleExecutionSettings, externalSystemTaskNotificationListener, cancellationToken, function);
        }

        private final GradleConnector createConnector(ConnectorParams connectorParams) {
            int ttl;
            int n;
            Application app;
            File gradleUserHome;
            GradleConnector connector = GradleConnector.newConnector();
            File projectDir = new File(connectorParams.getProjectPath());
            File file = gradleUserHome = connectorParams.getServiceDirectory() == null ? null : new File(connectorParams.getServiceDirectory());
            if (connectorParams.getDistributionType() == DistributionType.LOCAL) {
                File gradleHome;
                File file2 = gradleHome = connectorParams.getGradleHome() == null ? null : new File(connectorParams.getGradleHome());
                if (gradleHome != null) {
                    connector.useInstallation(gradleHome);
                }
            } else if (connectorParams.getDistributionType() == DistributionType.WRAPPED && connectorParams.getWrapperPropertyFile() != null) {
                DistributionFactoryExt.setWrappedDistribution(connector, connectorParams.getWrapperPropertyFile(), gradleUserHome, projectDir);
            }
            if (gradleUserHome != null) {
                connector.useGradleUserHomeDir(gradleUserHome);
            }
            if (Intrinsics.areEqual((Object)connectorParams.getVerboseProcessing(), (Object)true) && connector instanceof DefaultGradleConnector) {
                ((DefaultGradleConnector)connector).setVerboseLogging(true);
            }
            if ((app = ApplicationManager.getApplication()) != null && app.isUnitTestMode()) {
                n = 10000;
            } else {
                Integer n2 = connectorParams.getTtlMs();
                n = ttl = n2 != null ? n2 : -1;
            }
            if (ttl > 0 && connector instanceof DefaultGradleConnector) {
                ((DefaultGradleConnector)connector).daemonMaxIdleTime(ttl, TimeUnit.MILLISECONDS);
            }
            connector.forProjectDirectory(projectDir);
            GradleConnector gradleConnector = connector;
            Intrinsics.checkNotNullExpressionValue((Object)gradleConnector, (String)"connector");
            return gradleConnector;
        }

        private Companion() {
        }

        public static final /* synthetic */ GradleConnector access$createConnector(Companion $this, ConnectorParams connectorParams) {
            return $this.createConnector(connectorParams);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

