/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction.features.vcs;

import com.intellij.filePrediction.features.FilePredictionFeature;
import com.intellij.filePrediction.features.FilePredictionFeatureProvider;
import com.intellij.filePrediction.features.FilePredictionFeaturesCache;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/filePrediction/features/vcs/FilePredictionVcsFeatures;", "Lcom/intellij/filePrediction/features/FilePredictionFeatureProvider;", "()V", "calculateFileFeatures", "", "", "Lcom/intellij/filePrediction/features/FilePredictionFeature;", "project", "Lcom/intellij/openapi/project/Project;", "newFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "prevFile", "cache", "Lcom/intellij/filePrediction/features/FilePredictionFeaturesCache;", "getFeatures", "", "getName", "Companion", "intellij.filePrediction"})
public final class FilePredictionVcsFeatures
implements FilePredictionFeatureProvider {
    private static final ArrayList<String> FEATURES;
    public static final Companion Companion;

    @Override
    @NotNull
    public String getName() {
        return "vcs";
    }

    @Override
    @NotNull
    public List<String> getFeatures() {
        return FEATURES;
    }

    @Override
    @NotNull
    public Map<String, FilePredictionFeature> calculateFileFeatures(@NotNull Project project, @NotNull VirtualFile newFile, @Nullable VirtualFile prevFile, @NotNull FilePredictionFeaturesCache cache) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)newFile, (String)"newFile");
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        if (!ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss()) {
            return MapsKt.emptyMap();
        }
        HashMap result2 = new HashMap();
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"ChangeListManager.getInstance(project)");
        ChangeListManager changeListManager2 = changeListManager;
        if (prevFile != null) {
            ((Map)result2).put("prev_in_changelist", FilePredictionFeature.Companion.binary(changeListManager2.isFileAffected(prevFile)));
        }
        ((Map)result2).put("in_changelist", FilePredictionFeature.Companion.binary(changeListManager2.isFileAffected(newFile)));
        return result2;
    }

    static {
        Companion = new Companion(null);
        FEATURES = CollectionsKt.arrayListOf((Object[])new String[]{"in_changelist", "prev_in_changelist", "related_prob"});
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/filePrediction/features/vcs/FilePredictionVcsFeatures$Companion;", "", "()V", "FEATURES", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "intellij.filePrediction"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

