/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sa.jdi;

import com.jetbrains.sa.jdi.ArrayTypeImpl;
import com.jetbrains.sa.jdi.ClassLoaderReferenceImpl;
import com.jetbrains.sa.jdi.ClassObjectReferenceImpl;
import com.jetbrains.sa.jdi.CompatibilityHelper;
import com.jetbrains.sa.jdi.FieldImpl;
import com.jetbrains.sa.jdi.InterfaceTypeImpl;
import com.jetbrains.sa.jdi.JvmUtils;
import com.jetbrains.sa.jdi.MethodImpl;
import com.jetbrains.sa.jdi.ObjectReferenceImpl;
import com.jetbrains.sa.jdi.SDE;
import com.jetbrains.sa.jdi.TypeImpl;
import com.jetbrains.sa.jdi.ValueImpl;
import com.jetbrains.sa.jdi.VirtualMachineImpl;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.ArrayKlass;
import sun.jvm.hotspot.oops.DefaultHeapVisitor;
import sun.jvm.hotspot.oops.Field;
import sun.jvm.hotspot.oops.HeapVisitor;
import sun.jvm.hotspot.oops.Instance;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.tools.jcore.ClassWriter;
import sun.jvm.hotspot.utilities.Assert;

public abstract class ReferenceTypeImpl
extends TypeImpl {
    private final Klass saKlass;
    private Instance javaMirror;
    private int modifiers = -1;
    private String signature = null;
    private String typeName;
    private SoftReference<SDE> sdeRef = null;
    private SoftReference<List<FieldImpl>> fieldsCache;
    private SoftReference<List<FieldImpl>> allFieldsCache;
    private SoftReference<List<MethodImpl>> methodsCache;
    private SoftReference<List<ReferenceTypeImpl>> nestedTypesCache;
    private SoftReference<List<MethodImpl>> methodInvokesCache;
    protected final VirtualMachineImpl vm;
    static final SDE NO_SDE_INFO_MARK = new SDE();

    protected ReferenceTypeImpl(VirtualMachineImpl aVm, Klass klass) {
        this.vm = aVm;
        this.saKlass = klass;
    }

    public abstract byte tag();

    public String name() {
        if (this.typeName == null) {
            Symbol typeNameSymbol = this.saKlass.getName();
            if (Assert.ASSERTS_ENABLED) {
                Assert.that((typeNameSymbol != null ? 1 : 0) != 0, (String)"null type name for a Klass");
            }
            this.typeName = typeNameSymbol.asString();
        }
        return this.typeName;
    }

    MethodImpl getMethodMirror(Method ref) {
        for (MethodImpl method1 : this.methods()) {
            MethodImpl methodImpl = method1;
            if (!ref.equals((Object)methodImpl.ref())) continue;
            return methodImpl;
        }
        if (ref.getMethodHolder().equals((Object)CompatibilityHelper.INSTANCE.getMethodHandleKlass())) {
            List<Object> mis;
            if (this.methodInvokesCache == null) {
                mis = new ArrayList();
                this.methodInvokesCache = new SoftReference<List<Object>>(mis);
            } else {
                mis = this.methodInvokesCache.get();
            }
            for (MethodImpl methodImpl : mis) {
                MethodImpl method = methodImpl;
                if (!ref.equals((Object)method.ref())) continue;
                return method;
            }
            MethodImpl method = MethodImpl.createMethodImpl(this, ref);
            mis.add(method);
            return method;
        }
        throw new IllegalArgumentException("Invalid method id: " + ref);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ReferenceTypeImpl) {
            return this.ref().equals((Object)((ReferenceTypeImpl)obj).ref());
        }
        return false;
    }

    public int hashCode() {
        return this.saKlass.hashCode();
    }

    public int compareTo(ReferenceTypeImpl refType) {
        ReferenceTypeImpl other = refType;
        int comp = this.name().compareTo(other.name());
        if (comp == 0) {
            Klass rf2;
            Klass rf1 = this.ref();
            comp = rf1.equals((Object)(rf2 = other.ref())) ? this.vm.sequenceNumber - other.vm.sequenceNumber : (CompatibilityHelper.INSTANCE.getAddress(rf1).minus(CompatibilityHelper.INSTANCE.getAddress(rf2)) < 0L ? -1 : 1);
        }
        return comp;
    }

    public String signature() {
        if (this.signature == null) {
            this.signature = this.saKlass.signature();
        }
        return this.signature;
    }

    public String genericSignature() {
        if (this.saKlass instanceof ArrayKlass) {
            return null;
        }
        Symbol genSig = ((InstanceKlass)this.saKlass).getGenericSignature();
        return genSig != null ? genSig.asString() : null;
    }

    public ClassLoaderReferenceImpl classLoader() {
        Instance xx = (Instance)((InstanceKlass)this.saKlass).getClassLoader();
        return this.vm.classLoaderMirror(xx);
    }

    public boolean isAbstract() {
        return ((long)this.modifiers() & 0x400L) != 0L;
    }

    public boolean isPrepared() {
        return (this.saKlass.getClassStatus() & 2) != 0;
    }

    final void checkPrepared() throws ClassNotPreparedException {
        if (!this.isPrepared()) {
            throw new ClassNotPreparedException();
        }
    }

    private boolean isThrowableBacktraceField(Field fld) {
        return JvmUtils.nameEquals(fld.getFieldHolder().getName(), this.vm.javaLangThrowable) && fld.getID().getName().equals("backtrace");
    }

    public final FieldImpl fieldById(long id) throws ClassNotPreparedException {
        for (FieldImpl field : this.allFields()) {
            if (field.uniqueID() != id) continue;
            return field;
        }
        throw new IllegalStateException("Field with id " + id + " not found in " + this.name());
    }

    public final List<FieldImpl> fields() throws ClassNotPreparedException {
        List<FieldImpl> fields;
        List<FieldImpl> list = fields = this.fieldsCache != null ? this.fieldsCache.get() : null;
        if (fields == null) {
            this.checkPrepared();
            if (this.saKlass instanceof ArrayKlass) {
                fields = Collections.emptyList();
            } else {
                List saFields = ((InstanceKlass)this.saKlass).getImmediateFields();
                int len = saFields.size();
                fields = new ArrayList<FieldImpl>(len);
                for (Object saField : saFields) {
                    Field curField = (Field)saField;
                    if (this.isThrowableBacktraceField(curField)) continue;
                    fields.add(new FieldImpl(this, curField));
                }
            }
            fields = Collections.unmodifiableList(fields);
            this.fieldsCache = new SoftReference<List<FieldImpl>>(fields);
        }
        return fields;
    }

    public final List<FieldImpl> allFields() throws ClassNotPreparedException {
        List<FieldImpl> allFields;
        List<FieldImpl> list = allFields = this.allFieldsCache != null ? this.allFieldsCache.get() : null;
        if (allFields == null) {
            this.checkPrepared();
            if (this.saKlass instanceof ArrayKlass) {
                allFields = Collections.emptyList();
            } else {
                InstanceKlass saKlass = (InstanceKlass)this.saKlass;
                List saFields = saKlass.getImmediateFields();
                for (InstanceKlass intf1 : CompatibilityHelper.INSTANCE.getTransitiveInterfaces(saKlass)) {
                    if (Assert.ASSERTS_ENABLED) {
                        Assert.that((boolean)intf1.isInterface(), (String)"just checking type");
                    }
                    saFields.addAll(intf1.getImmediateFields());
                }
                if (!saKlass.isInterface()) {
                    InstanceKlass supr = saKlass;
                    while ((supr = (InstanceKlass)supr.getSuper()) != null) {
                        saFields.addAll(supr.getImmediateFields());
                    }
                }
                allFields = new ArrayList<FieldImpl>(saFields.size());
                for (Object saField : saFields) {
                    Field curField = (Field)saField;
                    if (this.isThrowableBacktraceField(curField)) continue;
                    allFields.add(new FieldImpl(this.vm.referenceType((Klass)curField.getFieldHolder()), curField));
                }
            }
            allFields = Collections.unmodifiableList(allFields);
            this.allFieldsCache = new SoftReference<List<FieldImpl>>(allFields);
        }
        return allFields;
    }

    public final MethodImpl methodById(long id) throws ClassNotPreparedException {
        for (MethodImpl method : this.methods()) {
            if (method.uniqueID() != id) continue;
            return method;
        }
        throw new IllegalStateException("Method with id " + id + " not found in " + this.name());
    }

    public final List<MethodImpl> methods() throws ClassNotPreparedException {
        List<MethodImpl> methods;
        List<MethodImpl> list = methods = this.methodsCache != null ? this.methodsCache.get() : null;
        if (methods == null) {
            this.checkPrepared();
            if (this.saKlass instanceof ArrayKlass) {
                methods = Collections.emptyList();
            } else {
                List saMethods = ((InstanceKlass)this.saKlass).getImmediateMethods();
                int len = saMethods.size();
                methods = new ArrayList<MethodImpl>(len);
                for (Object saMethod : saMethods) {
                    methods.add(MethodImpl.createMethodImpl(this, (Method)saMethod));
                }
            }
            methods = Collections.unmodifiableList(methods);
            this.methodsCache = new SoftReference<List<MethodImpl>>(methods);
        }
        return methods;
    }

    List<InterfaceTypeImpl> getInterfaces() {
        if (this.saKlass instanceof ArrayKlass) {
            return Collections.emptyList();
        }
        List saInterfaces = ((InstanceKlass)this.saKlass).getDirectImplementedInterfaces();
        ArrayList<InterfaceTypeImpl> myInterfaces = new ArrayList<InterfaceTypeImpl>(saInterfaces.size());
        for (Object saInterface : saInterfaces) {
            myInterfaces.add((InterfaceTypeImpl)this.vm.referenceType((Klass)saInterface));
        }
        return myInterfaces;
    }

    public final List<ReferenceTypeImpl> nestedTypes() {
        List<ReferenceTypeImpl> nestedTypes;
        List<ReferenceTypeImpl> list = nestedTypes = this.nestedTypesCache != null ? this.nestedTypesCache.get() : null;
        if (nestedTypes == null) {
            if (this.saKlass instanceof ArrayKlass) {
                nestedTypes = Collections.emptyList();
            } else {
                ClassLoaderReferenceImpl cl = this.classLoader();
                List<ReferenceTypeImpl> classes = cl != null ? cl.visibleClasses() : this.vm.bootstrapClasses();
                nestedTypes = new ArrayList<ReferenceTypeImpl>();
                for (ReferenceTypeImpl aClass : classes) {
                    ReferenceTypeImpl refType = aClass;
                    Symbol candidateName = refType.ref().getName();
                    if (!((InstanceKlass)this.saKlass).isInnerOrLocalClassName(candidateName)) continue;
                    nestedTypes.add(refType);
                }
            }
            nestedTypes = Collections.unmodifiableList(nestedTypes);
            this.nestedTypesCache = new SoftReference<List<ReferenceTypeImpl>>(nestedTypes);
        }
        return nestedTypes;
    }

    public ValueImpl getValue(FieldImpl field) {
        this.validateFieldAccess(field);
        if (!field.isStatic()) {
            throw new IllegalArgumentException("Attempt to use non-static field with ReferenceType: " + field.name());
        }
        return field.getValue();
    }

    void validateFieldAccess(FieldImpl field) {
        ReferenceTypeImpl declType = field.declaringType();
        if (!declType.isAssignableFrom(this)) {
            throw new IllegalArgumentException("Invalid field");
        }
    }

    Instance getJavaMirror() {
        if (this.javaMirror == null) {
            this.javaMirror = this.saKlass.getJavaMirror();
        }
        return this.javaMirror;
    }

    public ClassObjectReferenceImpl classObject() {
        return this.vm.classObjectMirror(this.getJavaMirror());
    }

    SDE.Stratum stratum(String stratumID) {
        SDE sde = this.sourceDebugExtensionInfo();
        if (!sde.isValid()) {
            sde = NO_SDE_INFO_MARK;
        }
        return sde.stratum(stratumID);
    }

    public String baseSourceName() throws AbsentInformationException {
        if (this.saKlass instanceof ArrayKlass) {
            throw new AbsentInformationException();
        }
        Symbol sym = ((InstanceKlass)this.saKlass).getSourceFileName();
        if (sym != null) {
            return sym.asString();
        }
        throw new AbsentInformationException();
    }

    String baseSourcePath() throws AbsentInformationException {
        return this.baseSourceDir() + this.baseSourceName();
    }

    String baseSourceDir() {
        int nextIndex;
        String typeName = this.name();
        StringBuilder sb = new StringBuilder(typeName.length() + 10);
        int index = 0;
        while ((nextIndex = typeName.indexOf(46, index)) > 0) {
            sb.append(typeName, index, nextIndex);
            sb.append(File.separatorChar);
            index = nextIndex + 1;
        }
        return sb.toString();
    }

    public String sourceDebugExtension() throws AbsentInformationException {
        if (!this.vm.canGetSourceDebugExtension()) {
            throw new UnsupportedOperationException();
        }
        SDE sde = this.sourceDebugExtensionInfo();
        if (sde == NO_SDE_INFO_MARK) {
            throw new AbsentInformationException();
        }
        return sde.sourceDebugExtension;
    }

    private SDE sourceDebugExtensionInfo() {
        SDE sde;
        if (!this.vm.canGetSourceDebugExtension()) {
            return NO_SDE_INFO_MARK;
        }
        SDE sDE = sde = this.sdeRef == null ? null : this.sdeRef.get();
        if (sde == null) {
            String extension = null;
            if (this.saKlass instanceof InstanceKlass) {
                extension = CompatibilityHelper.INSTANCE.getSourceDebugExtension((InstanceKlass)this.saKlass);
            }
            sde = extension == null ? NO_SDE_INFO_MARK : new SDE(extension);
            this.sdeRef = new SoftReference<SDE>(sde);
        }
        return sde;
    }

    public final int modifiers() {
        if (this.modifiers == -1) {
            this.modifiers = this.getModifiers();
        }
        return this.modifiers;
    }

    public List<ObjectReferenceImpl> instances(long maxInstances) {
        if (!this.vm.canGetInstanceInfo()) {
            throw new UnsupportedOperationException("target does not support getting instances");
        }
        if (maxInstances < 0L) {
            throw new IllegalArgumentException("maxInstances is less than zero: " + maxInstances);
        }
        if (this.isAbstract() || this instanceof InterfaceTypeImpl) {
            return Collections.emptyList();
        }
        final ArrayList<ObjectReferenceImpl> objects = new ArrayList<ObjectReferenceImpl>(0);
        final Address givenKls = CompatibilityHelper.INSTANCE.getAddress(this.saKlass);
        final long max = maxInstances;
        this.vm.saObjectHeap().iterate((HeapVisitor)new DefaultHeapVisitor(){
            private long instCount = 0L;

            public boolean doObj(Oop oop) {
                if (givenKls.equals(CompatibilityHelper.INSTANCE.getKlassAddress(oop))) {
                    objects.add(ReferenceTypeImpl.this.vm.objectMirror(oop));
                    ++this.instCount;
                }
                return max > 0L && this.instCount >= max;
            }
        });
        return objects;
    }

    int getModifiers() {
        return (int)this.saKlass.getClassModifiers();
    }

    public Klass ref() {
        return this.saKlass;
    }

    abstract boolean isAssignableTo(ReferenceTypeImpl var1);

    boolean isAssignableFrom(ReferenceTypeImpl type) {
        return type.isAssignableTo(this);
    }

    int indexOf(MethodImpl method) {
        return this.methods().indexOf(method);
    }

    private static boolean isPrimitiveArray(String signature) {
        char c;
        int i = signature.lastIndexOf(91);
        boolean isPA = i < 0 ? false : (c = signature.charAt(i + 1)) != 'L';
        return isPA;
    }

    String loaderString() {
        if (this.classLoader() != null) {
            return "loaded by " + this.classLoader().toString();
        }
        return "loaded by bootstrap loader";
    }

    public static long uniqueID(Klass klass, VirtualMachineImpl vm) {
        return vm.getAddressValue(CompatibilityHelper.INSTANCE.getAddress(klass));
    }

    public long uniqueID() {
        return ReferenceTypeImpl.uniqueID(this.saKlass, this.vm);
    }

    public int majorVersion() {
        if (!this.vm.canGetClassFileVersion()) {
            throw new UnsupportedOperationException("Cannot get class file version");
        }
        return (int)((InstanceKlass)this.saKlass).majorVersion();
    }

    public int minorVersion() {
        if (!this.vm.canGetClassFileVersion()) {
            throw new UnsupportedOperationException("Cannot get class file version");
        }
        return (int)((InstanceKlass)this.saKlass).minorVersion();
    }

    public int constantPoolCount() {
        if (!this.vm.canGetConstantPool()) {
            throw new UnsupportedOperationException("Cannot get constant pool");
        }
        if (this.saKlass instanceof ArrayKlass) {
            return 0;
        }
        return ((InstanceKlass)this.saKlass).getConstants().getLength();
    }

    public byte[] constantPool() {
        if (!this.vm.canGetConstantPool()) {
            throw new UnsupportedOperationException("Cannot get constant pool");
        }
        if (this instanceof ArrayTypeImpl) {
            return new byte[0];
        }
        ByteArrayOutputStream bs = new ByteArrayOutputStream(){

            @Override
            public byte[] toByteArray() {
                return Arrays.copyOfRange(this.buf, 2, this.count);
            }
        };
        try {
            new ClassWriter((InstanceKlass)this.saKlass, bs){

                public void writeConstantPool() throws IOException {
                    super.writeConstantPool();
                }
            }.writeConstantPool();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return new byte[0];
        }
        return bs.toByteArray();
    }
}

