/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.cuda.CU;
import org.lwjgl.cuda.CUDA;
import org.lwjgl.cuda.CUGL;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class CUGL65
extends CUGL {
    public static final int CU_GL_DEVICE_LIST_ALL = 1;
    public static final int CU_GL_DEVICE_LIST_CURRENT_FRAME = 2;
    public static final int CU_GL_DEVICE_LIST_NEXT_FRAME = 3;

    protected CUGL65() {
        throw new UnsupportedOperationException();
    }

    public static int ncuGLGetDevices(long pCudaDeviceCount, long pCudaDevices, int cudaDeviceCount, int deviceList) {
        long __functionAddress = Functions.GLGetDevices;
        return JNI.callPPI((long)pCudaDeviceCount, (long)pCudaDevices, (int)cudaDeviceCount, (int)deviceList, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGLGetDevices(@NativeType(value="unsigned int *") IntBuffer pCudaDeviceCount, @NativeType(value="CUdevice *") IntBuffer pCudaDevices, @NativeType(value="CUGLDeviceList") int deviceList) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pCudaDeviceCount, (int)1);
        }
        return CUGL65.ncuGLGetDevices(MemoryUtil.memAddress((IntBuffer)pCudaDeviceCount), MemoryUtil.memAddress((IntBuffer)pCudaDevices), pCudaDevices.remaining(), deviceList);
    }

    public static final class Functions {
        public static final long GLGetDevices = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_VERSION("cuGLGetDevices", 2));

        private Functions() {
        }
    }
}

