/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPresentInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int WAITSEMAPHORECOUNT;
    public static final int PWAITSEMAPHORES;
    public static final int SWAPCHAINCOUNT;
    public static final int PSWAPCHAINS;
    public static final int PIMAGEINDICES;
    public static final int PRESULTS;

    public VkPresentInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPresentInfoKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPresentInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPresentInfoKHR.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int waitSemaphoreCount() {
        return VkPresentInfoKHR.nwaitSemaphoreCount(this.address());
    }

    @Nullable
    @NativeType(value="VkSemaphore const *")
    public LongBuffer pWaitSemaphores() {
        return VkPresentInfoKHR.npWaitSemaphores(this.address());
    }

    @NativeType(value="uint32_t")
    public int swapchainCount() {
        return VkPresentInfoKHR.nswapchainCount(this.address());
    }

    @NativeType(value="VkSwapchainKHR const *")
    public LongBuffer pSwapchains() {
        return VkPresentInfoKHR.npSwapchains(this.address());
    }

    @NativeType(value="uint32_t const *")
    public IntBuffer pImageIndices() {
        return VkPresentInfoKHR.npImageIndices(this.address());
    }

    @Nullable
    @NativeType(value="VkResult *")
    public IntBuffer pResults() {
        return VkPresentInfoKHR.npResults(this.address());
    }

    public VkPresentInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkPresentInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkPresentInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkPresentInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkPresentInfoKHR pWaitSemaphores(@Nullable @NativeType(value="VkSemaphore const *") LongBuffer value) {
        VkPresentInfoKHR.npWaitSemaphores(this.address(), value);
        return this;
    }

    public VkPresentInfoKHR swapchainCount(@NativeType(value="uint32_t") int value) {
        VkPresentInfoKHR.nswapchainCount(this.address(), value);
        return this;
    }

    public VkPresentInfoKHR pSwapchains(@NativeType(value="VkSwapchainKHR const *") LongBuffer value) {
        VkPresentInfoKHR.npSwapchains(this.address(), value);
        return this;
    }

    public VkPresentInfoKHR pImageIndices(@NativeType(value="uint32_t const *") IntBuffer value) {
        VkPresentInfoKHR.npImageIndices(this.address(), value);
        return this;
    }

    public VkPresentInfoKHR pResults(@Nullable @NativeType(value="VkResult *") IntBuffer value) {
        VkPresentInfoKHR.npResults(this.address(), value);
        return this;
    }

    public VkPresentInfoKHR set(int sType, long pNext, @Nullable LongBuffer pWaitSemaphores, int swapchainCount, LongBuffer pSwapchains, IntBuffer pImageIndices, @Nullable IntBuffer pResults) {
        this.sType(sType);
        this.pNext(pNext);
        this.pWaitSemaphores(pWaitSemaphores);
        this.swapchainCount(swapchainCount);
        this.pSwapchains(pSwapchains);
        this.pImageIndices(pImageIndices);
        this.pResults(pResults);
        return this;
    }

    public VkPresentInfoKHR set(VkPresentInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPresentInfoKHR malloc() {
        return (VkPresentInfoKHR)VkPresentInfoKHR.wrap(VkPresentInfoKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkPresentInfoKHR calloc() {
        return (VkPresentInfoKHR)VkPresentInfoKHR.wrap(VkPresentInfoKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkPresentInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkPresentInfoKHR)VkPresentInfoKHR.wrap(VkPresentInfoKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkPresentInfoKHR create(long address) {
        return (VkPresentInfoKHR)VkPresentInfoKHR.wrap(VkPresentInfoKHR.class, (long)address);
    }

    @Nullable
    public static VkPresentInfoKHR createSafe(long address) {
        return address == 0L ? null : (VkPresentInfoKHR)VkPresentInfoKHR.wrap(VkPresentInfoKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkPresentInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkPresentInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkPresentInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPresentInfoKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkPresentInfoKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkPresentInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkPresentInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkPresentInfoKHR mallocStack() {
        return VkPresentInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkPresentInfoKHR callocStack() {
        return VkPresentInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkPresentInfoKHR mallocStack(MemoryStack stack) {
        return (VkPresentInfoKHR)VkPresentInfoKHR.wrap(VkPresentInfoKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPresentInfoKHR callocStack(MemoryStack stack) {
        return (VkPresentInfoKHR)VkPresentInfoKHR.wrap(VkPresentInfoKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPresentInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPresentInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPresentInfoKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPresentInfoKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nwaitSemaphoreCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)WAITSEMAPHORECOUNT);
    }

    @Nullable
    public static LongBuffer npWaitSemaphores(long struct) {
        return MemoryUtil.memLongBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PWAITSEMAPHORES)), (int)VkPresentInfoKHR.nwaitSemaphoreCount(struct));
    }

    public static int nswapchainCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)SWAPCHAINCOUNT);
    }

    public static LongBuffer npSwapchains(long struct) {
        return MemoryUtil.memLongBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PSWAPCHAINS)), (int)VkPresentInfoKHR.nswapchainCount(struct));
    }

    public static IntBuffer npImageIndices(long struct) {
        return MemoryUtil.memIntBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PIMAGEINDICES)), (int)VkPresentInfoKHR.nswapchainCount(struct));
    }

    @Nullable
    public static IntBuffer npResults(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PRESULTS)), (int)VkPresentInfoKHR.nswapchainCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nwaitSemaphoreCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WAITSEMAPHORECOUNT, value);
    }

    public static void npWaitSemaphores(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PWAITSEMAPHORES), (long)MemoryUtil.memAddressSafe((LongBuffer)value));
        VkPresentInfoKHR.nwaitSemaphoreCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nswapchainCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SWAPCHAINCOUNT, value);
    }

    public static void npSwapchains(long struct, LongBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSWAPCHAINS), (long)MemoryUtil.memAddress((LongBuffer)value));
    }

    public static void npImageIndices(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PIMAGEINDICES), (long)MemoryUtil.memAddress((IntBuffer)value));
    }

    public static void npResults(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PRESULTS), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
    }

    public static void validate(long struct) {
        if (VkPresentInfoKHR.nwaitSemaphoreCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PWAITSEMAPHORES)));
        }
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PSWAPCHAINS)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PIMAGEINDICES)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkPresentInfoKHR.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkPresentInfoKHR.__struct((Struct.Member[])new Struct.Member[]{VkPresentInfoKHR.__member((int)4), VkPresentInfoKHR.__member((int)POINTER_SIZE), VkPresentInfoKHR.__member((int)4), VkPresentInfoKHR.__member((int)POINTER_SIZE), VkPresentInfoKHR.__member((int)4), VkPresentInfoKHR.__member((int)POINTER_SIZE), VkPresentInfoKHR.__member((int)POINTER_SIZE), VkPresentInfoKHR.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        WAITSEMAPHORECOUNT = layout.offsetof(2);
        PWAITSEMAPHORES = layout.offsetof(3);
        SWAPCHAINCOUNT = layout.offsetof(4);
        PSWAPCHAINS = layout.offsetof(5);
        PIMAGEINDICES = layout.offsetof(6);
        PRESULTS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkPresentInfoKHR, Buffer>
    implements NativeResource {
        private static final VkPresentInfoKHR ELEMENT_FACTORY = VkPresentInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkPresentInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPresentInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPresentInfoKHR.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int waitSemaphoreCount() {
            return VkPresentInfoKHR.nwaitSemaphoreCount(this.address());
        }

        @Nullable
        @NativeType(value="VkSemaphore const *")
        public LongBuffer pWaitSemaphores() {
            return VkPresentInfoKHR.npWaitSemaphores(this.address());
        }

        @NativeType(value="uint32_t")
        public int swapchainCount() {
            return VkPresentInfoKHR.nswapchainCount(this.address());
        }

        @NativeType(value="VkSwapchainKHR const *")
        public LongBuffer pSwapchains() {
            return VkPresentInfoKHR.npSwapchains(this.address());
        }

        @NativeType(value="uint32_t const *")
        public IntBuffer pImageIndices() {
            return VkPresentInfoKHR.npImageIndices(this.address());
        }

        @Nullable
        @NativeType(value="VkResult *")
        public IntBuffer pResults() {
            return VkPresentInfoKHR.npResults(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPresentInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPresentInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pWaitSemaphores(@Nullable @NativeType(value="VkSemaphore const *") LongBuffer value) {
            VkPresentInfoKHR.npWaitSemaphores(this.address(), value);
            return this;
        }

        public Buffer swapchainCount(@NativeType(value="uint32_t") int value) {
            VkPresentInfoKHR.nswapchainCount(this.address(), value);
            return this;
        }

        public Buffer pSwapchains(@NativeType(value="VkSwapchainKHR const *") LongBuffer value) {
            VkPresentInfoKHR.npSwapchains(this.address(), value);
            return this;
        }

        public Buffer pImageIndices(@NativeType(value="uint32_t const *") IntBuffer value) {
            VkPresentInfoKHR.npImageIndices(this.address(), value);
            return this;
        }

        public Buffer pResults(@Nullable @NativeType(value="VkResult *") IntBuffer value) {
            VkPresentInfoKHR.npResults(this.address(), value);
            return this;
        }
    }
}

