/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkRect2D;

public class VkDisplayPresentInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRCRECT;
    public static final int DSTRECT;
    public static final int PERSISTENT;

    public VkDisplayPresentInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDisplayPresentInfoKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDisplayPresentInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDisplayPresentInfoKHR.npNext(this.address());
    }

    public VkRect2D srcRect() {
        return VkDisplayPresentInfoKHR.nsrcRect(this.address());
    }

    public VkRect2D dstRect() {
        return VkDisplayPresentInfoKHR.ndstRect(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean persistent() {
        return VkDisplayPresentInfoKHR.npersistent(this.address()) != 0;
    }

    public VkDisplayPresentInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkDisplayPresentInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkDisplayPresentInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkDisplayPresentInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkDisplayPresentInfoKHR srcRect(VkRect2D value) {
        VkDisplayPresentInfoKHR.nsrcRect(this.address(), value);
        return this;
    }

    public VkDisplayPresentInfoKHR srcRect(Consumer<VkRect2D> consumer) {
        consumer.accept(this.srcRect());
        return this;
    }

    public VkDisplayPresentInfoKHR dstRect(VkRect2D value) {
        VkDisplayPresentInfoKHR.ndstRect(this.address(), value);
        return this;
    }

    public VkDisplayPresentInfoKHR dstRect(Consumer<VkRect2D> consumer) {
        consumer.accept(this.dstRect());
        return this;
    }

    public VkDisplayPresentInfoKHR persistent(@NativeType(value="VkBool32") boolean value) {
        VkDisplayPresentInfoKHR.npersistent(this.address(), value ? 1 : 0);
        return this;
    }

    public VkDisplayPresentInfoKHR set(int sType, long pNext, VkRect2D srcRect, VkRect2D dstRect, boolean persistent) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcRect(srcRect);
        this.dstRect(dstRect);
        this.persistent(persistent);
        return this;
    }

    public VkDisplayPresentInfoKHR set(VkDisplayPresentInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDisplayPresentInfoKHR malloc() {
        return (VkDisplayPresentInfoKHR)VkDisplayPresentInfoKHR.wrap(VkDisplayPresentInfoKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkDisplayPresentInfoKHR calloc() {
        return (VkDisplayPresentInfoKHR)VkDisplayPresentInfoKHR.wrap(VkDisplayPresentInfoKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkDisplayPresentInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkDisplayPresentInfoKHR)VkDisplayPresentInfoKHR.wrap(VkDisplayPresentInfoKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkDisplayPresentInfoKHR create(long address) {
        return (VkDisplayPresentInfoKHR)VkDisplayPresentInfoKHR.wrap(VkDisplayPresentInfoKHR.class, (long)address);
    }

    @Nullable
    public static VkDisplayPresentInfoKHR createSafe(long address) {
        return address == 0L ? null : (VkDisplayPresentInfoKHR)VkDisplayPresentInfoKHR.wrap(VkDisplayPresentInfoKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkDisplayPresentInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkDisplayPresentInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkDisplayPresentInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDisplayPresentInfoKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkDisplayPresentInfoKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkDisplayPresentInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkDisplayPresentInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkDisplayPresentInfoKHR mallocStack() {
        return VkDisplayPresentInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkDisplayPresentInfoKHR callocStack() {
        return VkDisplayPresentInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkDisplayPresentInfoKHR mallocStack(MemoryStack stack) {
        return (VkDisplayPresentInfoKHR)VkDisplayPresentInfoKHR.wrap(VkDisplayPresentInfoKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDisplayPresentInfoKHR callocStack(MemoryStack stack) {
        return (VkDisplayPresentInfoKHR)VkDisplayPresentInfoKHR.wrap(VkDisplayPresentInfoKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDisplayPresentInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDisplayPresentInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkDisplayPresentInfoKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkDisplayPresentInfoKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static VkRect2D nsrcRect(long struct) {
        return VkRect2D.create(struct + (long)SRCRECT);
    }

    public static VkRect2D ndstRect(long struct) {
        return VkRect2D.create(struct + (long)DSTRECT);
    }

    public static int npersistent(long struct) {
        return UNSAFE.getInt(null, struct + (long)PERSISTENT);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nsrcRect(long struct, VkRect2D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SRCRECT), (long)VkRect2D.SIZEOF);
    }

    public static void ndstRect(long struct, VkRect2D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DSTRECT), (long)VkRect2D.SIZEOF);
    }

    public static void npersistent(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PERSISTENT, value);
    }

    static {
        Struct.Layout layout = VkDisplayPresentInfoKHR.__struct((Struct.Member[])new Struct.Member[]{VkDisplayPresentInfoKHR.__member((int)4), VkDisplayPresentInfoKHR.__member((int)POINTER_SIZE), VkDisplayPresentInfoKHR.__member((int)VkRect2D.SIZEOF, (int)VkRect2D.ALIGNOF), VkDisplayPresentInfoKHR.__member((int)VkRect2D.SIZEOF, (int)VkRect2D.ALIGNOF), VkDisplayPresentInfoKHR.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRCRECT = layout.offsetof(2);
        DSTRECT = layout.offsetof(3);
        PERSISTENT = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDisplayPresentInfoKHR, Buffer>
    implements NativeResource {
        private static final VkDisplayPresentInfoKHR ELEMENT_FACTORY = VkDisplayPresentInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDisplayPresentInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDisplayPresentInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDisplayPresentInfoKHR.npNext(this.address());
        }

        public VkRect2D srcRect() {
            return VkDisplayPresentInfoKHR.nsrcRect(this.address());
        }

        public VkRect2D dstRect() {
            return VkDisplayPresentInfoKHR.ndstRect(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean persistent() {
            return VkDisplayPresentInfoKHR.npersistent(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDisplayPresentInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDisplayPresentInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer srcRect(VkRect2D value) {
            VkDisplayPresentInfoKHR.nsrcRect(this.address(), value);
            return this;
        }

        public Buffer srcRect(Consumer<VkRect2D> consumer) {
            consumer.accept(this.srcRect());
            return this;
        }

        public Buffer dstRect(VkRect2D value) {
            VkDisplayPresentInfoKHR.ndstRect(this.address(), value);
            return this;
        }

        public Buffer dstRect(Consumer<VkRect2D> consumer) {
            consumer.accept(this.dstRect());
            return this;
        }

        public Buffer persistent(@NativeType(value="VkBool32") boolean value) {
            VkDisplayPresentInfoKHR.npersistent(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

