/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bullet;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.bullet.B3ContactPointData;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct b3ContactInformation")
public class B3ContactInformation
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M_NUMCONTACTPOINTS;
    public static final int M_CONTACTPOINTDATA;

    public B3ContactInformation(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), B3ContactInformation.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int m_numContactPoints() {
        return B3ContactInformation.nm_numContactPoints(this.address());
    }

    @NativeType(value="struct b3ContactPointData *")
    public B3ContactPointData.Buffer m_contactPointData() {
        return B3ContactInformation.nm_contactPointData(this.address());
    }

    public B3ContactInformation m_contactPointData(@NativeType(value="struct b3ContactPointData *") B3ContactPointData.Buffer value) {
        B3ContactInformation.nm_contactPointData(this.address(), value);
        return this;
    }

    public B3ContactInformation set(B3ContactInformation src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static B3ContactInformation malloc() {
        return (B3ContactInformation)B3ContactInformation.wrap(B3ContactInformation.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static B3ContactInformation calloc() {
        return (B3ContactInformation)B3ContactInformation.wrap(B3ContactInformation.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static B3ContactInformation create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (B3ContactInformation)B3ContactInformation.wrap(B3ContactInformation.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static B3ContactInformation create(long address) {
        return (B3ContactInformation)B3ContactInformation.wrap(B3ContactInformation.class, (long)address);
    }

    @Nullable
    public static B3ContactInformation createSafe(long address) {
        return address == 0L ? null : (B3ContactInformation)B3ContactInformation.wrap(B3ContactInformation.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)B3ContactInformation.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)B3ContactInformation.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)B3ContactInformation.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = B3ContactInformation.__create((int)capacity, (int)SIZEOF);
        return (Buffer)B3ContactInformation.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)B3ContactInformation.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)B3ContactInformation.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static B3ContactInformation mallocStack() {
        return B3ContactInformation.mallocStack(MemoryStack.stackGet());
    }

    public static B3ContactInformation callocStack() {
        return B3ContactInformation.callocStack(MemoryStack.stackGet());
    }

    public static B3ContactInformation mallocStack(MemoryStack stack) {
        return (B3ContactInformation)B3ContactInformation.wrap(B3ContactInformation.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static B3ContactInformation callocStack(MemoryStack stack) {
        return (B3ContactInformation)B3ContactInformation.wrap(B3ContactInformation.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return B3ContactInformation.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return B3ContactInformation.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)B3ContactInformation.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)B3ContactInformation.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nm_numContactPoints(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NUMCONTACTPOINTS);
    }

    public static B3ContactPointData.Buffer nm_contactPointData(long struct) {
        return B3ContactPointData.create(MemoryUtil.memGetAddress((long)(struct + (long)M_CONTACTPOINTDATA)), B3ContactInformation.nm_numContactPoints(struct));
    }

    public static void nm_numContactPoints(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_NUMCONTACTPOINTS, value);
    }

    public static void nm_contactPointData(long struct, B3ContactPointData.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)M_CONTACTPOINTDATA), (long)value.address());
        B3ContactInformation.nm_numContactPoints(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)M_CONTACTPOINTDATA)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            B3ContactInformation.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = B3ContactInformation.__struct((Struct.Member[])new Struct.Member[]{B3ContactInformation.__member((int)4), B3ContactInformation.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M_NUMCONTACTPOINTS = layout.offsetof(0);
        M_CONTACTPOINTDATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<B3ContactInformation, Buffer>
    implements NativeResource {
        private static final B3ContactInformation ELEMENT_FACTORY = B3ContactInformation.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected B3ContactInformation getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int m_numContactPoints() {
            return B3ContactInformation.nm_numContactPoints(this.address());
        }

        @NativeType(value="struct b3ContactPointData *")
        public B3ContactPointData.Buffer m_contactPointData() {
            return B3ContactInformation.nm_contactPointData(this.address());
        }

        public Buffer m_contactPointData(@NativeType(value="struct b3ContactPointData *") B3ContactPointData.Buffer value) {
            B3ContactInformation.nm_contactPointData(this.address(), value);
            return this;
        }
    }
}

