/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.Record;
import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.DatabaseObject;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.SettingsDBManager;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.InvalidNameException;
import ghidra.util.Lock;
import ghidra.util.UniversalID;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotYetImplementedException;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

abstract class DataTypeDB
extends DatabaseObject
implements DataType,
ChangeListener {
    protected Record record;
    protected final DataTypeManagerDB dataMgr;
    private volatile Settings defaultSettings;
    private static final SettingsDefinition[] EMPTY_DEFINITIONS = new SettingsDefinition[0];
    protected boolean resolving;
    protected Lock lock;
    private volatile String name;
    private volatile Category category;

    protected DataTypeDB(DataTypeManagerDB dataMgr, DBObjectCache<DataTypeDB> cache, Record record) {
        super(cache, record.getKey());
        this.dataMgr = dataMgr;
        this.record = record;
        this.lock = dataMgr.lock;
        this.refreshName();
    }

    protected void refreshName() {
        this.name = this.doGetName();
    }

    protected abstract String doGetName();

    protected abstract long doGetCategoryID();

    protected abstract void doSetCategoryPathRecord(long var1) throws IOException;

    protected abstract void doSetNameRecord(String var1) throws IOException, InvalidNameException;

    protected abstract UniversalID getSourceArchiveID();

    protected abstract void setSourceArchiveID(UniversalID var1);

    @Override
    public final DataOrganization getDataOrganization() {
        return this.dataMgr.getDataOrganization();
    }

    @Override
    protected boolean refresh() {
        this.category = null;
        this.defaultSettings = null;
        this.refreshName();
        return true;
    }

    @Override
    public boolean isNotYetDefined() {
        return false;
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public final String getName() {
        this.validate(this.lock);
        return this.name;
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return null;
    }

    protected final String getOldName() {
        return this.name;
    }

    @Override
    public Settings getDefaultSettings() {
        this.validate(this.lock);
        Settings localDefaultSettings = this.defaultSettings;
        if (localDefaultSettings == null) {
            this.defaultSettings = localDefaultSettings = new SettingsDBManager(this.dataMgr, this, this.key);
        }
        return localDefaultSettings;
    }

    @Override
    public URL getDocs() {
        return null;
    }

    public void setValue(MemBuffer buf, Settings settings, int length, Object value) {
        throw new NotYetImplementedException("setValue() not implemented");
    }

    @Override
    public SettingsDefinition[] getSettingsDefinitions() {
        return EMPTY_DEFINITIONS;
    }

    @Override
    public boolean isDeleted() {
        return !this.checkIsValid();
    }

    @Override
    public void dataTypeSizeChanged(DataType dt) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.dataMgr != null) {
            this.dataMgr.dataTypeChanged(this);
        }
    }

    @Override
    public DataTypeManager getDataTypeManager() {
        return this.dataMgr;
    }

    @Override
    public void setDefaultSettings(Settings settings) {
        this.checkIsValid();
        this.defaultSettings = settings;
    }

    @Override
    public int getAlignment() {
        int length = this.getLength();
        if (length < 0) {
            return 1;
        }
        DataOrganization dataOrganization = this.dataMgr.getDataOrganization();
        return dataOrganization.getAlignment(this, length);
    }

    @Override
    public String getPathName() {
        return this.getDataTypePath().getPath();
    }

    protected void checkValidName(String newName) throws InvalidNameException {
        if (!DataUtilities.isValidDataTypeName(newName)) {
            throw new InvalidNameException();
        }
    }

    protected DataType resolve(DataType dt) {
        return this.resolve(dt, null);
    }

    protected DataType resolve(DataType dt, DataTypeConflictHandler handler) {
        if (this.dataMgr != null) {
            this.resolving = true;
            dt = this.dataMgr.resolve(dt, handler);
            this.resolving = false;
        }
        return dt;
    }

    @Override
    public CategoryPath getCategoryPath() {
        this.validate(this.lock);
        if (this.category == null) {
            this.category = this.dataMgr.getCategory(this.doGetCategoryID());
        }
        if (this.category == null) {
            this.category = this.dataMgr.getRootCategory();
            return CategoryPath.ROOT;
        }
        return this.category.getCategoryPath();
    }

    @Override
    public DataTypePath getDataTypePath() {
        return new DataTypePath(this.getCategoryPath(), this.getName());
    }

    @Override
    public void setName(String name) throws InvalidNameException, DuplicateNameException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            CategoryPath categoryPath = this.getCategoryPath();
            if (this.dataMgr.getDataType(categoryPath, name) != null) {
                throw new DuplicateNameException("DataType named " + name + " already exists in category " + categoryPath.getPath());
            }
            this.doSetName(name);
        }
        finally {
            this.lock.release();
        }
    }

    private final void doSetName(String newName) throws InvalidNameException {
        String oldName = this.getName();
        if (newName.equals(oldName)) {
            return;
        }
        this.checkValidName(newName);
        try {
            this.doSetNameRecord(newName);
            this.name = newName;
            this.notifyNameChanged(oldName);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
    }

    @Override
    public void setCategoryPath(CategoryPath path) throws DuplicateNameException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            DataType type = this.dataMgr.getDataType(path, this.getName());
            if (type != null) {
                throw new DuplicateNameException("DataType named " + this.getDisplayName() + " already exists in category " + path.getPath());
            }
            this.doSetCategoryPath(path);
        }
        finally {
            this.lock.release();
        }
    }

    private void doSetCategoryPath(CategoryPath path) {
        CategoryPath myPath = this.getCategoryPath();
        if (path.equals(myPath)) {
            return;
        }
        Category cat = this.dataMgr.createCategory(path);
        try {
            this.doSetCategoryPathRecord(cat.getID());
            this.category = cat;
            this.dataMgr.dataTypeCategoryPathChanged(this, myPath);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNameAndCategory(CategoryPath path, String name) throws InvalidNameException, DuplicateNameException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (this.dataMgr.getDataType(path, name) != null) {
                throw new DuplicateNameException("DataType named " + name + " already exists in category " + path.getPath());
            }
            String uniqueName = this.dataMgr.getUniqueName(path, this.getCategoryPath(), name);
            this.doSetName(uniqueName);
            this.doSetCategoryPath(path);
            if (!uniqueName.equals(name)) {
                this.doSetName(name);
            }
        }
        finally {
            this.lock.release();
        }
    }

    protected void updatePath(DataTypeDB dt) {
    }

    @Override
    public void addParent(DataType dt) {
        if (dt instanceof DataTypeDB && dt.getDataTypeManager() == this.dataMgr) {
            this.dataMgr.addParentChildRecord(((DataTypeDB)dt).key, this.key);
        }
    }

    @Override
    public void removeParent(DataType dt) {
        if (dt instanceof DataTypeDB && dt.getDataTypeManager() == this.dataMgr) {
            this.dataMgr.removeParentChildRecord(((DataTypeDB)dt).key, this.key);
        }
    }

    protected void notifySizeChanged() {
        for (DataType dt : this.dataMgr.getParentDataTypes(this.key)) {
            dt.dataTypeSizeChanged(this);
        }
        this.dataMgr.dataTypeChanged(this);
    }

    protected void notifyNameChanged(String oldName) {
        for (DataType dt : this.dataMgr.getParentDataTypes(this.key)) {
            dt.dataTypeNameChanged(this, oldName);
        }
        this.dataMgr.dataTypeNameChanged(this, oldName);
    }

    protected void notifyDeleted() {
        for (DataType dt : this.dataMgr.getParentDataTypes(this.key)) {
            dt.dataTypeDeleted(this);
        }
    }

    @Override
    public DataType[] getParents() {
        List<DataType> parents = this.dataMgr.getParentDataTypes(this.key);
        DataType[] array = new DataType[parents.size()];
        return parents.toArray(array);
    }

    @Override
    public boolean dependsOn(DataType dt) {
        return false;
    }

    @Override
    public String getDefaultLabelPrefix() {
        return null;
    }

    @Override
    public String getDefaultAbbreviatedLabelPrefix() {
        return this.getDefaultLabelPrefix();
    }

    @Override
    public String getDefaultLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options) {
        return this.getDefaultLabelPrefix();
    }

    @Override
    public String getDefaultOffcutLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options, int offcutLength) {
        return this.getDefaultLabelPrefix(buf, settings, len, options);
    }

    @Override
    public void setSourceArchive(SourceArchive archive) {
        UniversalID id;
        archive = this.getDataTypeManager().resolveSourceArchive(archive);
        UniversalID universalID = id = archive == null ? DataTypeManager.LOCAL_ARCHIVE_UNIVERSAL_ID : archive.getSourceArchiveID();
        if (id.equals((Object)this.getDataTypeManager().getUniversalID())) {
            id = DataTypeManager.LOCAL_ARCHIVE_UNIVERSAL_ID;
        }
        this.setSourceArchiveID(id);
    }

    @Override
    public SourceArchive getSourceArchive() {
        if (this.dataMgr == null) {
            return null;
        }
        return this.dataMgr.getSourceArchive(this.getSourceArchiveID());
    }

    @Override
    public void replaceWith(DataType dataType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDescription(String description) {
    }

    abstract void setUniversalID(UniversalID var1);

    public int hashCode() {
        return this.getName().hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataType)) {
            return false;
        }
        DataType otherDt = (DataType)obj;
        return otherDt.getDataTypeManager() == this.getDataTypeManager() && this.getCategoryPath().equals(otherDt.getCategoryPath()) && this.getName().equals(otherDt.getName()) && this.isEquivalent(otherDt);
    }
}

