/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh;

import ghidra.app.plugin.processors.sleigh.ConstructState;
import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.ContextCache;
import ghidra.app.plugin.processors.sleigh.FixedHandle;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighInstructionPrototype;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.SleighParserContext;
import ghidra.app.plugin.processors.sleigh.expression.BinaryExpression;
import ghidra.app.plugin.processors.sleigh.expression.ContextField;
import ghidra.app.plugin.processors.sleigh.expression.OperandValue;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.expression.TokenField;
import ghidra.app.plugin.processors.sleigh.expression.UnaryExpression;
import ghidra.app.plugin.processors.sleigh.pattern.PatternBlock;
import ghidra.app.plugin.processors.sleigh.symbol.OperandSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.SubtableSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.TripleSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.InstructionContext;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.ParserContext;
import ghidra.program.model.lang.ProcessorContextView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.lang.UnknownContextException;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBufferImpl;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.StringUtilities;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SleighDebugLogger {
    private StringBuffer buffer = new StringBuffer();
    private int indentLevel = 0;
    private String indent = "";
    private boolean atLineStart = true;
    private Register contextBaseRegister;
    private MemBuffer buf;
    private SleighDebugMode mode;
    private PatternGroup mainGroup = new PatternGroup(null, null);
    private Map<String, PatternGroup> mainSubGroups = new HashMap<String, PatternGroup>();
    private PatternGroup currentGroup = this.mainGroup;
    private int currentDepth = 0;
    private byte[] instructionMask;
    private List<byte[]> operandMasks = new ArrayList<byte[]>();
    private ProcessorContextView context;
    private SleighInstructionPrototype prototype;
    private InstructionContext instrContext;
    private byte[] bytes;

    public SleighDebugLogger(MemBuffer buf, ProcessorContextView context, Language language, SleighDebugMode mode) {
        this.buf = buf;
        this.context = context;
        this.mode = mode;
        if (!(context instanceof MyProcessorContextView)) {
            this.context = new MyProcessorContextView(context);
        }
        if (!(language instanceof SleighLanguage)) {
            throw new IllegalArgumentException("unsupport language provider: " + language.getClass().getSimpleName());
        }
        ContextCache contextCache = new ContextCache();
        this.contextBaseRegister = language.getContextBaseRegister();
        if (this.contextBaseRegister != null) {
            contextCache.registerVariable(this.contextBaseRegister);
        }
        if (mode == SleighDebugMode.VERBOSE) {
            this.append("\nNOTE: bitrange's number leftmost/most-significant bit as 0 (zero).\n");
            this.append("      This bit numbering agrees with the context field specification\n");
            this.append("      but differs from token field specification.  The bit correspondence\n");
            this.append("      for token fields depends upon the specific token size/endianess and\n");
            this.append("      current byte-offset of pattern matcher.\n\n");
            int contextSize = contextCache.getContextSize();
            if (contextSize != 0) {
                int[] contextBytes = new int[contextSize];
                contextCache.getContext(context, contextBytes);
                this.append("initial context bits: ");
                this.append(contextBytes, -1, 0);
                this.append("\n");
            }
        }
        try {
            this.prototype = new SleighInstructionPrototype((SleighLanguage)language, buf, context, contextCache, false, this);
            this.prototype.cacheInfo(buf, context, false);
            this.instrContext = new DebugInstructionContext();
            this.bytes = new byte[this.prototype.getLength()];
            buf.getBytes(this.bytes, 0);
            if (mode == SleighDebugMode.VERBOSE) {
                this.dumpFinalGlobalSets();
                this.append("\nPrototype parse successful: ");
                this.append(SleighDebugLogger.getPrototypeRepresentation(this.prototype, this.instrContext));
                this.append("\nInstruction length = " + this.prototype.getLength() + " bytes");
            }
        }
        catch (Exception e) {
            this.indentLevel = 0;
            this.indent = this.getIndent();
            this.append("\nPrototype parse failed: " + e.getMessage());
            this.prototype = null;
        }
    }

    public SleighDebugLogger(Program program, Address start, SleighDebugMode mode) {
        this(new MemoryBufferImpl(program.getMemory(), start), new MyProcessorContextView(program.getProgramContext(), start), program.getLanguage(), mode);
    }

    public boolean isVerboseEnabled() {
        return this.mode == SleighDebugMode.VERBOSE;
    }

    public boolean parseFailed() {
        return this.prototype == null;
    }

    public List<String> getConstructorLineNumbers() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.prototype == null) {
            return list;
        }
        try {
            SleighParserContext pos = this.prototype.getParserContext(this.buf, this.context);
            ParserWalker walker = new ParserWalker(pos);
            walker.baseState();
            this.dumpSymbolLineNumbers(list, walker);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    private void dumpSymbolLineNumbers(List<String> list, ParserWalker walker) throws MemoryAccessException, UnknownInstructionException {
        TripleSymbol sym;
        String name;
        Constructor ct = walker.getConstructor();
        String tableName = ct.getParent().getName();
        List<String> printPieces = ct.getPrintPieces();
        String string = name = printPieces.size() == 0 ? "\n" : printPieces.get(0);
        if (!"instruction".equals(tableName) || name.startsWith("\n")) {
            name = tableName;
        }
        list.add(name + "(" + Integer.toString(ct.getLineno()) + ")");
        int flowthruindex = ct.getFlowthruIndex();
        if (flowthruindex != -1 && (sym = ct.getOperand(flowthruindex).getDefiningSymbol()) instanceof SubtableSymbol) {
            walker.pushOperand(flowthruindex);
            this.dumpSymbolLineNumbers(list, walker);
            walker.popOperand();
            return;
        }
        int numOperands = ct.getNumOperands();
        for (int i = 0; i < numOperands; ++i) {
            OperandSymbol sym2 = ct.getOperand(i);
            TripleSymbol tsym = sym2.getDefiningSymbol();
            if (tsym == null) continue;
            walker.pushOperand(i);
            Constructor subct = walker.getConstructor();
            if (subct != null) {
                this.dumpSymbolLineNumbers(list, walker);
            }
            walker.popOperand();
        }
    }

    public void append(int value, int startbit, int bitcount) {
        if (!this.isVerboseEnabled()) {
            return;
        }
        byte[] bytes = new byte[4];
        for (int n = 3; n >= 0; --n) {
            bytes[n] = (byte)value;
            value >>>= 8;
        }
        this.append(bytes, startbit, bitcount);
    }

    public void append(int[] value, int startbit, int bitcount) {
        if (!this.isVerboseEnabled()) {
            return;
        }
        byte[] bytes = new byte[value.length * 4];
        for (int i = 0; i < value.length; ++i) {
            int v = value[i];
            int baseIndex = i * 4;
            for (int n = 3; n >= 0; --n) {
                bytes[baseIndex + n] = (byte)v;
                v >>>= 8;
            }
        }
        this.append(bytes, startbit, bitcount);
    }

    public void append(byte[] value, int startbit, int bitcount) {
        if (!this.isVerboseEnabled()) {
            return;
        }
        int startByte = startbit / 8;
        int endbit = (startbit %= 8) + bitcount - 1;
        int endByte = startByte + endbit / 8;
        endbit %= 8;
        for (int i = 0; i < value.length; ++i) {
            Object byteStr = StringUtilities.pad((String)Integer.toBinaryString(value[i] & 0xFF), (char)'0', (int)8);
            if (startbit >= 0) {
                if (endByte == i) {
                    byteStr = ((String)byteStr).substring(0, endbit + 1) + ")" + ((String)byteStr).substring(endbit + 1);
                }
                if (startByte == i) {
                    byteStr = ((String)byteStr).substring(0, startbit) + "(" + ((String)byteStr).substring(startbit);
                }
            }
            this.append((String)byteStr);
            if (i >= value.length - 1) continue;
            this.append(".");
        }
    }

    public void append(String str) {
        if (!this.isVerboseEnabled()) {
            return;
        }
        int index = str.indexOf(10);
        while (index >= 0) {
            this.checkLineStart();
            this.buffer.append(str.substring(0, index + 1));
            str = str.substring(index + 1);
            this.atLineStart = true;
            index = str.indexOf(10);
        }
        if (str.length() != 0) {
            this.checkLineStart();
            this.buffer.append(str);
        }
    }

    private void checkLineStart() {
        if (this.atLineStart) {
            this.buffer.append(this.indent);
            this.atLineStart = false;
        }
    }

    public void indent() {
        ++this.indentLevel;
        this.indent = this.getIndent();
    }

    public void indent(int levels) {
        this.indentLevel += levels;
        this.indent = this.getIndent();
    }

    public void dropIndent() {
        if (this.indentLevel > 0) {
            --this.indentLevel;
            this.indent = this.getIndent();
        }
    }

    public void dropIndent(int levels) {
        if (this.indentLevel > 0) {
            this.indentLevel -= levels;
            if (this.indentLevel < 0) {
                this.indentLevel = 0;
            }
            this.indent = this.getIndent();
        }
    }

    private String getIndent() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.indentLevel; ++i) {
            buf.append("   ");
        }
        return buf.toString();
    }

    public String toString() {
        return this.buffer.toString();
    }

    void dumpConstructor(String subtableName, Constructor c) {
        if (!this.isVerboseEnabled()) {
            return;
        }
        if (subtableName != null) {
            this.append(" " + subtableName);
        } else {
            String name;
            SubtableSymbol parent = c.getParent();
            if (parent != null && !"instruction".equals(name = parent.getName())) {
                this.append(" " + name);
            }
        }
        this.append(": ");
        this.append("{line# ");
        this.append(Integer.toString(c.getLineno()));
        this.append("} ");
        List<String> printPieces = c.getPrintPieces();
        if (printPieces.size() == 0) {
            for (int i = 0; i < c.getNumOperands(); ++i) {
                if (i != 0) {
                    this.append(", ");
                }
                OperandSymbol operand = c.getOperand(i);
                this.append("<");
                this.append(operand.getName());
                this.append(">");
            }
        } else {
            for (String piece : printPieces) {
                if (piece.startsWith("\n")) {
                    int symIndex = piece.charAt(1) - 65;
                    OperandSymbol sym = c.getOperand(symIndex);
                    this.append("<");
                    this.append(sym.getName());
                    this.append(">");
                    continue;
                }
                this.append(piece);
            }
        }
        this.append("\n");
    }

    void dumpFixedHandle(String name, TripleSymbol definingSymbol, ParserWalker walker, Language language) throws MemoryAccessException {
        if (!this.isVerboseEnabled()) {
            return;
        }
        this.append(name);
        this.append(": ");
        FixedHandle hand = new FixedHandle();
        definingSymbol.getFixedHandle(hand, walker);
        if (hand.space.getType() == 0) {
            this.append("constant ");
            try {
                Scalar s = new Scalar(8 * hand.size, hand.offset_offset);
                this.append(s.toString(16, false, false, "0x", ""));
            }
            catch (Exception e) {
                this.append("Bad Value: " + e.getMessage());
            }
        } else {
            Address addr = hand.space.getAddress(hand.offset_offset);
            Register reg = language.getRegister(addr, hand.size);
            if (reg != null) {
                this.append("register ");
                this.append(reg.getName());
            } else {
                this.append("memory ");
                this.append(addr.toString(true));
            }
        }
        this.append(" (size:");
        this.append(Integer.toString(hand.size));
        this.append(")\n");
    }

    void dumpPattern(OperandSymbol sym, ParserWalker walker) throws MemoryAccessException {
        if (!this.isVerboseEnabled()) {
            return;
        }
        String name = sym.getName();
        PatternExpression definingExpression = sym.getDefiningExpression();
        this.append(name);
        this.append(": ");
        this.append(definingExpression.getClass().getSimpleName());
        this.append(" = ");
        try {
            Scalar s = new Scalar(32, definingExpression.getValue(walker), this.isSigned(definingExpression));
            this.append(s.toString(16, false, true, "0x", ""));
        }
        catch (Exception e) {
            this.append("Bad Value: " + e.getMessage());
        }
        this.append("\n");
    }

    public void dumpContextPattern(int[] maskvec, int[] valvec, int byteOffset, SleighParserContext pos) {
        if (!this.isVerboseEnabled()) {
            return;
        }
        if (this.contextBaseRegister == null) {
            return;
        }
        assert (maskvec.length == valvec.length);
        int[] currentValue = new int[(this.contextBaseRegister.getMinimumByteSize() + 3) / 4];
        for (int i = 0; i < currentValue.length; ++i) {
            currentValue[i] = pos.getContextBytes(i * 4, 4);
        }
        byte[] maskActualValue = new byte[currentValue.length * 4 * 2];
        System.arraycopy(this.getBytes(currentValue), 0, maskActualValue, maskActualValue.length / 2, maskActualValue.length / 2);
        int vecByteCnt = Math.min(this.contextBaseRegister.getMinimumByteSize() - byteOffset, maskvec.length * 4);
        byte[] maskPatternValue = new byte[2 * this.contextBaseRegister.getMinimumByteSize()];
        System.arraycopy(this.getBytes(valvec), 0, maskPatternValue, maskPatternValue.length / 2 + byteOffset, vecByteCnt);
        byte[] mask = this.getBytes(maskvec);
        System.arraycopy(mask, 0, maskActualValue, byteOffset, vecByteCnt);
        System.arraycopy(mask, 0, maskPatternValue, byteOffset, vecByteCnt);
        RegisterValue actualValue = new RegisterValue(this.contextBaseRegister, maskActualValue);
        RegisterValue matchValue = new RegisterValue(this.contextBaseRegister, maskPatternValue);
        this.indent(4);
        int baseRegSize = this.contextBaseRegister.getMinimumByteSize() * 8;
        for (Register reg : this.contextBaseRegister.getChildRegisters()) {
            RegisterValue childMatchValue = matchValue.getRegisterValue(reg);
            RegisterValue childActualValue = actualValue.getRegisterValue(reg);
            if (!childMatchValue.hasAnyValue()) continue;
            BigInteger actual = childActualValue.getUnsignedValueIgnoreMask();
            BigInteger match = childMatchValue.getUnsignedValueIgnoreMask();
            String partialMatch = childMatchValue.hasValue() ? "" : "*";
            String matchStr = match.equals(actual) ? " Match" : " Failed (=0x" + Long.toHexString(actual.longValue()) + ")";
            int msb = baseRegSize - reg.getLeastSignificatBitInBaseRegister() - 1;
            int lsb = msb - reg.getBitLength() + 1;
            this.append(partialMatch + reg.getName() + "(" + lsb + "," + msb + ") == 0x" + Long.toHexString(match.longValue()) + matchStr);
            this.append("\n");
        }
        this.dropIndent(4);
    }

    public void dumpContextSet(SleighParserContext pos, int num, int value, int mask) {
        if (!this.isVerboseEnabled()) {
            return;
        }
        int[] currentValue = new int[(this.contextBaseRegister.getMinimumByteSize() + 3) / 4];
        for (int i = 0; i < currentValue.length; ++i) {
            currentValue[i] = pos.getContextBytes(i * 4, 4);
        }
        currentValue[num] = currentValue[num] & ~mask | mask & value;
        byte[] maskActualValue = new byte[currentValue.length * 4 * 2];
        System.arraycopy(this.getBytes(currentValue), 0, maskActualValue, maskActualValue.length / 2, maskActualValue.length / 2);
        int byteOffset = num * 4;
        System.arraycopy(this.getBytes(new int[]{mask}), 0, maskActualValue, byteOffset, 4);
        RegisterValue actualValue = new RegisterValue(this.contextBaseRegister, maskActualValue);
        this.indent(2);
        int baseRegSize = this.contextBaseRegister.getMinimumByteSize() * 8;
        for (Register reg : this.contextBaseRegister.getChildRegisters()) {
            RegisterValue childActualValue = actualValue.getRegisterValue(reg);
            if (!childActualValue.hasAnyValue()) continue;
            BigInteger actual = childActualValue.getUnsignedValueIgnoreMask();
            int msb = baseRegSize - reg.getLeastSignificatBitInBaseRegister() - 1;
            int lsb = msb - reg.getBitLength() + 1;
            this.append("Set " + reg.getName() + "(" + lsb + "," + msb + ") = 0x" + Long.toHexString(actual.longValue()) + "\n");
        }
        this.dropIndent(2);
    }

    public void dumpGlobalSet(SleighParserContext pos, ConstructState state, TripleSymbol sym, int num, int mask, int value) throws MemoryAccessException {
        if (!this.isVerboseEnabled()) {
            return;
        }
        this.dumpGlobalSet(state, num, mask, value, null);
    }

    private void dumpGlobalSet(ConstructState state, int num, int mask, int value, Address setAddr) {
        byte[] maskActualValue = new byte[this.contextBaseRegister.getMinimumByteSize() * 2];
        int byteOffset = num * 4;
        System.arraycopy(this.getBytes(new int[]{value}), 0, maskActualValue, maskActualValue.length / 2 + byteOffset, 4);
        System.arraycopy(this.getBytes(new int[]{mask}), 0, maskActualValue, byteOffset, 4);
        RegisterValue actualValue = new RegisterValue(this.contextBaseRegister, maskActualValue);
        String msg = "Commit future value" + (String)(setAddr != null ? " at " + setAddr : "") + ": ";
        this.indent(2);
        int baseRegSize = this.contextBaseRegister.getMinimumByteSize() * 8;
        for (Register reg : this.contextBaseRegister.getChildRegisters()) {
            RegisterValue childActualValue = actualValue.getRegisterValue(reg);
            if (!childActualValue.hasAnyValue()) continue;
            BigInteger actual = childActualValue.getUnsignedValueIgnoreMask();
            int msb = baseRegSize - reg.getLeastSignificatBitInBaseRegister() - 1;
            int lsb = msb - reg.getBitLength() + 1;
            this.append(msg + reg.getName() + "(" + lsb + "," + msb + ") = 0x" + Long.toHexString(actual.longValue()) + "\n");
        }
        this.dropIndent(2);
    }

    private void dumpFinalGlobalSets() throws MemoryAccessException {
        SleighParserContext protoContext = this.prototype.getParserContext(this.buf, this.context);
        ParserWalker walker = new ParserWalker(protoContext);
        Iterator<SleighParserContext.ContextSet> contextCommits = protoContext.getContextCommits();
        while (contextCommits.hasNext()) {
            SleighParserContext.ContextSet set = contextCommits.next();
            walker.subTreeState(set.point);
            FixedHandle hand = new FixedHandle();
            set.sym.getFixedHandle(hand, walker);
            long offset = hand.offset_offset;
            AddressSpace curSpace = this.buf.getAddress().getAddressSpace();
            if (hand.space.getType() == 0) {
                offset *= (long)curSpace.getAddressableUnitSize();
            }
            Address address = curSpace.getAddress(offset);
            this.dumpGlobalSet(set.point, set.num, set.mask, set.value, address);
        }
    }

    private byte[] getBytes(int[] ints) {
        byte[] bytes = new byte[ints.length * 4];
        for (int i = 0; i < ints.length; ++i) {
            int baseIndex = i * 4;
            int val = ints[i];
            bytes[baseIndex + 3] = (byte)val;
            bytes[baseIndex + 2] = (byte)(val >>= 8);
            bytes[baseIndex + 1] = (byte)(val >>= 8);
            bytes[baseIndex] = (byte)(val >>= 8);
        }
        return bytes;
    }

    private boolean isSigned(PatternExpression definingExpression) {
        if (definingExpression instanceof TokenField) {
            return ((TokenField)definingExpression).hasSignbit();
        }
        if (definingExpression instanceof ContextField) {
            return ((ContextField)definingExpression).hasSignbit();
        }
        if (definingExpression instanceof BinaryExpression) {
            BinaryExpression binaryExpr = (BinaryExpression)definingExpression;
            return this.isSigned(binaryExpr.getLeft()) || this.isSigned(binaryExpr.getRight());
        }
        return false;
    }

    public void startPatternGroup(String name) {
        PatternGroup newGroup = new PatternGroup(this.currentGroup, name);
        if (this.currentGroup == this.mainGroup && name != null) {
            this.mainSubGroups.put(name, newGroup);
        }
        this.currentGroup = newGroup;
        ++this.currentDepth;
    }

    public void endPatternGroup(boolean commit) {
        PatternGroup parent = this.currentGroup.getParent();
        if (commit) {
            parent.add(this.currentGroup);
        }
        this.currentGroup = parent;
        --this.currentDepth;
    }

    public void addInstructionPattern(int offset, PatternBlock maskvalue) {
        this.currentGroup.add(new InstructionBitPattern(offset, maskvalue));
    }

    public void addContextPattern(PatternBlock maskvalue) {
    }

    private void buildMasks() {
        if (this.prototype == null || this.currentDepth != 0) {
            throw new IllegalStateException("Pattern is not complete");
        }
        if (this.instructionMask != null) {
            return;
        }
        this.instructionMask = this.mainGroup.getMask(this.prototype.getLength());
        for (int i = 0; i < this.getNumOperands(); ++i) {
            byte[] opMask = this.buildOperandMask(i);
            this.operandMasks.add(opMask);
            this.clearBits(this.instructionMask, opMask);
        }
    }

    private void clearBits(byte[] destMask, byte[] clearSrcMask) {
        for (int i = 0; i < destMask.length; ++i) {
            int n = i;
            destMask[n] = (byte)(destMask[n] & ~clearSrcMask[i]);
        }
    }

    private byte[] buildOperandMask(int opIndex) {
        PatternGroup symGroup;
        byte[] mask = new byte[this.instructionMask.length];
        OperandSymbol sym = this.prototype.getOperandSymbol(opIndex, this.buf, this.context);
        if (sym == null) {
            return mask;
        }
        ConstructState mnemonicState = this.prototype.getMnemonicState();
        this.combineOperandMask(mnemonicState, sym, mask);
        boolean emptyMask = true;
        for (byte element : mask) {
            if (element == 0) continue;
            emptyMask = false;
            break;
        }
        if (emptyMask && (symGroup = this.mainSubGroups.get(sym.getName())) != null) {
            mask = symGroup.getMask(mask.length);
        }
        return mask;
    }

    public byte[] getInstructionMask() {
        this.buildMasks();
        return this.instructionMask;
    }

    public String getFormattedInstructionMask(int opIndex) {
        byte[] mask = opIndex < 0 ? this.getInstructionMask() : this.getOperandValueMask(opIndex);
        return SleighDebugLogger.getFormattedBytes(mask);
    }

    public String getFormattedMaskedValue(int opIndex) {
        byte[] mask = opIndex < 0 ? this.getInstructionMask() : this.getOperandValueMask(opIndex);
        byte[] value = this.getMaskedBytes(mask);
        return SleighDebugLogger.getFormattedBytes(value);
    }

    public static String getFormattedBytes(byte[] value) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < value.length; ++i) {
            String byteStr = StringUtilities.pad((String)Integer.toBinaryString(value[i] & 0xFF), (char)'0', (int)8);
            buf.append(byteStr);
            if (i >= value.length - 1) continue;
            buf.append(" ");
        }
        return buf.toString();
    }

    public int getNumOperands() {
        if (this.prototype == null) {
            throw new IllegalStateException("Pattern is not complete");
        }
        return this.prototype.getNumOperands();
    }

    public byte[] getMaskedBytes(byte[] mask) {
        if (this.prototype == null) {
            throw new IllegalStateException("Pattern is not complete");
        }
        if (mask.length != this.bytes.length) {
            throw new IllegalArgumentException("inappropriate mask");
        }
        byte[] result = new byte[this.bytes.length];
        for (int i = 0; i < this.bytes.length; ++i) {
            result[i] = (byte)(mask[i] & this.bytes[i]);
        }
        return result;
    }

    public byte[] getOperandValueMask(int opIndex) {
        this.buildMasks();
        return this.operandMasks.get(opIndex);
    }

    private void combineOperandMask(ConstructState state, OperandSymbol sym, byte[] mask) {
        ConstructState subState;
        PatternExpression patternExpression = null;
        int hand = sym.getIndex();
        TripleSymbol triple = sym.getDefiningSymbol();
        if (triple != null) {
            if (triple instanceof SubtableSymbol) {
                subState = state.getSubState(hand);
                this.combineSymbolMask(subState, mask);
            } else {
                patternExpression = triple.getPatternExpression();
            }
        } else {
            patternExpression = sym.getDefiningExpression();
        }
        if (sym.getOffsetBase() < 0) {
            this.combinePatternMask(state, patternExpression, state.getOffset() + sym.getRelativeOffset(), mask);
        } else {
            subState = state.getSubState(hand);
            this.combinePatternMask(subState, patternExpression, subState.getOffset(), mask);
        }
    }

    private void combinePatternMask(ConstructState state, PatternExpression patternExpression, int patternOffset, byte[] mask) {
        if (patternExpression instanceof UnaryExpression) {
            this.combinePatternMask(state, ((UnaryExpression)patternExpression).getUnary(), patternOffset, mask);
        } else if (patternExpression instanceof BinaryExpression) {
            this.combinePatternMask(state, ((BinaryExpression)patternExpression).getLeft(), patternOffset, mask);
            this.combinePatternMask(state, ((BinaryExpression)patternExpression).getRight(), patternOffset, mask);
        } else if (patternExpression instanceof OperandValue) {
            OperandValue opVal = (OperandValue)patternExpression;
            Constructor c = opVal.getConstructor();
            int opIndex = opVal.getIndex();
            this.combineOperandMask(state, c.getOperand(opIndex), mask);
        } else if (patternExpression instanceof TokenField) {
            TokenField tf = (TokenField)patternExpression;
            int size = tf.getByteEnd() + 1;
            int startByteIndex = tf.getByteStart();
            int endByteIndex = size - 1;
            int startBit = tf.getBitStart() % 8;
            int endBit = tf.getBitEnd() % 8;
            boolean bigEndian = this.buf.isBigEndian();
            for (int i = startByteIndex; i <= endByteIndex; ++i) {
                int firstBit = 0;
                int lastBit = 7;
                if (i == endByteIndex) {
                    if (bigEndian) {
                        firstBit = startBit;
                    } else {
                        lastBit = endBit;
                    }
                }
                if (i == startByteIndex) {
                    if (bigEndian) {
                        lastBit = endBit;
                    } else {
                        firstBit = startBit;
                    }
                }
                byte byteMask = (byte)(255 >> 7 - lastBit + firstBit << firstBit);
                int n = i + patternOffset;
                mask[n] = (byte)(mask[n] | byteMask);
            }
        }
    }

    private void combineSymbolMask(ConstructState constructState, byte[] mask) {
        Constructor c = constructState.getConstructor();
        for (String piece : c.getPrintPieces()) {
            if (!piece.startsWith("\n")) continue;
            int opIndex = piece.charAt(1) - 65;
            this.combineOperandMask(constructState, c.getOperand(opIndex), mask);
        }
    }

    private static String getPrototypeRepresentation(SleighInstructionPrototype proto, InstructionContext instrContext) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(proto.getMnemonic(instrContext));
        int n = proto.getNumOperands();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(i == 0 ? " " : ",");
            stringBuffer.append(SleighDebugLogger.getDefaultOperandRepresentation(proto, i, instrContext));
        }
        return stringBuffer.toString();
    }

    private static String getDefaultOperandRepresentation(SleighInstructionPrototype proto, int opIndex, InstructionContext instrContext) {
        ArrayList<Object> opList = proto.getOpRepresentationList(opIndex, instrContext);
        if (opList == null) {
            return "<UNSUPPORTED>";
        }
        StringBuffer strBuf = new StringBuffer();
        for (Object opElem : opList) {
            if (opElem instanceof Address) {
                Address opAddr = (Address)opElem;
                strBuf.append("0x");
                strBuf.append(opAddr.toString(false));
                continue;
            }
            strBuf.append(opElem.toString());
        }
        return strBuf.toString();
    }

    private static class MyProcessorContextView
    implements ProcessorContextView {
        private ProgramContext programContext;
        private Address address;
        private ProcessorContextView originalContext;

        MyProcessorContextView(ProgramContext programContext, Address address) {
            this.programContext = programContext;
            this.address = address;
        }

        MyProcessorContextView(ProcessorContextView originalContext) {
            this.originalContext = originalContext;
        }

        @Override
        public Register getBaseContextRegister() {
            return this.programContext.getBaseContextRegister();
        }

        @Override
        public Register getRegister(String name) {
            if (this.originalContext != null) {
                return this.originalContext.getRegister(name);
            }
            return this.programContext.getRegister(name);
        }

        @Override
        public RegisterValue getRegisterValue(Register register) {
            if (this.originalContext != null) {
                return this.originalContext.getRegisterValue(register);
            }
            return this.programContext.getRegisterValue(register, this.address);
        }

        @Override
        public Register[] getRegisters() {
            if (this.originalContext != null) {
                return this.originalContext.getRegisters();
            }
            return this.programContext.getRegisters();
        }

        @Override
        public BigInteger getValue(Register register, boolean signed) {
            if (this.originalContext != null) {
                return this.originalContext.getValue(register, signed);
            }
            return this.programContext.getValue(register, this.address, signed);
        }

        @Override
        public boolean hasValue(Register register) {
            if (this.originalContext != null) {
                return this.originalContext.hasValue(register);
            }
            RegisterValue registerValue = this.programContext.getRegisterValue(register, this.address);
            return registerValue != null && registerValue.hasValue();
        }
    }

    private static class InstructionBitPattern {
        private int offset;
        private PatternBlock maskvalue;

        InstructionBitPattern(int offset, PatternBlock maskvalue) {
            this.offset = offset;
            this.maskvalue = maskvalue;
        }

        byte[] getMask(int length) {
            return this.getBytes(this.maskvalue.getMaskVector(), length);
        }

        private byte[] getBytes(int[] value, int byteLength) {
            byte[] bytes = new byte[byteLength];
            for (int i = 0; i < value.length; ++i) {
                int v = value[i];
                int baseIndex = i * 4;
                for (int n = 3; n >= 0; --n) {
                    int index = baseIndex + n + this.offset;
                    if (index < byteLength) {
                        bytes[index] = (byte)v;
                    }
                    v >>>= 8;
                }
            }
            return bytes;
        }
    }

    private static class PatternGroup
    extends ArrayList<Object> {
        private static final long serialVersionUID = 1L;
        private String name;
        private PatternGroup parent;

        PatternGroup(PatternGroup parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        String getPathname() {
            if (this.parent == null) {
                return "";
            }
            if (this.name == null) {
                return null;
            }
            Object parentPath = this.parent.getPathname();
            if (parentPath == null) {
                return null;
            }
            if (((String)parentPath).length() != 0) {
                parentPath = (String)parentPath + ".";
            }
            return (String)parentPath + this.name;
        }

        PatternGroup getParent() {
            return this.parent;
        }

        byte[] getMask(int length) {
            byte[] mask = new byte[length];
            for (Object child : this) {
                if (child instanceof PatternGroup) {
                    this.combine((PatternGroup)child, mask);
                    continue;
                }
                if (!(child instanceof InstructionBitPattern)) continue;
                this.combine((InstructionBitPattern)child, mask);
            }
            return mask;
        }

        private void combine(PatternGroup group, byte[] mask) {
            byte[] groupMask = group.getMask(mask.length);
            for (int i = 0; i < mask.length; ++i) {
                int n = i;
                mask[n] = (byte)(mask[n] | groupMask[i]);
            }
        }

        private void combine(InstructionBitPattern instructionBitPattern, byte[] mask) {
            byte[] patternMask = instructionBitPattern.getMask(mask.length);
            for (int i = 0; i < mask.length; ++i) {
                int n = i;
                mask[n] = (byte)(mask[n] | patternMask[i]);
            }
        }

        @Override
        public String toString() {
            int subGroupCnt = 0;
            int patternCnt = 0;
            for (Object child : this) {
                if (child instanceof PatternGroup) {
                    ++subGroupCnt;
                    continue;
                }
                if (!(child instanceof InstructionBitPattern)) continue;
                ++patternCnt;
            }
            return (this.name != null ? this.name : "<null>") + ": patterns=" + patternCnt + " symbols=" + subGroupCnt;
        }
    }

    private class DebugInstructionContext
    implements InstructionContext {
        private ParserContext parserContext;

        private DebugInstructionContext() {
        }

        @Override
        public Address getAddress() {
            return SleighDebugLogger.this.buf.getAddress();
        }

        @Override
        public ProcessorContextView getProcessorContext() {
            return SleighDebugLogger.this.context;
        }

        @Override
        public MemBuffer getMemBuffer() {
            return SleighDebugLogger.this.buf;
        }

        @Override
        public ParserContext getParserContext() throws MemoryAccessException {
            if (this.parserContext == null) {
                this.parserContext = SleighDebugLogger.this.prototype.getParserContext(SleighDebugLogger.this.buf, SleighDebugLogger.this.context);
            }
            return this.parserContext;
        }

        @Override
        public ParserContext getParserContext(Address instructionAddress) throws UnknownContextException, MemoryAccessException {
            if (instructionAddress.equals(SleighDebugLogger.this.buf.getAddress())) {
                return this.getParserContext();
            }
            SleighDebugLogger.this.append("Warning! ignored request for instruction context at " + instructionAddress);
            return null;
        }
    }

    public static enum SleighDebugMode {
        VERBOSE,
        MASKS_ONLY;

    }
}

