/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.db;

import db.DBHandle;
import db.Field;
import db.OpenMode;
import db.Record;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import ghidra.feature.vt.api.db.VTMatchSetTableDBAdapterV0;
import ghidra.feature.vt.api.main.VTProgramCorrelator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.AddressSet;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.LinkedList;

public abstract class VTMatchSetTableDBAdapter {
    static String TABLE_NAME = "MatchSetTable";
    static Schema TABLE_SCHEMA = new Schema(0, "Key", (Class[])ColumnDescription.getColumnClasses(), ColumnDescription.getColumnNames());

    static VTMatchSetTableDBAdapter createAdapter(DBHandle dbHandle) throws IOException {
        return new VTMatchSetTableDBAdapterV0(dbHandle);
    }

    static VTMatchSetTableDBAdapter getAdapter(DBHandle dbHandle, OpenMode openMode, TaskMonitor monitor) throws VersionException {
        return new VTMatchSetTableDBAdapterV0(dbHandle, openMode);
    }

    public abstract Record createMatchSetRecord(long var1, VTProgramCorrelator var3) throws IOException;

    public abstract RecordIterator getRecords() throws IOException;

    public abstract AddressSet getSourceAddressSet(Record var1, AddressMap var2) throws IOException;

    public abstract AddressSet getDestinationAddressSet(Record var1, AddressMap var2) throws IOException;

    public abstract long getNextMatchSetID();

    public abstract Record getRecord(long var1) throws IOException;

    public static enum ColumnDescription {
        CORRELATOR_CLASS_COL(StringField.class),
        CORRELATOR_NAME_COL(StringField.class),
        OPTIONS_COL(StringField.class);

        private final Class<? extends Field> columnClass;

        private ColumnDescription(Class<? extends Field> columnClass) {
            this.columnClass = columnClass;
        }

        public Class<? extends Field> getColumnClass() {
            return this.columnClass;
        }

        public int column() {
            return this.ordinal();
        }

        private static String[] getColumnNames() {
            ColumnDescription[] columns = ColumnDescription.values();
            LinkedList<String> list = new LinkedList<String>();
            for (ColumnDescription column : columns) {
                list.add(column.name());
            }
            return list.toArray(new String[columns.length]);
        }

        private static Class<? extends Field>[] getColumnClasses() {
            ColumnDescription[] columns = ColumnDescription.values();
            LinkedList<Class<? extends Field>> list = new LinkedList<Class<? extends Field>>();
            for (ColumnDescription column : columns) {
                list.add(column.getColumnClass());
            }
            return list.toArray(new Class[columns.length]);
        }
    }
}

