/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.db;

import ghidra.feature.fid.db.FunctionRecord;
import ghidra.feature.fid.hash.FidHashQuad;

public class FidDBUtils {
    public static long generateSuperiorFullHashSmash(FunctionRecord superiorFunction, FunctionRecord inferiorFunction) {
        long hashValue = superiorFunction.getKey() * 1099511628211L;
        return hashValue ^ inferiorFunction.getFullHash();
    }

    public static long generateInferiorFullHashSmash(FunctionRecord superiorFunction, FunctionRecord inferiorFunction) {
        long hashValue = inferiorFunction.getKey() * 1099511628211L;
        return hashValue ^ superiorFunction.getFullHash();
    }

    public static long generateSuperiorFullHashSmash(FunctionRecord superiorFunction, FidHashQuad inferiorFunction) {
        long hashValue = superiorFunction.getKey() * 1099511628211L;
        return hashValue ^ inferiorFunction.getFullHash();
    }

    public static long generateInferiorFullHashSmash(FidHashQuad superiorFunction, FunctionRecord inferiorFunction) {
        long hashValue = inferiorFunction.getKey() * 1099511628211L;
        return hashValue ^ superiorFunction.getFullHash();
    }
}

