/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.cparser.C;

import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.cparser.C.CParser;
import ghidra.app.util.cparser.C.ParseException;
import ghidra.app.util.cparser.C.TokenMgrError;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.listing.Program;
import ghidra.util.HTMLUtilities;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import java.util.Arrays;

public class CParserUtils {
    private CParserUtils() {
    }

    public static FunctionDefinitionDataType parseSignature(ServiceProvider serviceProvider, Program program, String signatureText) {
        DataTypeManagerService service = (DataTypeManagerService)serviceProvider.getService(DataTypeManagerService.class);
        return CParserUtils.parseSignature(service, program, signatureText);
    }

    public static FunctionDefinitionDataType parseSignature(DataTypeManagerService service, Program program, String signatureText) {
        try {
            return CParserUtils.parseSignature(service, program, signatureText, true);
        }
        catch (ParseException e) {
            Msg.debug(CParserUtils.class, (Object)"Logging an exception that cannot happen (the code must have changed)", (Throwable)e);
            return null;
        }
    }

    private static String[] splitFunctionSignature(String signature) {
        int index = signature.lastIndexOf(41);
        if (index < 0) {
            return null;
        }
        int closureCount = 1;
        while (--index > 0) {
            char c = signature.charAt(index);
            if (c == ' ') continue;
            if (c == ')') {
                ++closureCount;
                continue;
            }
            if (c == '(') {
                --closureCount;
                continue;
            }
            if (closureCount > 0) continue;
            break;
        }
        if (closureCount != 0) {
            return null;
        }
        String[] parts = new String[3];
        parts[2] = signature.substring(index + 1);
        int spaceIndex = (signature = signature.substring(0, index + 1)).lastIndexOf(32);
        if (spaceIndex <= 0) {
            return null;
        }
        parts[1] = signature.substring(spaceIndex + 1);
        parts[0] = signature.substring(0, spaceIndex);
        return parts;
    }

    private static String getTempName(int length) {
        char[] nameChars = new char[length];
        Arrays.fill(nameChars, 't');
        return new String(nameChars);
    }

    public static FunctionDefinitionDataType parseSignature(DataTypeManagerService service, Program program, String signatureText, boolean handleExceptions) throws ParseException {
        DataTypeManager[] dataTypeManagerArray;
        if (service != null) {
            dataTypeManagerArray = CParserUtils.getDataTypeManagers(service);
        } else {
            DataTypeManager[] dataTypeManagerArray2 = new DataTypeManager[1];
            dataTypeManagerArray = dataTypeManagerArray2;
            dataTypeManagerArray2[0] = program.getDataTypeManager();
        }
        DataTypeManager[] dataTypeManagers = dataTypeManagerArray;
        CParser parser = new CParser(program.getDataTypeManager(), false, dataTypeManagers);
        String[] signatureParts = CParserUtils.splitFunctionSignature(signatureText);
        if (signatureParts == null) {
            Msg.debug(CParserUtils.class, (Object)("Invalid signature: unable to isolate function name : " + signatureText));
            return null;
        }
        String replacedText = signatureParts[0] + " " + CParserUtils.getTempName(signatureParts[1].length()) + signatureParts[2];
        DataType dt = null;
        try {
            dt = parser.parse(replacedText + ";");
            if (!(dt instanceof FunctionDefinitionDataType)) {
                return null;
            }
            dt.setName(signatureParts[1]);
            return (FunctionDefinitionDataType)dt;
        }
        catch (InvalidNameException | DuplicateNameException e) {
            Msg.debug(CParserUtils.class, (Object)"Logging an exception that cannot happen (the code must have changed)", (Throwable)e);
        }
        catch (Throwable t) {
            if (!handleExceptions) {
                throw t;
            }
            String msg = CParserUtils.handleParseProblem(t, signatureText);
            if (msg != null) {
                Msg.showError(CParserUtils.class, null, (String)"Invalid Function Signature", (Object)msg);
            }
            Msg.debug(CParserUtils.class, (Object)("Error parsing signature: " + signatureText), (Throwable)t);
        }
        return null;
    }

    private static DataTypeManager[] getDataTypeManagers(DataTypeManagerService service) {
        if (service == null) {
            return null;
        }
        DataTypeManager[] openDTmanagers = service.getDataTypeManagers();
        return openDTmanagers;
    }

    public static String handleParseProblem(Throwable t, String functionString) {
        if (t instanceof TokenMgrError) {
            return CParserUtils.generateTokenErrorMessage((TokenMgrError)t, functionString);
        }
        if (t instanceof ParseException) {
            return CParserUtils.generateParseExceptionMessage((ParseException)t, functionString);
        }
        return null;
    }

    private static String generateTokenErrorMessage(TokenMgrError e, String functionString) {
        String message = e.getMessage();
        int errorIndex = CParserUtils.getTokenMgrErrorIndexOfInvalidText(message, functionString);
        if (errorIndex < 0) {
            errorIndex = CParserUtils.getTokenMgrErrorIndexUsingErrorColumn(message);
        }
        if (errorIndex < 0) {
            return null;
        }
        return CParserUtils.generateParsingExceptionMessage(e.getMessage(), errorIndex, functionString);
    }

    private static int getTokenMgrErrorIndexOfInvalidText(String message, String functionString) {
        String invalidCharMarker = "after : ";
        int index = message.indexOf(invalidCharMarker);
        if (index >= 0) {
            String remainder = message.substring(index + invalidCharMarker.length());
            remainder = remainder.replaceAll("\"", "");
            return functionString.indexOf(remainder);
        }
        return -1;
    }

    private static int getTokenMgrErrorIndexUsingErrorColumn(String message) {
        String columnMarker = "column ";
        int index = message.indexOf(columnMarker);
        if (index >= 0) {
            String remainder = message.substring(index + columnMarker.length());
            int dotIndex = remainder.indexOf(".");
            String column = remainder.substring(0, dotIndex);
            try {
                return Integer.parseInt(column);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private static String generateParseExceptionMessage(ParseException pe, String functionString) {
        if (pe.currentToken == null) {
            return null;
        }
        int errorIndex = pe.currentToken.beginColumn;
        if (errorIndex < 0) {
            return null;
        }
        return CParserUtils.generateParsingExceptionMessage(pe.getMessage(), errorIndex, functionString);
    }

    private static String generateParsingExceptionMessage(String errorMessage, int errorIndex, String functionString) {
        Object parseMessage = "";
        if (errorMessage != null) {
            parseMessage = errorMessage.replaceAll("\n", " ");
            parseMessage = HTMLUtilities.lineWrapWithHTMLLineBreaks((String)HTMLUtilities.escapeHTML((String)parseMessage), (int)80);
            parseMessage = "<br><br>" + (String)parseMessage + "<br>";
        }
        StringBuffer successFailureBuffer = new StringBuffer();
        successFailureBuffer.append("<blockquote>");
        if (errorIndex == 0) {
            successFailureBuffer.append("<font color=\"red\"><b>");
            successFailureBuffer.append(HTMLUtilities.friendlyEncodeHTML((String)functionString));
            successFailureBuffer.append("</b></font>");
        } else {
            successFailureBuffer.append("<font color=\"black\">");
            successFailureBuffer.append(HTMLUtilities.friendlyEncodeHTML((String)functionString.substring(0, errorIndex)));
            successFailureBuffer.append("</font>");
            successFailureBuffer.append("<font color=\"red\"><b>");
            successFailureBuffer.append(HTMLUtilities.friendlyEncodeHTML((String)functionString.substring(errorIndex)));
            successFailureBuffer.append("</b></font>");
        }
        successFailureBuffer.append("</blockquote>");
        if (errorIndex == 0) {
            return "<html>Function signature parse failed" + (String)parseMessage + "<br>" + successFailureBuffer;
        }
        return "<html>Function signature parse failed on token starting near character " + errorIndex + "<br>" + successFailureBuffer;
    }
}

