/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.bin.format.pe.cli.tables.indexes.CliIndexHasConstant;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class CliTableConstant
extends CliAbstractTable {
    public CliTableConstant(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            CliConstantRow row = new CliConstantRow(reader.readNextByte(), reader.readNextByte(), CliIndexHasConstant.readCodedIndex(reader, stream), this.readBlobIndex(reader));
            this.rows.add(row);
            this.blobs.add(row.valueIndex);
        }
        reader.setPointerIndex(this.readerOffset);
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "Constant Row", 0);
        rowDt.add((DataType)CliAbstractSig.CliTypeCodeDataType.dataType, "Type", "if Class, indicates nullref");
        rowDt.add(BYTE, "Reserved", "should be 0");
        rowDt.add(CliIndexHasConstant.toDataType(this.metadataStream), "Parent", "index - coded HasConstant");
        rowDt.add(this.metadataStream.getBlobIndexDataType(), "Value", "index into Blob heap");
        return rowDt;
    }

    public class CliConstantRow
    extends CliAbstractTableRow {
        public byte type;
        public byte reserved;
        public int parentIndex;
        public int valueIndex;

        public CliConstantRow(byte type, byte reserved, int parentIndex, int valueIndex) {
            this.type = type;
            this.reserved = reserved;
            this.parentIndex = parentIndex;
            this.valueIndex = valueIndex;
        }

        @Override
        public String getRepresentation() {
            String parentRep;
            try {
                parentRep = CliTableConstant.this.getRowRepresentationSafe(CliIndexHasConstant.getTableName(this.parentIndex), CliIndexHasConstant.getRowIndex(this.parentIndex));
            }
            catch (InvalidInputException e) {
                parentRep = Integer.toHexString(this.parentIndex);
            }
            return String.format("Type %d Parent %s Value %x", this.type, parentRep, this.valueIndex);
        }
    }
}

