/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.blobs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig;
import ghidra.app.util.bin.format.pe.cli.blobs.CliBlob;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class CliSigField
extends CliAbstractSig {
    public static final byte identifier = 6;
    public CliAbstractSig.CliParam type;

    public CliSigField(CliBlob blob) throws IOException {
        super(blob);
        BinaryReader reader = this.getContentsReader();
        byte firstByte = reader.readNextByte();
        if (firstByte != 6) {
            return;
        }
        try {
            this.type = new CliAbstractSig.CliParam(reader);
        }
        catch (InvalidInputException e) {
            this.type = null;
        }
    }

    public static boolean isFieldSig(CliBlob blob) throws IOException {
        return blob.getContentsReader().readNextByte() == 6;
    }

    @Override
    public DataType getContentsDataType() {
        StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Blobs/Signatures"), this.getName(), 0);
        struct.add(BYTE, "FIELD", "0x06");
        struct.add(this.type.getDefinitionDataType(), "Type", null);
        return struct;
    }

    @Override
    public String getContentsName() {
        return "FieldSig";
    }

    @Override
    public String getContentsComment() {
        return "Type information for Field";
    }

    @Override
    public String getRepresentationCommon(CliStreamMetadata stream, boolean isShort) {
        return this.getRepresentationOf(this.type, stream, isShort);
    }
}

