/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.elf.ElfHeader;
import java.io.IOException;

public class ElfString {
    private ElfHeader header;
    private int stringOffset;
    private String string;

    public static ElfString createElfString(FactoryBundledWithBinaryReader reader, int stringOffset, ElfHeader header) throws IOException {
        ElfString elfString = (ElfString)reader.getFactory().create(ElfString.class, new Object[0]);
        elfString.initElfString(reader, stringOffset, header);
        return elfString;
    }

    private void initElfString(FactoryBundledWithBinaryReader reader, int stringOffset, ElfHeader header) throws IOException {
        this.header = header;
        this.stringOffset = stringOffset;
        this.string = reader.readAsciiString(0L);
    }

    public String getString() {
        return this.string;
    }

    public int getStringOffset() {
        return this.stringOffset;
    }
}

