/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import ghidra.app.plugin.core.navigation.locationreferences.DataTypeLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.ReferenceUtils;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.MnemonicFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.AssertException;

public class MnemonicLocationDescriptor
extends DataTypeLocationDescriptor {
    MnemonicLocationDescriptor(ProgramLocation location, Program program) {
        super(location, program);
        if (!(location instanceof MnemonicFieldLocation)) {
            throw new AssertException("Unexpected ProgramLocation type - Cannot create a LocationDescriptor for type: " + location);
        }
    }

    @Override
    protected String generateLabel() {
        MnemonicFieldLocation mnemonicLocation = (MnemonicFieldLocation)this.getLocation();
        String mnemonicString = mnemonicLocation.getMnemonic();
        if (this.getSourceDataType().equals(this.getBaseDataType())) {
            return mnemonicString;
        }
        String name = this.baseDataType.getName();
        return mnemonicString + " (" + name + ")";
    }

    @Override
    protected String getDataTypeName() {
        return this.baseDataType.getName();
    }

    @Override
    protected DataType getSourceDataType() {
        Data data = this.getData(this.getLocation());
        return data.getDataType();
    }

    @Override
    protected DataType getBaseDataType() {
        Data data = this.getData(this.getLocation());
        if (data != null) {
            return ReferenceUtils.getBaseDataType(data.getDataType());
        }
        return null;
    }
}

