/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.FileArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.ProgramArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.ProjectArchiveNode;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataTypeManager;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Component;
import java.util.Iterator;
import javax.swing.tree.TreePath;

public class AlignAllDataTypesAction
extends DockingAction {
    private DataTypeManagerPlugin plugin;

    public AlignAllDataTypesAction(DataTypeManagerPlugin plugin) {
        super("Align All Data Types", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Align All..."}, "Edit"));
        this.setHelpLocation(new HelpLocation(plugin.getName(), this.getName()));
    }

    public boolean isEnabledForContext(ActionContext context) {
        Object contextObject = context.getContextObject();
        if (!(contextObject instanceof GTree)) {
            return false;
        }
        GTree gTree = (GTree)contextObject;
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length != 1) {
            return false;
        }
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        if (node instanceof ProgramArchiveNode || node instanceof ProjectArchiveNode || node instanceof FileArchiveNode) {
            ArchiveNode archiveNode = (ArchiveNode)node;
            return archiveNode.isEnabled();
        }
        return false;
    }

    public void actionPerformed(ActionContext context) {
        GTree gTree = (GTree)context.getContextObject();
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        if (node instanceof ProgramArchiveNode || node instanceof ProjectArchiveNode || node instanceof FileArchiveNode) {
            ArchiveNode archiveNode = (ArchiveNode)node;
            Archive archive = archiveNode.getArchive();
            if (archive.isModifiable()) {
                DataTypeManager dataTypeManager = archive.getDataTypeManager();
                DataOrganization dataOrganization = dataTypeManager.getDataOrganization();
                int result = OptionDialog.showOptionDialog((Component)this.plugin.getTool().getToolFrame(), (String)"Align Data Types", (String)("Are you sure you want to align all of the data types in " + dataTypeManager.getName() + "?\nBoth structures and unions that are currently unaligned will become aligned.\nDo you want to continue?"), (String)"Continue", (int)2);
                if (result == 0) {
                    return;
                }
                this.alignDataTypes(dataTypeManager, dataOrganization);
            } else {
                Msg.showWarn((Object)((Object)this), (Component)gTree, (String)"Alignment Not Allowed", (Object)"The archive must be modifiable to align data types.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alignDataTypes(DataTypeManager dataTypeManager, DataOrganization dataOrganization) {
        if (dataTypeManager == null) {
            Msg.error((Object)((Object)this), (Object)"Can't align data types without a data type manager.");
            return;
        }
        int transactionID = -1;
        boolean commit = false;
        try {
            transactionID = dataTypeManager.startTransaction("Align all data types in " + dataTypeManager.getName());
            this.alignEachStructure(dataTypeManager, dataOrganization);
            commit = true;
        }
        finally {
            dataTypeManager.endTransaction(transactionID, commit);
        }
    }

    private void alignEachStructure(DataTypeManager dataTypeManager, DataOrganization dataOrganization) {
        Iterator allComposites = dataTypeManager.getAllComposites();
        while (allComposites.hasNext()) {
            Composite composite = (Composite)allComposites.next();
            composite.setInternallyAligned(true);
        }
    }
}

