/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ComponentProvider;
import ghidra.app.plugin.core.compositeeditor.AddBitFieldAction;
import ghidra.app.plugin.core.compositeeditor.ApplyAction;
import ghidra.app.plugin.core.compositeeditor.ArrayAction;
import ghidra.app.plugin.core.compositeeditor.ClearAction;
import ghidra.app.plugin.core.compositeeditor.CompEditorPanel;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.app.plugin.core.compositeeditor.CreateInternalStructureAction;
import ghidra.app.plugin.core.compositeeditor.DeleteAction;
import ghidra.app.plugin.core.compositeeditor.DuplicateAction;
import ghidra.app.plugin.core.compositeeditor.DuplicateMultipleAction;
import ghidra.app.plugin.core.compositeeditor.EditBitFieldAction;
import ghidra.app.plugin.core.compositeeditor.EditComponentAction;
import ghidra.app.plugin.core.compositeeditor.EditFieldAction;
import ghidra.app.plugin.core.compositeeditor.FindReferencesToField;
import ghidra.app.plugin.core.compositeeditor.HexNumbersAction;
import ghidra.app.plugin.core.compositeeditor.InsertUndefinedAction;
import ghidra.app.plugin.core.compositeeditor.MoveDownAction;
import ghidra.app.plugin.core.compositeeditor.MoveUpAction;
import ghidra.app.plugin.core.compositeeditor.PointerAction;
import ghidra.app.plugin.core.compositeeditor.ShowComponentPathAction;
import ghidra.app.plugin.core.compositeeditor.StructureEditorModel;
import ghidra.app.plugin.core.compositeeditor.UnpackageAction;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.Structure;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class StructureEditorProvider
extends CompositeEditorProvider {
    protected static final ImageIcon STRUCTURE_EDITOR_ICON = ResourceManager.loadImage((String)"images/cstruct.png");

    public StructureEditorProvider(Plugin plugin, Structure structureDataType, boolean showHexNumbers) {
        super(plugin);
        this.setIcon(STRUCTURE_EDITOR_ICON);
        this.editorModel = new StructureEditorModel(this, showHexNumbers);
        this.editorModel.load((Composite)structureDataType);
        this.initializeActions();
        this.editorPanel = new CompEditorPanel((StructureEditorModel)this.editorModel, (CompositeEditorProvider)this);
        plugin.getTool().addComponentProvider((ComponentProvider)this, true);
        this.updateTitle();
        this.addActionsToTool();
        this.editorPanel.getTable().requestFocus();
        this.editorModel.selectionChanged();
    }

    @Override
    public String getName() {
        return "Structure Editor";
    }

    @Override
    protected CompositeEditorTableAction[] createActions() {
        return new CompositeEditorTableAction[]{new ApplyAction(this), new InsertUndefinedAction(this), new MoveUpAction(this), new MoveDownAction(this), new ClearAction(this), new DuplicateAction(this), new DuplicateMultipleAction(this), new DeleteAction(this), new PointerAction(this), new ArrayAction(this), new FindReferencesToField(this), new UnpackageAction(this), new EditComponentAction(this), new EditFieldAction(this), new HexNumbersAction(this), new CreateInternalStructureAction(this), new ShowComponentPathAction(this), new AddBitFieldAction(this), new EditBitFieldAction(this)};
    }

    @Override
    public String getHelpName() {
        return "Structure_Editor";
    }

    @Override
    public String getHelpTopic() {
        return "DataTypeEditors";
    }
}

