/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.transform.MutableAffineTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import edu.uci.ics.jung.visualization.transform.shape.ShapeTransformer;
import edu.uci.ics.jung.visualization.util.ChangeEventSupport;
import edu.uci.ics.jung.visualization.util.DefaultChangeEventSupport;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BasicTransformer
implements MultiLayerTransformer,
ShapeTransformer,
ChangeListener,
ChangeEventSupport {
    protected ChangeEventSupport changeSupport = new DefaultChangeEventSupport(this);
    protected MutableTransformer viewTransformer = new MutableAffineTransformer(new AffineTransform());
    protected MutableTransformer layoutTransformer = new MutableAffineTransformer(new AffineTransform());

    public BasicTransformer() {
        this.viewTransformer.addChangeListener(this);
        this.layoutTransformer.addChangeListener(this);
    }

    protected void setViewTransformer(MutableTransformer Function) {
        this.viewTransformer.removeChangeListener(this);
        this.viewTransformer = Function;
        this.viewTransformer.addChangeListener(this);
    }

    protected void setLayoutTransformer(MutableTransformer Function) {
        this.layoutTransformer.removeChangeListener(this);
        this.layoutTransformer = Function;
        this.layoutTransformer.addChangeListener(this);
    }

    protected MutableTransformer getLayoutTransformer() {
        return this.layoutTransformer;
    }

    protected MutableTransformer getViewTransformer() {
        return this.viewTransformer;
    }

    @Override
    public Point2D inverseTransform(Point2D p) {
        return this.inverseLayoutTransform(this.inverseViewTransform(p));
    }

    protected Point2D inverseViewTransform(Point2D p) {
        return this.viewTransformer.inverseTransform(p);
    }

    protected Point2D inverseLayoutTransform(Point2D p) {
        return this.layoutTransformer.inverseTransform(p);
    }

    @Override
    public Point2D transform(Point2D p) {
        return this.viewTransform(this.layoutTransform(p));
    }

    protected Point2D viewTransform(Point2D p) {
        return this.viewTransformer.transform(p);
    }

    protected Point2D layoutTransform(Point2D p) {
        return this.layoutTransformer.transform(p);
    }

    @Override
    public Shape inverseTransform(Shape shape) {
        return this.inverseLayoutTransform(this.inverseViewTransform(shape));
    }

    protected Shape inverseViewTransform(Shape shape) {
        return this.viewTransformer.inverseTransform(shape);
    }

    protected Shape inverseLayoutTransform(Shape shape) {
        return this.layoutTransformer.inverseTransform(shape);
    }

    @Override
    public Shape transform(Shape shape) {
        return this.viewTransform(this.layoutTransform(shape));
    }

    protected Shape viewTransform(Shape shape) {
        return this.viewTransformer.transform(shape);
    }

    protected Shape layoutTransform(Shape shape) {
        return this.layoutTransformer.transform(shape);
    }

    @Override
    public void setToIdentity() {
        this.layoutTransformer.setToIdentity();
        this.viewTransformer.setToIdentity();
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    @Override
    public ChangeListener[] getChangeListeners() {
        return this.changeSupport.getChangeListeners();
    }

    @Override
    public void fireStateChanged() {
        this.changeSupport.fireStateChanged();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireStateChanged();
    }

    @Override
    public MutableTransformer getTransformer(Layer layer) {
        if (layer == Layer.LAYOUT) {
            return this.layoutTransformer;
        }
        if (layer == Layer.VIEW) {
            return this.viewTransformer;
        }
        return null;
    }

    @Override
    public Point2D inverseTransform(Layer layer, Point2D p) {
        if (layer == Layer.LAYOUT) {
            return this.inverseLayoutTransform(p);
        }
        if (layer == Layer.VIEW) {
            return this.inverseViewTransform(p);
        }
        return null;
    }

    @Override
    public void setTransformer(Layer layer, MutableTransformer Function) {
        if (layer == Layer.LAYOUT) {
            this.setLayoutTransformer(Function);
        }
        if (layer == Layer.VIEW) {
            this.setViewTransformer(Function);
        }
    }

    @Override
    public Point2D transform(Layer layer, Point2D p) {
        if (layer == Layer.LAYOUT) {
            return this.layoutTransform(p);
        }
        if (layer == Layer.VIEW) {
            return this.viewTransform(p);
        }
        return null;
    }

    @Override
    public Shape transform(Layer layer, Shape shape) {
        if (layer == Layer.LAYOUT) {
            return this.layoutTransform(shape);
        }
        if (layer == Layer.VIEW) {
            return this.viewTransform(shape);
        }
        return null;
    }

    @Override
    public Shape inverseTransform(Layer layer, Shape shape) {
        if (layer == Layer.LAYOUT) {
            return this.inverseLayoutTransform(shape);
        }
        if (layer == Layer.VIEW) {
            return this.inverseViewTransform(shape);
        }
        return null;
    }
}

