/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfsplus;

import java.io.PrintStream;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.types.hfsplus.BTLeafNode;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusExtentLeafRecord;

public class HFSPlusExtentLeafNode
extends BTLeafNode {
    protected HFSPlusExtentLeafRecord[] leafRecords;
    protected short[] leafRecordOffsets;

    public HFSPlusExtentLeafNode(byte[] data, int offset, int nodeSize) {
        super(data, offset, nodeSize);
        int i;
        this.leafRecordOffsets = new short[Util.unsign((short)this.nodeDescriptor.getNumRecords()) + 1];
        for (i = 0; i < this.leafRecordOffsets.length; ++i) {
            this.leafRecordOffsets[i] = Util.readShortBE((byte[])data, (int)(offset + nodeSize - (i + 1) * 2));
        }
        this.leafRecords = new HFSPlusExtentLeafRecord[this.leafRecordOffsets.length - 1];
        for (i = 0; i < this.leafRecords.length; ++i) {
            int currentOffset = Util.unsign((short)this.leafRecordOffsets[i]);
            this.leafRecords[i] = new HFSPlusExtentLeafRecord(data, offset + currentOffset);
        }
    }

    public short[] getLeafRecordOffsets() {
        short[] offsets = new short[this.leafRecordOffsets.length];
        for (int i = 0; i < offsets.length; ++i) {
            offsets[i] = this.leafRecordOffsets[i];
        }
        return offsets;
    }

    public HFSPlusExtentLeafRecord getLeafRecord(int index) {
        return this.leafRecords[index];
    }

    public HFSPlusExtentLeafRecord[] getLeafRecords() {
        HFSPlusExtentLeafRecord[] copy = new HFSPlusExtentLeafRecord[this.leafRecords.length];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = this.leafRecords[i];
        }
        return copy;
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " nodeDescriptor:");
        this.nodeDescriptor.printFields(ps, prefix + "  ");
        for (int i = 0; i < this.leafRecords.length; ++i) {
            ps.println(prefix + " leafRecords[" + i + "]:");
            this.leafRecords[i].printFields(ps, prefix + "  ");
        }
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "HFSPlusExtentLeafNode:");
        this.printFields(ps, prefix);
    }
}

