/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.img2;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.ios.img2.Img2;
import ghidra.file.formats.ios.img2.Img2Constants;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@FileSystemInfo(type="img2", description="iOS Img2", factory=GFileSystemBaseFactory.class)
public class Img2FileSystem
extends GFileSystemBase {
    private Img2 img2;
    private GFileImpl imageTypeFile;

    public Img2FileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public void close() throws IOException {
        super.close();
        this.imageTypeFile = null;
    }

    protected InputStream getData(GFile file, TaskMonitor monitor) throws IOException, CancelledException, CryptoException {
        if (file != null && file.equals(this.imageTypeFile)) {
            byte[] data = this.provider.readBytes(1024L, (long)this.img2.getDataLen());
            return new ByteArrayInputStream(data);
        }
        return null;
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return directory == null || directory.equals(this.root) ? Arrays.asList(this.imageTypeFile) : Collections.emptyList();
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        byte[] bytes = this.provider.readBytes(0L, (long)Img2Constants.IMG2_SIGNATURE_BYTES.length);
        return Arrays.equals(bytes, Img2Constants.IMG2_SIGNATURE_BYTES);
    }

    public void open(TaskMonitor monitor) throws IOException, CryptoException, CancelledException {
        monitor.setMessage("Opening IMG2...");
        this.img2 = new Img2(this.provider);
        if (!this.img2.getSignature().equals("Img2")) {
            throw new IOException("Unable to decrypt file: invalid IMG2 file!");
        }
        this.imageTypeFile = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)this.img2.getImageType(), (boolean)false, (long)this.img2.getDataLen(), null);
    }
}

