/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Format.Instruction52c;
import org.jf.dexlib.Code.Format.InstructionWithJumboVariant;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionWithReference;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction22c
extends InstructionWithReference
implements TwoRegisterInstruction,
InstructionWithJumboVariant {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regA;
    private byte regB;

    public Instruction22c(Opcode opcode, byte regA, byte regB, Item referencedItem) {
        super(opcode, referencedItem);
        if (regA >= 16 || regB >= 16) {
            throw new RuntimeException("The register number must be less than v16");
        }
        this.regA = regA;
        this.regB = regB;
    }

    private Instruction22c(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
        super(dexFile, opcode, buffer, bufferIndex);
        this.regA = NumberUtils.decodeLowUnsignedNibble(buffer[bufferIndex + 1]);
        this.regB = NumberUtils.decodeHighUnsignedNibble(buffer[bufferIndex + 1]);
    }

    @Override
    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        if (this.getReferencedItem().getIndex() > 65535) {
            if (this.opcode.hasJumboOpcode()) {
                throw new RuntimeException(String.format("%s index is too large. Use the %s instruction instead.", this.opcode.referenceType.name(), this.opcode.getJumboOpcode().name));
            }
            throw new RuntimeException(String.format("%s index is too large.", this.opcode.referenceType.name()));
        }
        out.writeByte(this.opcode.value);
        out.writeByte(this.regB << 4 | this.regA);
        out.writeShort(this.getReferencedItem().getIndex());
    }

    @Override
    public Format getFormat() {
        return Format.Format22c;
    }

    @Override
    public int getRegisterA() {
        return this.regA;
    }

    @Override
    public int getRegisterB() {
        return this.regB;
    }

    @Override
    public Instruction makeJumbo() {
        Opcode jumboOpcode = this.opcode.getJumboOpcode();
        if (jumboOpcode == null) {
            return null;
        }
        return new Instruction52c(jumboOpcode, this.getRegisterA(), this.getRegisterB(), this.getReferencedItem());
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction22c(dexFile, opcode, buffer, bufferIndex);
        }
    }
}

