/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.support;

import docking.widgets.tree.AbstractGTreeNode;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.DirectoryNode;
import docking.widgets.tree.support.FileData;
import java.io.File;
import javax.swing.Icon;

class FileNode
extends AbstractGTreeNode
implements FileData {
    protected File file;
    public String tempName;

    FileNode(File file) {
        this.file = file;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public Icon getIcon(boolean expanded) {
        return null;
    }

    @Override
    public String getName() {
        if (this.tempName != null) {
            return this.tempName;
        }
        String name = this.file.getName();
        if (name.length() > 0) {
            return name;
        }
        return this.file.getName();
    }

    @Override
    public String getToolTip() {
        return this.file.getAbsolutePath();
    }

    @Override
    public int compareTo(GTreeNode o) {
        if (o instanceof DirectoryNode) {
            return 1;
        }
        return this.getName().compareTo(o.getName());
    }

    @Override
    public String toString() {
        return this.file.getAbsolutePath();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileNode) {
            return this.file.equals(((FileNode)obj).file);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.file.getAbsolutePath().hashCode();
    }

    @Override
    public boolean isLeaf() {
        return true;
    }
}

