/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.DialogComponentProvider;
import docking.ExecutableKeyActionAdapter;
import docking.action.DockingActionIf;
import docking.widgets.label.GIconLabel;
import docking.widgets.label.GLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class ActionDialog
extends DialogComponentProvider {
    private String keystrokeName;
    private List<ExecutableKeyActionAdapter> list;
    private JList<String> actionList;
    private DefaultListModel<String> listModel;

    public ActionDialog(String keystrokeName, List<ExecutableKeyActionAdapter> list) {
        super("Select Action", true);
        this.keystrokeName = keystrokeName;
        this.init();
        this.setActionList(list);
    }

    @Override
    protected void okCallback() {
        int index = this.actionList.getSelectedIndex();
        if (index < 0) {
            return;
        }
        this.close();
        ExecutableKeyActionAdapter actionProxy = this.list.get(index);
        actionProxy.execute();
    }

    public void setActionList(List<ExecutableKeyActionAdapter> list) {
        this.okButton.setEnabled(false);
        this.list = list;
        this.listModel.clear();
        for (int i = 0; i < list.size(); ++i) {
            ExecutableKeyActionAdapter actionProxy = list.get(i);
            DockingActionIf action = actionProxy.getAction();
            this.listModel.addElement(action.getName() + " (" + action.getOwnerDescription() + ")");
        }
        this.actionList.setSelectedIndex(0);
    }

    private void init() {
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
        this.addListeners();
    }

    private JPanel buildMainPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel innerPanel = new JPanel(new BorderLayout());
        JPanel labelPanel = new JPanel(new GridLayout(0, 1));
        labelPanel.add(new GLabel("Multiple actions have been mapped to " + this.keystrokeName));
        labelPanel.add(new GLabel("Actions that can be enabled at the same"));
        labelPanel.add(new GLabel("time should be mapped to different keys"));
        innerPanel.setBorder(BorderFactory.createTitledBorder("Actions"));
        JPanel panel = new JPanel(new FlowLayout(0));
        Icon icon = UIManager.getIcon("OptionPane.warningIcon");
        panel.add(new GIconLabel(icon));
        panel.add(labelPanel);
        this.listModel = new DefaultListModel();
        this.actionList = new JList<String>(this.listModel);
        this.actionList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    evt.consume();
                    ActionDialog.this.okCallback();
                } else if (evt.getKeyCode() == 27) {
                    evt.consume();
                    ActionDialog.this.close();
                }
            }
        });
        this.actionList.setSelectionMode(0);
        this.actionList.setVisibleRowCount(5);
        JScrollPane listScrollPane = new JScrollPane(this.actionList);
        innerPanel.add((Component)listScrollPane, "Center");
        mainPanel.add((Component)panel, "North");
        mainPanel.add((Component)innerPanel, "Center");
        return mainPanel;
    }

    private void addListeners() {
        this.actionList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getModifiersEx() != 1024) {
                    return;
                }
                int clickCount = e.getClickCount();
                if (clickCount == 2) {
                    ActionDialog.this.okCallback();
                }
            }
        });
        this.actionList.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.okButton.setEnabled(!this.actionList.isSelectionEmpty());
        });
    }
}

