/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;

public class MipsSymbolAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "MIPS Symbol";
    private static final String DESCRIPTION = "Analyze bytes for Mips16 symbols and shift -1 as necessary.";

    public MipsSymbolAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setPriority(AnalysisPriority.FORMAT_ANALYSIS.before().before().before().before());
        this.setDefaultEnablement(true);
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) {
        monitor.setMessage("Mips16 symbol analyzer");
        Register IsaModeRegister = program.getRegister("ISA_MODE");
        Memory memory = program.getMemory();
        Listing listing = program.getListing();
        FunctionManager functionManager = program.getFunctionManager();
        AddressSet redo = new AddressSet();
        SymbolTable symbolTable = program.getSymbolTable();
        SymbolIterator allSymbolsIter = symbolTable.getAllSymbols(true);
        while (allSymbolsIter.hasNext() && !monitor.isCancelled()) {
            boolean isFunc;
            MemoryBlock block;
            Symbol symbol = allSymbolsIter.next();
            Address memAddr = symbol.getAddress();
            SourceType source = symbol.getSource();
            if (source != SourceType.IMPORTED || !memAddr.isMemoryAddress() || (block = memory.getBlock(memAddr)) == null || !block.isExecute() || (memAddr.getOffset() & 1L) != 1L) continue;
            Address newAddr = memAddr.subtract(1L);
            String name = symbol.getName();
            symbolTable.removeSymbolSpecial(symbol);
            Function func = functionManager.getFunctionAt(memAddr);
            boolean bl = isFunc = func != null;
            if (isFunc) {
                functionManager.removeFunction(memAddr);
                functionManager.removeFunction(newAddr);
            }
            try {
                symbol = symbolTable.createLabel(newAddr, name, source);
                if (isFunc) {
                    symbol.setPrimary();
                    AddressSet body = new AddressSet(newAddr);
                    try {
                        functionManager.createFunction(null, newAddr, (AddressSetView)body, source);
                    }
                    catch (OverlappingFunctionException overlappingFunctionException) {}
                }
            }
            catch (InvalidInputException body) {
                // empty catch block
            }
            if (symbolTable.isExternalEntryPoint(memAddr)) {
                symbolTable.removeExternalEntryPoint(memAddr);
                symbolTable.addExternalEntryPoint(newAddr);
            }
            if (listing.getUndefinedDataAt(newAddr) == null) continue;
            try {
                program.getProgramContext().setValue(IsaModeRegister, newAddr, newAddr, new BigInteger("1"));
                redo.add(newAddr);
            }
            catch (ContextChangeException e) {
                Msg.error((Object)((Object)this), (Object)"Unexpected Error", (Throwable)e);
            }
        }
        if (!redo.isEmpty()) {
            AutoAnalysisManager.getAnalysisManager((Program)program).reAnalyzeAll((AddressSetView)redo);
        }
        return true;
    }

    public void analysisEnded(Program program) {
    }

    public boolean canAnalyze(Program program) {
        return program.getLanguage().getProcessor().equals((Object)Processor.findOrPossiblyCreateProcessor((String)"MIPS")) && program.getRegister("ISA_MODE") != null;
    }

    public boolean getDefaultEnablement(Program program) {
        return true;
    }
}

