/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import generic.cache.BasicFactory;
import generic.cache.CachingPool;
import generic.cache.CountingBasicFactory;
import generic.concurrent.ConcurrentGraphQ;
import generic.concurrent.GThreadPool;
import generic.concurrent.QRunnable;
import ghidra.app.cmd.function.DecompilerParallelConventionAnalysisCmd;
import ghidra.app.decompiler.DecompInterface;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.util.AcyclicCallGraphBuilder;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.graph.AbstractDependencyGraph;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class DecompilerCallConventionAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Call Convention Identification";
    private static final String DESCRIPTION = "Uses decompiler to figure out unknown calling conventions.";
    private static final String STD_NAMESPACE = "std";
    private static final String COULD_NOT_RECOVER_CALLING_CONVENTION = "Could not recover calling convention";
    private static final String OPTION_NAME_DECOMPILER_TIMEOUT_SECS = "Analysis Decompiler Timeout (sec)";
    private static final String OPTION_DESCRIPTION_DECOMPILER_TIMEOUT_SECS = "Set timeout in seconds for analyzer decompiler calls.";
    public static final int OPTION_DEFAULT_DECOMPILER_TIMEOUT_SECS = 60;
    private int decompilerTimeoutSecondsOption = 60;
    private boolean ignoreBookmarks = false;
    private Program program;

    public DecompilerCallConventionAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.FUNCTION_SIGNATURES_ANALYZER);
        this.setPriority(AnalysisPriority.FUNCTION_ID_ANALYSIS.after().after().after());
        this.setDefaultEnablement(true);
        this.setSupportsOneTimeAnalysis();
    }

    public boolean canAnalyze(Program program) {
        boolean cando = program.getLanguage().supportsPcode();
        return cando &= program.getCompilerSpec().getCallingConventions().length > 1;
    }

    public void registerOptions(Options options, Program program) {
        options.registerOption(OPTION_NAME_DECOMPILER_TIMEOUT_SECS, (Object)this.decompilerTimeoutSecondsOption, null, OPTION_DESCRIPTION_DECOMPILER_TIMEOUT_SECS);
        this.optionsChanged(options, program);
    }

    public void optionsChanged(Options options, Program program) {
        this.decompilerTimeoutSecondsOption = options.getInt(OPTION_NAME_DECOMPILER_TIMEOUT_SECS, this.decompilerTimeoutSecondsOption);
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        this.program = program;
        this.ignoreBookmarks = set.hasSameAddresses((AddressSetView)program.getMemory());
        try {
            AddressSetView functionEntries = this.findLocations(program, set, monitor);
            if (functionEntries.isEmpty()) {
                return true;
            }
            this.runDecompilerAnalysis(program, functionEntries, monitor);
        }
        catch (CancelledException ce) {
            throw ce;
        }
        catch (InterruptedException ie) {
            if (!monitor.isCancelled()) {
                Msg.error((Object)((Object)this), (Object)"Unexpectedly interrupted while analyzing", (Throwable)ie);
            }
        }
        catch (Exception e) {
            Msg.error((Object)((Object)this), (Object)"Unexpected exception", (Throwable)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDecompilerAnalysis(Program program, AddressSetView functionEntries, TaskMonitor monitor) throws InterruptedException, Exception {
        CachingPool decompilerPool = new CachingPool((BasicFactory)new DecompilerFactory(program));
        ParallelDecompilerCallback callback = new ParallelDecompilerCallback((CachingPool<DecompInterface>)decompilerPool);
        ConcurrentGraphQ queue = null;
        monitor.initialize(functionEntries.getNumAddresses());
        try {
            monitor.setMessage("Analyzing Call Hierarchy...");
            AcyclicCallGraphBuilder builder = new AcyclicCallGraphBuilder(program, functionEntries, true);
            AbstractDependencyGraph graph = builder.getDependencyGraph(monitor);
            if (graph.isEmpty()) {
                return;
            }
            GThreadPool pool = AutoAnalysisManager.getSharedAnalsysThreadPool();
            queue = new ConcurrentGraphQ((QRunnable)callback, graph, pool, monitor);
            monitor.setMessage("Analyzing Call Conventions...");
            queue.execute();
        }
        finally {
            if (queue != null) {
                queue.dispose();
            }
            decompilerPool.dispose();
        }
    }

    private void performConventionAnalysis(Function function, DecompInterface decompiler, TaskMonitor monitor) {
        DecompilerParallelConventionAnalysisCmd cmd = new DecompilerParallelConventionAnalysisCmd(function, decompiler, this.decompilerTimeoutSecondsOption);
        boolean applyTo = cmd.applyTo((DomainObject)function.getProgram(), monitor);
        if (!applyTo) {
            BookmarkManager bkMgr = function.getProgram().getBookmarkManager();
            bkMgr.setBookmark(function.getEntryPoint(), "Warning", COULD_NOT_RECOVER_CALLING_CONVENTION, cmd.getStatusMsg());
        }
    }

    private AddressSetView findLocations(Program program, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        AddressSet functionEntries = new AddressSet();
        FunctionIterator functions = program.getFunctionManager().getFunctions(set, true);
        BookmarkManager bkMgr = program.getBookmarkManager();
        for (Function function : functions) {
            String callingConventionName;
            Bookmark bookmark;
            monitor.checkCanceled();
            if (!this.ignoreBookmarks && (bookmark = bkMgr.getBookmark(function.getEntryPoint(), "Warning", COULD_NOT_RECOVER_CALLING_CONVENTION)) != null || function.isThunk() || function.isInline() || function.isExternal() || function.getCallFixup() != null || !(callingConventionName = function.getCallingConventionName()).equals("unknown") || function.hasCustomVariableStorage() || !this.hasImportedSignatureWithinNamespace(function) && !this.hasDefinedParameterTypes(function)) continue;
            functionEntries.add(function.getEntryPoint());
        }
        return functionEntries;
    }

    private boolean hasImportedSignatureWithinNamespace(Function function) {
        return function.getSignatureSource() == SourceType.IMPORTED && function.getParentNamespace().getID() != 0L;
    }

    private boolean hasDefinedParameterTypes(Function function) {
        ParameterDefinition[] arguments;
        for (ParameterDefinition parameterDefinition : arguments = function.getSignature().getArguments()) {
            DataType dataType = parameterDefinition.getDataType();
            if (dataType == DefaultDataType.dataType || Undefined.isUndefined((DataType)dataType)) continue;
            return true;
        }
        return false;
    }

    private class ParallelDecompilerCallback
    implements QRunnable<Address> {
        private CachingPool<DecompInterface> pool;

        ParallelDecompilerCallback(CachingPool<DecompInterface> decompilerPool) {
            this.pool = decompilerPool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Address address, TaskMonitor monitor) throws Exception {
            if (monitor.isCancelled()) {
                return;
            }
            DecompInterface decompiler = (DecompInterface)this.pool.get();
            try {
                Function function = DecompilerCallConventionAnalyzer.this.program.getFunctionManager().getFunctionAt(address);
                DecompilerCallConventionAnalyzer.this.performConventionAnalysis(function, decompiler, monitor);
            }
            finally {
                this.pool.release((Object)decompiler);
            }
        }
    }

    private class DecompilerFactory
    extends CountingBasicFactory<DecompInterface> {
        private Program program;

        DecompilerFactory(Program program) {
            this.program = program;
        }

        public DecompInterface doCreate(int itemNumber) throws IOException {
            return DecompilerParallelConventionAnalysisCmd.createDecompilerInterface(this.program);
        }

        public void doDispose(DecompInterface decompiler) {
            decompiler.dispose();
        }
    }
}

