/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff.relocation;

import ghidra.app.util.bin.format.coff.CoffFileHeader;
import ghidra.app.util.bin.format.coff.CoffRelocation;
import ghidra.app.util.bin.format.coff.relocation.CoffRelocationHandler;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.exception.NotFoundException;

public class X86_64_CoffRelocationHandler
extends CoffRelocationHandler {
    public static final short IMAGE_REL_AMD64_ABSOLUTE = 0;
    public static final short IMAGE_REL_AMD64_ADDR64 = 1;
    public static final short IMAGE_REL_AMD64_ADDR32 = 2;
    public static final short IMAGE_REL_AMD64_ADDR32NB = 3;
    public static final short IMAGE_REL_AMD64_REL32 = 4;
    public static final short IMAGE_REL_AMD64_REL32_1 = 5;
    public static final short IMAGE_REL_AMD64_REL32_2 = 6;
    public static final short IMAGE_REL_AMD64_REL32_3 = 7;
    public static final short IMAGE_REL_AMD64_REL32_4 = 8;
    public static final short IMAGE_REL_AMD64_REL32_5 = 9;
    public static final short IMAGE_REL_AMD64_SECTION = 10;
    public static final short IMAGE_REL_AMD64_SECREL = 11;
    public static final short IMAGE_REL_AMD64_SECREL7 = 12;
    public static final short IMAGE_REL_AMD64_TOKEN = 13;
    public static final short IMAGE_REL_AMD64_SREL32 = 14;
    public static final short IMAGE_REL_AMD64_PAIR = 15;
    public static final short IMAGE_REL_AMD64_SSPAN32 = 16;

    public boolean canRelocate(CoffFileHeader fileHeader) {
        return fileHeader.getMachine() == -31132;
    }

    public void relocate(Program program, Address address, Symbol symbol, CoffRelocation relocation) throws MemoryAccessException, NotFoundException {
        int distance = 0;
        long addend = program.getMemory().getInt(address);
        switch (relocation.getType()) {
            case 1: {
                addend = program.getMemory().getLong(address);
                program.getMemory().setLong(address, symbol.getAddress().add(addend).getOffset());
                break;
            }
            case 2: {
                program.getMemory().setInt(address, (int)symbol.getAddress().add(addend).getOffset());
                break;
            }
            case 3: {
                program.getMemory().setInt(address, (int)symbol.getAddress().add(addend).subtract(program.getImageBase()));
                break;
            }
            case 9: {
                ++distance;
            }
            case 8: {
                ++distance;
            }
            case 7: {
                ++distance;
            }
            case 6: {
                ++distance;
            }
            case 5: {
                ++distance;
            }
            case 4: {
                program.getMemory().setInt(address, (int)symbol.getAddress().add(addend).subtract(address) - 4 - distance);
                break;
            }
            case 0: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            default: {
                throw new NotFoundException();
            }
        }
    }
}

