import{SDKModel as t,TracingManager as e,TracingModel as i}from"../sdk/sdk.js";import{FileUtils as s,TempFile as a}from"../bindings/bindings.js";import{i18n as n}from"../i18n/i18n.js";import{DateUtilities as o}from"../platform/platform.js";import{InspectorBackend as l}from"../protocol_client/protocol_client.js";import{TimelineLoader as r}from"../timeline/timeline.js";import{Widget as c,ActionRegistry as h,Toolbar as p,UIUtils as d,ViewManager as _}from"../ui/ui.js";class u extends t.SDKModel{constructor(t){super(t),this._inputAgent=t.inputAgent(),this._eventDispatchTimer=0,this._dispatchEventDataList=[],this._finishCallback=null,this._reset()}_reset(){this._lastEventTime=null,this._replayPaused=!1,this._dispatchingIndex=0,window.clearTimeout(this._eventDispatchTimer)}setEvents(t){this._dispatchEventDataList=[];for(const e of t.sortedProcesses())for(const i of e.sortedThreads())this._processThreadEvents(t,i);this._dispatchEventDataList.sort((function(t,e){return t.timestamp-e.timestamp}))}startReplay(t){this._reset(),this._finishCallback=t,this._dispatchEventDataList.length?this._dispatchNextEvent():this._replayStopped()}pause(){window.clearTimeout(this._eventDispatchTimer),this._dispatchingIndex>=this._dispatchEventDataList.length?this._replayStopped():this._replayPaused=!0}resume(){this._replayPaused=!1,this._dispatchingIndex<this._dispatchEventDataList.length&&this._dispatchNextEvent()}_processThreadEvents(t,e){for(const t of e.events())"EventDispatch"===t.name&&this._isValidInputEvent(t.args.data)&&this._dispatchEventDataList.push(t.args.data)}_isValidInputEvent(t){return this._isMouseEvent(t)||this._isKeyboardEvent(t)}_isMouseEvent(t){return!!g.has(t.type)&&("x"in t&&"y"in t)}_isKeyboardEvent(t){return!!m.has(t.type)&&("code"in t&&"key"in t)}_dispatchNextEvent(){const t=this._dispatchEventDataList[this._dispatchingIndex];if(this._lastEventTime=t.timestamp,g.has(t.type)?this._dispatchMouseEvent(t):m.has(t.type)&&this._dispatchKeyEvent(t),++this._dispatchingIndex,this._dispatchingIndex<this._dispatchEventDataList.length){const t=(this._dispatchEventDataList[this._dispatchingIndex].timestamp-this._lastEventTime)/1e3;this._eventDispatchTimer=window.setTimeout(this._dispatchNextEvent.bind(this),t)}else this._replayStopped()}async _dispatchMouseEvent(t){const e=g.get(t.type);if(!e)throw new Error("Could not find mouse event type for eventData "+t.type);const i=v.get(t.button),s={type:e,x:t.x,y:t.y,modifiers:t.modifiers,button:"mousedown"===t.type||"mouseup"===t.type?i:Protocol.Input.MouseButton.None,buttons:t.buttons,clickCount:t.clickCount,deltaX:t.deltaX,deltaY:t.deltaY};await this._inputAgent.invoke_dispatchMouseEvent(s)}async _dispatchKeyEvent(t){const e=m.get(t.type);if(!e)throw new Error("Could not find key event type for eventData "+t.type);const i="keypress"===t.type?t.key[0]:void 0,s={type:e,modifiers:t.modifiers,text:i,unmodifiedText:i?i.toLowerCase():void 0,code:t.code,key:t.key};await this._inputAgent.invoke_dispatchKeyEvent(s)}_replayStopped(){window.clearTimeout(this._eventDispatchTimer),this._reset(),this._finishCallback&&this._finishCallback()}}const g=new Map([["mousedown",Protocol.Input.DispatchMouseEventRequestType.MousePressed],["mouseup",Protocol.Input.DispatchMouseEventRequestType.MouseReleased],["mousemove",Protocol.Input.DispatchMouseEventRequestType.MouseMoved],["wheel",Protocol.Input.DispatchMouseEventRequestType.MouseWheel]]),m=new Map([["keydown",Protocol.Input.DispatchKeyEventRequestType.KeyDown],["keyup",Protocol.Input.DispatchKeyEventRequestType.KeyUp],["keypress",Protocol.Input.DispatchKeyEventRequestType.Char]]),v=new Map([[0,Protocol.Input.MouseButton.Left],[1,Protocol.Input.MouseButton.Middle],[2,Protocol.Input.MouseButton.Right],[3,Protocol.Input.MouseButton.Back],[4,Protocol.Input.MouseButton.Forward]]);t.SDKModel.register(u,t.Capability.Input,!1);var y=Object.freeze({__proto__:null,InputModel:u});const T={clearAll:"Clear all",loadProfile:"Load profile…",saveProfile:"Save profile…"},b=n.registerUIStrings("input/InputTimeline.ts",T),E=n.getLocalizedString.bind(void 0,b);let w,M;class f extends c.VBox{constructor(){super(!0),this.registerRequiredCSS("input/inputTimeline.css",{enableLegacyPatching:!1}),this.element.classList.add("inputs-timeline"),this._tracingClient=null,this._tracingModel=null,this._inputModel=null,this._state="Idle",this._toggleRecordAction=h.ActionRegistry.instance().action("input.toggle-recording"),this._startReplayAction=h.ActionRegistry.instance().action("input.start-replaying"),this._togglePauseAction=h.ActionRegistry.instance().action("input.toggle-pause");const t=this.contentElement.createChild("div","input-timeline-toolbar-container");this._panelToolbar=new p.Toolbar("input-timeline-toolbar",t),this._panelToolbar.appendToolbarItem(p.Toolbar.createActionButton(this._toggleRecordAction)),this._panelToolbar.appendToolbarItem(p.Toolbar.createActionButton(this._startReplayAction)),this._panelToolbar.appendToolbarItem(p.Toolbar.createActionButton(this._togglePauseAction)),this._clearButton=new p.ToolbarButton(E(T.clearAll),"largeicon-clear"),this._clearButton.addEventListener(p.ToolbarButton.Events.Click,this._reset.bind(this)),this._panelToolbar.appendToolbarItem(this._clearButton),this._panelToolbar.appendSeparator(),this._loadButton=new p.ToolbarButton(E(T.loadProfile),"largeicon-load"),this._loadButton.addEventListener(p.ToolbarButton.Events.Click,(()=>this._selectFileToLoad())),this._saveButton=new p.ToolbarButton(E(T.saveProfile),"largeicon-download"),this._saveButton.addEventListener(p.ToolbarButton.Events.Click,(t=>{this._saveToFile()})),this._panelToolbar.appendSeparator(),this._panelToolbar.appendToolbarItem(this._loadButton),this._panelToolbar.appendToolbarItem(this._saveButton),this._panelToolbar.appendSeparator(),this._createFileSelector(),this._updateControls()}static instance(t={forceNew:!1}){const{forceNew:e}=t;return w&&!e||(w=new f),w}_reset(){this._tracingClient=null,this._tracingModel=null,this._inputModel=null,this._setState("Idle")}_createFileSelector(){this._fileSelectorElement&&this._fileSelectorElement.remove(),this._fileSelectorElement=d.createFileSelectorElement(this._loadFromFile.bind(this)),this.element.appendChild(this._fileSelectorElement)}wasShown(){}willHide(){}_setState(t){this._state=t,this._updateControls()}_isAvailableState(){return"Idle"===this._state||"ReplayPaused"===this._state}_updateControls(){this._toggleRecordAction.setToggled("Recording"===this._state),this._toggleRecordAction.setEnabled(this._isAvailableState()||"Recording"===this._state),this._startReplayAction.setEnabled(this._isAvailableState()&&Boolean(this._tracingModel)),this._togglePauseAction.setEnabled("Replaying"===this._state||"ReplayPaused"===this._state),this._togglePauseAction.setToggled("ReplayPaused"===this._state),this._clearButton.setEnabled(this._isAvailableState()),this._loadButton.setEnabled(this._isAvailableState()),this._saveButton.setEnabled(this._isAvailableState()&&Boolean(this._tracingModel))}_toggleRecording(){switch(this._state){case"Recording":this._stopRecording();break;case"Idle":this._startRecording()}}_startReplay(){this._replayEvents()}_toggleReplayPause(){switch(this._state){case"Replaying":this._pauseReplay();break;case"ReplayPaused":this._resumeReplay()}}async _saveToFile(){if(console.assert("Idle"===this._state),!this._tracingModel)return;const t=`InputProfile-${o.toISO8601Compact(new Date)}.json`,e=new s.FileOutputStream;if(!await e.open(t))return;const i=this._tracingModel.backingStorage();await i.writeToStream(e),e.close()}_selectFileToLoad(){this._fileSelectorElement&&this._fileSelectorElement.click()}_loadFromFile(t){console.assert(this._isAvailableState()),this._setState("Loading"),this._loader=r.TimelineLoader.loadFromFile(t,this),this._createFileSelector()}async _startRecording(){this._setState("StartPending"),this._tracingClient=new R(t.TargetManager.instance().mainTarget(),this);(await this._tracingClient.startRecording())[l.ProtocolError]?this._recordingFailed():this._setState("Recording")}async _stopRecording(){this._tracingClient&&(this._setState("StopPending"),await this._tracingClient.stopRecording(),this._tracingClient=null)}async _replayEvents(){this._inputModel&&(this._setState("Replaying"),await this._inputModel.startReplay(this.replayStopped.bind(this)))}_pauseReplay(){this._inputModel&&(this._inputModel.pause(),this._setState("ReplayPaused"))}_resumeReplay(){this._inputModel&&(this._inputModel.resume(),this._setState("Replaying"))}loadingStarted(){}loadingProgress(t){}processingStarted(){}loadingComplete(e){e?(this._inputModel=new u(t.TargetManager.instance().mainTarget()),this._tracingModel=e,this._inputModel.setEvents(e),this._setState("Idle")):this._reset()}_recordingFailed(){this._tracingClient=null,this._setState("Idle")}replayStopped(){this._setState("Idle")}}class S{static instance(t={forceNew:null}){const{forceNew:e}=t;return M&&!e||(M=new S),M}handleAction(t,e){const i="Inputs";return _.ViewManager.instance().showView(i).then((()=>_.ViewManager.instance().view(i).widget())).then((t=>this._innerHandleAction(t,e))),!0}_innerHandleAction(t,e){switch(e){case"input.toggle-recording":t._toggleRecording();break;case"input.start-replaying":t._startReplay();break;case"input.toggle-pause":t._toggleReplayPause();break;default:console.assert(!1,"Unknown action: "+e)}}}class R{constructor(t,s){this._target=t,this._tracingManager=t.model(e.TracingManager),this._client=s;const n=new a.TempFileBackingStorage;this._tracingModel=new i.TracingModel(n),this._tracingCompleteCallback=null}async startRecording(){if(!this._tracingManager)return{};const t=["devtools.timeline","disabled-by-default-devtools.timeline.inputs"].join(","),e=await this._tracingManager.start(this,t,"");return e["Protocol.Error"]&&await this._waitForTracingToStop(!1),e}async stopRecording(){this._tracingManager&&this._tracingManager.stop(),await this._waitForTracingToStop(!0),await t.TargetManager.instance().resumeAllTargets(),this._tracingModel.tracingComplete(),this._client.loadingComplete(this._tracingModel)}traceEventsCollected(t){this._tracingModel.addEvents(t)}tracingComplete(){this._tracingCompleteCallback&&this._tracingCompleteCallback(),this._tracingCompleteCallback=null}tracingBufferUsage(t){}eventsRetrievalProgress(t){}_waitForTracingToStop(t){return new Promise((e=>{this._tracingManager&&t?this._tracingCompleteCallback=e:e()}))}}var I=Object.freeze({__proto__:null,UIStrings:T,InputTimeline:f,ActionDelegate:S,TracingClient:R});export{y as InputModel,I as InputTimeline};
