/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.charts.util.XYZElement;
import org.jfree.data.xy.AbstractXYZDataset;
import org.jfree.data.xy.XYZDataset;

public class DefaultXYZDataset
extends AbstractXYZDataset
implements XYZDataset {
    private static final long serialVersionUID = 10200L;
    List dataset = new ArrayList();

    public void addValue(Comparable series, Number xValue, Number yValue, Number zValue) {
        boolean found = false;
        Iterator it = this.dataset.iterator();
        while (it.hasNext()) {
            XYZElement element = (XYZElement)it.next();
            if (!element.getSeries().equals(series)) continue;
            element.addElement(xValue, yValue, zValue);
            found = true;
        }
        if (!found) {
            XYZElement element = new XYZElement();
            element.setSeries(series);
            element.addElement(xValue, yValue, zValue);
            this.dataset.add(element);
        }
    }

    public int getSeriesCount() {
        int retVal = 0;
        if (this.dataset != null) {
            retVal = this.dataset.size();
        }
        return retVal;
    }

    public Number getZ(int series, int index) {
        Number retVal = null;
        if (this.dataset != null && series < this.getSeriesCount()) {
            XYZElement element = (XYZElement)this.dataset.get(series);
            retVal = element.getZElement(index);
        }
        return retVal;
    }

    public int getItemCount(int series) {
        int retVal = 0;
        if (this.dataset != null && series < this.getSeriesCount()) {
            XYZElement element = (XYZElement)this.dataset.get(series);
            retVal = element.getCount();
        }
        return retVal;
    }

    public Number getX(int series, int index) {
        Number retVal = null;
        if (this.dataset != null && series < this.getSeriesCount()) {
            XYZElement element = (XYZElement)this.dataset.get(series);
            retVal = element.getXElement(index);
        }
        return retVal;
    }

    public Number getY(int series, int index) {
        Number retVal = null;
        if (this.dataset != null && series < this.getSeriesCount()) {
            XYZElement element = (XYZElement)this.dataset.get(series);
            retVal = element.getYElement(index);
        }
        return retVal;
    }

    public Comparable getSeriesKey(int index) {
        String retVal = null;
        if (this.dataset != null && index < this.getSeriesCount()) {
            XYZElement element = (XYZElement)this.dataset.get(index);
            retVal = element.getSeries().toString();
        }
        return retVal;
    }
}

