/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * lessThanEqual(dvec4(-1.5lf, -1.5lf, -1.5lf, -1.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)) => bvec4(true, true, true, true)
 * lessThanEqual(dvec4(-0.5lf, -0.5lf, -0.5lf, -0.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)) => bvec4(false, true, true, true)
 * lessThanEqual(dvec4(0.5lf, 0.5lf, 0.5lf, 0.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)) => bvec4(false, false, true, true)
 * lessThanEqual(dvec4(1.5lf, 1.5lf, 1.5lf, 1.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)) => bvec4(false, false, false, true)
 */
#version 400

void main()
{
  double[all(equal(lessThanEqual(dvec4(-1.5lf, -1.5lf, -1.5lf, -1.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)), bvec4(true, true, true, true))) ? 1 : -1] array0;
  double[all(equal(lessThanEqual(dvec4(-0.5lf, -0.5lf, -0.5lf, -0.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)), bvec4(false, true, true, true))) ? 1 : -1] array1;
  double[all(equal(lessThanEqual(dvec4(0.5lf, 0.5lf, 0.5lf, 0.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)), bvec4(false, false, true, true))) ? 1 : -1] array2;
  double[all(equal(lessThanEqual(dvec4(1.5lf, 1.5lf, 1.5lf, 1.5lf), dvec4(-1.5lf, -0.5lf, 0.5lf, 1.5lf)), bvec4(false, false, false, true))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
