/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import org.traccar.BaseProtocol;
import org.traccar.Context;
import org.traccar.PipelineBuilder;
import org.traccar.TrackerServer;
import org.traccar.protocol.XexunFrameDecoder;
import org.traccar.protocol.XexunProtocolDecoder;
import org.traccar.protocol.XexunProtocolEncoder;

public class XexunProtocol
extends BaseProtocol {
    public XexunProtocol() {
        this.setSupportedDataCommands("engineStop", "engineResume");
        this.addServer(new TrackerServer(false, this.getName()){

            @Override
            protected void addProtocolHandlers(PipelineBuilder pipeline) {
                boolean full = Context.getConfig().getBoolean(XexunProtocol.this.getName() + ".extended");
                if (full) {
                    pipeline.addLast((ChannelHandler)new LineBasedFrameDecoder(1024));
                } else {
                    pipeline.addLast((ChannelHandler)new XexunFrameDecoder());
                }
                pipeline.addLast((ChannelHandler)new StringEncoder());
                pipeline.addLast((ChannelHandler)new StringDecoder());
                pipeline.addLast((ChannelHandler)new XexunProtocolEncoder(XexunProtocol.this));
                pipeline.addLast((ChannelHandler)new XexunProtocolDecoder(XexunProtocol.this, full));
            }
        });
    }
}

