/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Context;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.model.Position;

public class SkypatrolProtocolDecoder
extends BaseProtocolDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkypatrolProtocolDecoder.class);
    private final long defaultMask = Context.getConfig().getInteger(this.getProtocolName() + ".mask");

    public SkypatrolProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private static double convertCoordinate(long coordinate) {
        int sign = 1;
        if (coordinate > Integer.MAX_VALUE) {
            sign = -1;
            coordinate = 0xFFFFFFFFL - coordinate;
        }
        long degrees = coordinate / 1000000L;
        double minutes = (double)(coordinate % 1000000L) / 10000.0;
        return (double)sign * ((double)degrees + minutes / 60.0);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        int apiNumber = buf.readUnsignedShort();
        short commandType = buf.readUnsignedByte();
        int messageType = BitUtil.from(buf.readUnsignedByte(), 4);
        long mask = this.defaultMask;
        if (buf.readUnsignedByte() == 4) {
            mask = buf.readUnsignedInt();
        }
        if (apiNumber == 5 && commandType == 2 && messageType == 1 && BitUtil.check(mask, 0)) {
            String id;
            Position position = new Position(this.getProtocolName());
            if (BitUtil.check(mask, 1)) {
                position.set("status", buf.readUnsignedInt());
            }
            if (BitUtil.check(mask, 23)) {
                id = buf.toString(buf.readerIndex(), 8, StandardCharsets.US_ASCII).trim();
                buf.skipBytes(8);
            } else if (BitUtil.check(mask, 2)) {
                id = buf.toString(buf.readerIndex(), 22, StandardCharsets.US_ASCII).trim();
                buf.skipBytes(22);
            } else {
                LOGGER.warn("No device id field");
                return null;
            }
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, id);
            if (deviceSession == null) {
                return null;
            }
            position.setDeviceId(deviceSession.getDeviceId());
            if (BitUtil.check(mask, 3)) {
                position.set("io1", buf.readUnsignedShort());
            }
            if (BitUtil.check(mask, 4)) {
                position.set("adc1", buf.readUnsignedShort());
            }
            if (BitUtil.check(mask, 5)) {
                position.set("adc2", buf.readUnsignedShort());
            }
            if (BitUtil.check(mask, 7)) {
                buf.readUnsignedByte();
            }
            DateBuilder dateBuilder = new DateBuilder();
            if (BitUtil.check(mask, 8)) {
                dateBuilder.setDateReverse(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
            }
            if (BitUtil.check(mask, 9)) {
                position.setValid(buf.readUnsignedByte() == 1);
            }
            if (BitUtil.check(mask, 10)) {
                position.setLatitude(SkypatrolProtocolDecoder.convertCoordinate(buf.readUnsignedInt()));
            }
            if (BitUtil.check(mask, 11)) {
                position.setLongitude(SkypatrolProtocolDecoder.convertCoordinate(buf.readUnsignedInt()));
            }
            if (BitUtil.check(mask, 12)) {
                position.setSpeed((double)buf.readUnsignedShort() / 10.0);
            }
            if (BitUtil.check(mask, 13)) {
                position.setCourse((double)buf.readUnsignedShort() / 10.0);
            }
            if (BitUtil.check(mask, 14)) {
                dateBuilder.setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
            }
            position.setTime(dateBuilder.getDate());
            if (BitUtil.check(mask, 15)) {
                position.setAltitude(buf.readMedium());
            }
            if (BitUtil.check(mask, 16)) {
                position.set("sat", buf.readUnsignedByte());
            }
            if (BitUtil.check(mask, 17)) {
                position.set("battery", buf.readUnsignedShort());
            }
            if (BitUtil.check(mask, 20)) {
                position.set("tripOdometer", buf.readUnsignedInt());
            }
            if (BitUtil.check(mask, 21)) {
                position.set("odometer", buf.readUnsignedInt());
            }
            if (BitUtil.check(mask, 22)) {
                buf.skipBytes(6);
            }
            if (BitUtil.check(mask, 24)) {
                position.set("power", (double)buf.readUnsignedShort() * 0.001);
            }
            if (BitUtil.check(mask, 25)) {
                buf.skipBytes(18);
            }
            if (BitUtil.check(mask, 26)) {
                buf.skipBytes(54);
            }
            if (BitUtil.check(mask, 28)) {
                position.set("index", buf.readUnsignedShort());
            }
            return position;
        }
        return null;
    }
}

