/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import io.netty.channel.ChannelHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.BaseDataHandler;
import org.traccar.Context;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

@ChannelHandler.Sharable
public class FilterHandler
extends BaseDataHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterHandler.class);
    private boolean filterInvalid;
    private boolean filterZero;
    private boolean filterDuplicate;
    private long filterFuture;
    private boolean filterApproximate;
    private int filterAccuracy;
    private boolean filterStatic;
    private int filterDistance;
    private int filterMaxSpeed;
    private long filterMinPeriod;
    private long skipLimit;
    private boolean skipAttributes;

    public FilterHandler(Config config) {
        this.filterInvalid = config.getBoolean(Keys.FILTER_INVALID);
        this.filterZero = config.getBoolean(Keys.FILTER_ZERO);
        this.filterDuplicate = config.getBoolean(Keys.FILTER_DUPLICATE);
        this.filterFuture = config.getLong(Keys.FILTER_FUTURE) * 1000L;
        this.filterAccuracy = config.getInteger(Keys.FILTER_ACCURACY);
        this.filterApproximate = config.getBoolean(Keys.FILTER_APPROXIMATE);
        this.filterStatic = config.getBoolean(Keys.FILTER_STATIC);
        this.filterDistance = config.getInteger(Keys.FILTER_DISTANCE);
        this.filterMaxSpeed = config.getInteger(Keys.FILTER_MAX_SPEED);
        this.filterMinPeriod = config.getInteger(Keys.FILTER_MIN_PERIOD) * 1000;
        this.skipLimit = config.getLong(Keys.FILTER_SKIP_LIMIT) * 1000L;
        this.skipAttributes = config.getBoolean(Keys.FILTER_SKIP_ATTRIBUTES_ENABLE);
    }

    private boolean filterInvalid(Position position) {
        return this.filterInvalid && (!position.getValid() || position.getLatitude() > 90.0 || position.getLongitude() > 180.0 || position.getLatitude() < -90.0 || position.getLongitude() < -180.0);
    }

    private boolean filterZero(Position position) {
        return this.filterZero && position.getLatitude() == 0.0 && position.getLongitude() == 0.0;
    }

    private boolean filterDuplicate(Position position, Position last) {
        if (this.filterDuplicate && last != null && position.getFixTime().equals(last.getFixTime())) {
            for (String key : position.getAttributes().keySet()) {
                if (last.getAttributes().containsKey(key)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean filterFuture(Position position) {
        return this.filterFuture != 0L && position.getFixTime().getTime() > System.currentTimeMillis() + this.filterFuture;
    }

    private boolean filterAccuracy(Position position) {
        return this.filterAccuracy != 0 && position.getAccuracy() > (double)this.filterAccuracy;
    }

    private boolean filterApproximate(Position position) {
        return this.filterApproximate && position.getBoolean("approximate");
    }

    private boolean filterStatic(Position position) {
        return this.filterStatic && position.getSpeed() == 0.0;
    }

    private boolean filterDistance(Position position, Position last) {
        if (this.filterDistance != 0 && last != null) {
            return position.getDouble("distance") < (double)this.filterDistance;
        }
        return false;
    }

    private boolean filterMaxSpeed(Position position, Position last) {
        if (this.filterMaxSpeed != 0 && last != null) {
            double time;
            double distance = position.getDouble("distance");
            return UnitsConverter.knotsFromMps(distance / ((time = (double)(position.getFixTime().getTime() - last.getFixTime().getTime())) / 1000.0)) > (double)this.filterMaxSpeed;
        }
        return false;
    }

    private boolean filterMinPeriod(Position position, Position last) {
        if (this.filterMinPeriod != 0L && last != null) {
            long time = position.getFixTime().getTime() - last.getFixTime().getTime();
            return time > 0L && time < this.filterMinPeriod;
        }
        return false;
    }

    private boolean skipLimit(Position position, Position last) {
        if (this.skipLimit != 0L && last != null) {
            return position.getServerTime().getTime() - last.getServerTime().getTime() > this.skipLimit;
        }
        return false;
    }

    private boolean skipAttributes(Position position) {
        if (this.skipAttributes) {
            String attributesString = Context.getIdentityManager().lookupAttributeString(position.getDeviceId(), "filter.skipAttributes", "", false, true);
            for (String attribute : attributesString.split("[ ,]")) {
                if (!position.getAttributes().containsKey(attribute)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean filter(Position position) {
        StringBuilder filterType = new StringBuilder();
        Position last = null;
        if (Context.getIdentityManager() != null) {
            last = Context.getIdentityManager().getLastPosition(position.getDeviceId());
        }
        if (this.filterInvalid(position)) {
            filterType.append("Invalid ");
        }
        if (this.filterZero(position)) {
            filterType.append("Zero ");
        }
        if (this.filterDuplicate(position, last) && !this.skipLimit(position, last) && !this.skipAttributes(position)) {
            filterType.append("Duplicate ");
        }
        if (this.filterFuture(position)) {
            filterType.append("Future ");
        }
        if (this.filterAccuracy(position)) {
            filterType.append("Accuracy ");
        }
        if (this.filterApproximate(position)) {
            filterType.append("Approximate ");
        }
        if (this.filterStatic(position) && !this.skipLimit(position, last) && !this.skipAttributes(position)) {
            filterType.append("Static ");
        }
        if (this.filterDistance(position, last) && !this.skipLimit(position, last) && !this.skipAttributes(position)) {
            filterType.append("Distance ");
        }
        if (this.filterMaxSpeed(position, last)) {
            filterType.append("MaxSpeed ");
        }
        if (this.filterMinPeriod(position, last)) {
            filterType.append("MinPeriod ");
        }
        if (filterType.length() > 0) {
            StringBuilder message = new StringBuilder();
            message.append("Position filtered by ");
            message.append(filterType.toString());
            message.append("filters from device: ");
            message.append(Context.getIdentityManager().getById(position.getDeviceId()).getUniqueId());
            LOGGER.info(message.toString());
            return true;
        }
        return false;
    }

    @Override
    protected Position handlePosition(Position position) {
        if (this.filter(position)) {
            return null;
        }
        return position;
    }
}

