/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.util.ByteArrayDataSource;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.api.BaseResource;
import org.traccar.helper.DateUtil;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.reports.Events;
import org.traccar.reports.Route;
import org.traccar.reports.Stops;
import org.traccar.reports.Summary;
import org.traccar.reports.Trips;
import org.traccar.reports.model.StopReport;
import org.traccar.reports.model.SummaryReport;
import org.traccar.reports.model.TripReport;

@Path(value="reports")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ReportResource
extends BaseResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportResource.class);
    private static final String XLSX = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    private static final String CONTENT_DISPOSITION_VALUE_XLSX = "attachment; filename=report.xlsx";

    private Response executeReport(long userId, boolean mail, ReportExecutor executor) throws SQLException, IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        if (mail) {
            new Thread(() -> {
                try {
                    executor.execute(stream);
                    MimeBodyPart attachment = new MimeBodyPart();
                    attachment.setFileName("report.xlsx");
                    attachment.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(stream.toByteArray(), "application/octet-stream")));
                    Context.getMailManager().sendMessage(userId, "Report", "The report is in the attachment.", attachment);
                }
                catch (IOException | SQLException | MessagingException e) {
                    LOGGER.warn("Report failed", e);
                }
            }).start();
            return Response.noContent().build();
        }
        executor.execute(stream);
        return Response.ok((Object)stream.toByteArray()).header("Content-Disposition", (Object)CONTENT_DISPOSITION_VALUE_XLSX).build();
    }

    @Path(value="route")
    @GET
    public Collection<Position> getRoute(@QueryParam(value="deviceId") List<Long> deviceIds, @QueryParam(value="groupId") List<Long> groupIds, @QueryParam(value="from") String from, @QueryParam(value="to") String to) throws SQLException {
        return Route.getObjects(this.getUserId(), deviceIds, groupIds, DateUtil.parseDate(from), DateUtil.parseDate(to));
    }

    @Path(value="route")
    @GET
    @Produces(value={"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
    public Response getRouteExcel(@QueryParam(value="deviceId") List<Long> deviceIds, @QueryParam(value="groupId") List<Long> groupIds, @QueryParam(value="from") String from, @QueryParam(value="to") String to, @QueryParam(value="mail") boolean mail) throws SQLException, IOException {
        return this.executeReport(this.getUserId(), mail, stream -> Route.getExcel(stream, this.getUserId(), deviceIds, groupIds, DateUtil.parseDate(from), DateUtil.parseDate(to)));
    }

    @Path(value="events")
    @GET
    public Collection<Event> getEvents(@QueryParam(value="deviceId") List<Long> deviceIds, @QueryParam(value="groupId") List<Long> groupIds, @QueryParam(value="type") List<String> types, @QueryParam(value="from") String from, @QueryParam(value="to") String to) throws SQLException {
        return Events.getObjects(this.getUserId(), deviceIds, groupIds, types, DateUtil.parseDate(from), DateUtil.parseDate(to));
    }

    @Path(value="events")
    @GET
    @Produces(value={"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
    public Response getEventsExcel(@QueryParam(value="deviceId") List<Long> deviceIds, @QueryParam(value="groupId") List<Long> groupIds, @QueryParam(value="type") List<String> types, @QueryParam(value="from") String from, @QueryParam(value="to") String to, @QueryParam(value="mail") boolean mail) throws SQLException, IOException {
        return this.executeReport(this.getUserId(), mail, stream -> Events.getExcel(stream, this.getUserId(), deviceIds, groupIds, types, DateUtil.parseDate(from), DateUtil.parseDate(to)));
    }

    @Path(value="summary")
    @GET
    public Collection<SummaryReport> getSummary(@QueryParam(value="deviceId") List<Long> deviceIds, @QueryParam(value="groupId") List<Long> groupIds, @QueryParam(value="from") String from, @QueryParam(value="to") String to) throws SQLException {
        return Summary.getObjects(this.getUserId(), deviceIds, groupIds, DateUtil.parseDate(from), DateUtil.parseDate(to));
    }

    @Path(value="summary")
    @GET
    @Produces(value={"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
    public Response getSummaryExcel(@QueryParam(value="deviceId") List<Long> deviceIds, @QueryParam(value="groupId") List<Long> groupIds, @QueryParam(value="from") String from, @QueryParam(value="to") String to, @QueryParam(value="mail") boolean mail) throws SQLException, IOException {
        return this.executeReport(this.getUserId(), mail, stream -> Summary.getExcel(stream, this.getUserId(), deviceIds, groupIds, DateUtil.parseDate(from), DateUtil.parseDate(to)));
    }

    @Path(value="trips")
    @GET
    @Produces(value={"application/json"})
    public Collection<TripReport> getTrips(@QueryParam(value="deviceId") List<Long> deviceIds, @QueryParam(value="groupId") List<Long> groupIds, @QueryParam(value="from") String from, @QueryParam(value="to") String to) throws SQLException {
        return Trips.getObjects(this.getUserId(), deviceIds, groupIds, DateUtil.parseDate(from), DateUtil.parseDate(to));
    }

    @Path(value="trips")
    @GET
    @Produces(value={"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
    public Response getTripsExcel(@QueryParam(value="deviceId") List<Long> deviceIds, @QueryParam(value="groupId") List<Long> groupIds, @QueryParam(value="from") String from, @QueryParam(value="to") String to, @QueryParam(value="mail") boolean mail) throws SQLException, IOException {
        return this.executeReport(this.getUserId(), mail, stream -> Trips.getExcel(stream, this.getUserId(), deviceIds, groupIds, DateUtil.parseDate(from), DateUtil.parseDate(to)));
    }

    @Path(value="stops")
    @GET
    @Produces(value={"application/json"})
    public Collection<StopReport> getStops(@QueryParam(value="deviceId") List<Long> deviceIds, @QueryParam(value="groupId") List<Long> groupIds, @QueryParam(value="from") String from, @QueryParam(value="to") String to) throws SQLException {
        return Stops.getObjects(this.getUserId(), deviceIds, groupIds, DateUtil.parseDate(from), DateUtil.parseDate(to));
    }

    @Path(value="stops")
    @GET
    @Produces(value={"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
    public Response getStopsExcel(@QueryParam(value="deviceId") List<Long> deviceIds, @QueryParam(value="groupId") List<Long> groupIds, @QueryParam(value="from") String from, @QueryParam(value="to") String to, @QueryParam(value="mail") boolean mail) throws SQLException, IOException {
        return this.executeReport(this.getUserId(), mail, stream -> Stops.getExcel(stream, this.getUserId(), deviceIds, groupIds, DateUtil.parseDate(from), DateUtil.parseDate(to)));
    }

    private static interface ReportExecutor {
        public void execute(ByteArrayOutputStream var1) throws SQLException, IOException;
    }
}

