/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.BaseProtocol;
import org.traccar.Context;
import org.traccar.GlobalTimer;
import org.traccar.TrackerServer;

public class ServerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerManager.class);
    private final List<TrackerServer> serverList = new LinkedList<TrackerServer>();
    private final Map<String, BaseProtocol> protocolList = new ConcurrentHashMap<String, BaseProtocol>();

    private void loadPackage(String packageName) throws IOException, URISyntaxException, ReflectiveOperationException {
        LinkedList<String> names = new LinkedList<String>();
        String packagePath = packageName.replace('.', '/');
        URL packageUrl = this.getClass().getClassLoader().getResource(packagePath);
        if (packageUrl.getProtocol().equals("jar")) {
            String jarFileName = URLDecoder.decode(packageUrl.getFile(), StandardCharsets.UTF_8.name());
            try (JarFile jf = new JarFile(jarFileName.substring(5, jarFileName.indexOf("!")));){
                Enumeration<JarEntry> jarEntries = jf.entries();
                while (jarEntries.hasMoreElements()) {
                    String entryName = ((JarEntry)jarEntries.nextElement()).getName();
                    if (!entryName.startsWith(packagePath) || entryName.length() <= packagePath.length() + 5) continue;
                    names.add(entryName.substring(packagePath.length() + 1, entryName.lastIndexOf(46)));
                }
            }
        } else {
            File folder = new File(new URI(packageUrl.toString()));
            File[] files = folder.listFiles();
            if (files != null) {
                for (File actual : files) {
                    String entryName = actual.getName();
                    names.add(entryName.substring(0, entryName.lastIndexOf(46)));
                }
            }
        }
        for (String name : names) {
            Class<?> protocolClass = Class.forName(packageName + '.' + name);
            if (!BaseProtocol.class.isAssignableFrom(protocolClass) || !Context.getConfig().hasKey(BaseProtocol.nameFromClass(protocolClass) + ".port")) continue;
            BaseProtocol protocol = (BaseProtocol)protocolClass.newInstance();
            this.serverList.addAll(protocol.getServerList());
            this.protocolList.put(protocol.getName(), protocol);
        }
    }

    public ServerManager() throws IOException, URISyntaxException, ReflectiveOperationException {
        this.loadPackage("org.traccar.protocol");
    }

    public BaseProtocol getProtocol(String name) {
        return this.protocolList.get(name);
    }

    public void start() throws Exception {
        for (TrackerServer server : this.serverList) {
            try {
                server.start();
            }
            catch (BindException e) {
                LOGGER.warn("Port {} is disabled due to conflict", (Object)server.getPort());
            }
        }
    }

    public void stop() {
        for (TrackerServer server : this.serverList) {
            server.stop();
        }
        GlobalTimer.release();
    }
}

