/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.type;

import com.cloudhopper.commons.util.HexUtil;
import com.cloudhopper.smpp.pdu.PduResponse;
import com.cloudhopper.smpp.type.UnrecoverablePduException;

public class UnexpectedPduResponseException
extends UnrecoverablePduException {
    static final long serialVersionUID = 1L;
    private final PduResponse responsePdu;

    public UnexpectedPduResponseException(PduResponse responsePdu) {
        super(UnexpectedPduResponseException.buildErrorMessage(responsePdu));
        this.responsePdu = responsePdu;
    }

    public PduResponse getResponsePdu() {
        return this.responsePdu;
    }

    public static String buildErrorMessage(PduResponse responsePdu) {
        return "Unexpected response PDU [" + responsePdu.getClass().getName() + "] [error: 0x" + HexUtil.toHexString((int)responsePdu.getCommandStatus()) + " \"" + responsePdu.getResultMessage() + "\"]";
    }
}

