/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.rename;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.sh.highlighting.ShTextOccurrencesUtil;
import com.intellij.sh.rename.ShRenameDialog;
import com.intellij.sh.rename.ShTextRenameRefactoring;
import com.intellij.sh.rename.TextOccurrencesRenamer;
import java.util.Collection;
import java.util.MissingResourceException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShRenameAllOccurrencesHandler
extends EditorActionHandler {
    public static final ShRenameAllOccurrencesHandler INSTANCE = new ShRenameAllOccurrencesHandler();
    static final Key<TextOccurrencesRenamer> RENAMER_KEY = Key.create((String)"renamer");

    private ShRenameAllOccurrencesHandler() {
    }

    public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            ShRenameAllOccurrencesHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            ShRenameAllOccurrencesHandler.$$$reportNull$$$0(1);
        }
        return editor.getProject() != null;
    }

    public void doExecute(@NotNull Editor editor, @Nullable Caret c, DataContext dataContext) {
        ShTextRenameRefactoring rename;
        TextRange occurrenceAtCaret;
        if (editor == null) {
            ShRenameAllOccurrencesHandler.$$$reportNull$$$0(2);
        }
        Caret caret = editor.getCaretModel().getPrimaryCaret();
        SelectionModel selectionModel = editor.getSelectionModel();
        boolean hasSelection = caret.hasSelection();
        TextRange textRange = occurrenceAtCaret = hasSelection ? new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd()) : ShTextOccurrencesUtil.findTextRangeOfIdentifierAtCaret(editor);
        if (occurrenceAtCaret == null) {
            return;
        }
        CharSequence documentText = editor.getDocument().getImmutableCharSequence();
        CharSequence textToFind = occurrenceAtCaret.subSequence(documentText);
        Collection<TextRange> occurrences = ShTextOccurrencesUtil.findAllOccurrences(documentText, textToFind, !hasSelection);
        Project project = editor.getProject();
        assert (project != null);
        if (occurrences.size() < ShRenameAllOccurrencesHandler.getMaxInplaceRenameSegments() && documentText.length() < 0x100000 && (rename = ShTextRenameRefactoring.create(editor, project, textToFind.toString(), occurrences, occurrenceAtCaret)) != null) {
            rename.start();
            return;
        }
        TextOccurrencesRenamer renamer = new TextOccurrencesRenamer(editor, textToFind.toString(), occurrences, occurrenceAtCaret);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            editor.putUserData(RENAMER_KEY, (Object)renamer);
        } else {
            new ShRenameDialog(project, renamer).show();
        }
    }

    @NotNull
    static RegistryValue getMaxInplaceRenameSegmentsRegistryValue() {
        RegistryValue registryValue = Registry.get((String)"inplace.rename.segments.limit");
        if (registryValue == null) {
            ShRenameAllOccurrencesHandler.$$$reportNull$$$0(3);
        }
        return registryValue;
    }

    private static int getMaxInplaceRenameSegments() {
        try {
            return ShRenameAllOccurrencesHandler.getMaxInplaceRenameSegmentsRegistryValue().asInteger();
        }
        catch (MissingResourceException e) {
            return -1;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/rename/ShRenameAllOccurrencesHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/rename/ShRenameAllOccurrencesHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMaxInplaceRenameSegmentsRegistryValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledForCaret";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

