/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.Nullable;

public final class PsiNavigateUtil {
    public static void navigate(@Nullable PsiElement psiElement) {
        PsiNavigateUtil.navigate(psiElement, true);
    }

    public static void navigate(@Nullable PsiElement psiElement, boolean requestFocus) {
        if (psiElement != null && psiElement.isValid()) {
            Navigatable navigatable;
            PsiElement navigationElement = psiElement.getNavigationElement();
            int offset = navigationElement instanceof PsiFile ? -1 : navigationElement.getTextOffset();
            VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile(psiElement);
            if (virtualFile2 != null && virtualFile2.isValid()) {
                navigatable = PsiNavigationSupport.getInstance().createNavigatable(navigationElement.getProject(), virtualFile2, offset);
            } else if (navigationElement instanceof Navigatable) {
                navigatable = (Navigatable)((Object)navigationElement);
            } else {
                return;
            }
            navigatable.navigate(requestFocus);
        }
    }
}

