/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.TextComponentEmptyText;
import com.intellij.util.BooleanFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

public class JBTextArea
extends JTextArea
implements ComponentWithEmptyText {
    private final TextComponentEmptyText myEmptyText = new TextComponentEmptyText(this){

        @Override
        protected boolean isStatusVisible() {
            Object function = JBTextArea.this.getClientProperty("StatusVisibleFunction");
            if (function instanceof BooleanFunction) {
                return ((BooleanFunction)function).fun((Object)JBTextArea.this);
            }
            return super.isStatusVisible();
        }

        @Override
        protected Rectangle getTextComponentBound() {
            Insets insets = (Insets)ObjectUtils.notNull((Object)JBTextArea.this.getInsets(), (Object)JBUI.emptyInsets());
            Insets margin = (Insets)ObjectUtils.notNull((Object)JBTextArea.this.getMargin(), (Object)JBUI.emptyInsets());
            Insets ipad = this.getComponent().getIpad();
            Dimension size = JBTextArea.this.getSize();
            int left = insets.left + margin.left - ipad.left;
            int top = insets.top + margin.top - ipad.top;
            int right = size.width - (insets.right + margin.right - ipad.right);
            return new Rectangle(left, top, right - left, JBTextArea.this.getRowHeight());
        }
    };

    public JBTextArea() {
        this(null, null, 0, 0);
    }

    public JBTextArea(String text) {
        this(null, text, 0, 0);
    }

    public JBTextArea(int rows, int columns) {
        this(null, null, rows, columns);
    }

    public JBTextArea(String text, int rows, int columns) {
        this(null, text, rows, columns);
    }

    public JBTextArea(Document doc) {
        this(doc, null, 0, 0);
    }

    public JBTextArea(Document doc, String text, int rows, int columns) {
        super(doc, text, rows, columns);
        this.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                JBTextArea.this.invalidate();
                JBTextArea.this.revalidate();
                JBTextArea.this.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/components/JBTextArea$2", "textChanged"));
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        int width = 0;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        for (String line : this.getText().split("\n")) {
            width = Math.max(width, fontMetrics.stringWidth(line));
        }
        Dimension d = super.getPreferredSize();
        Insets insets = this.getInsets();
        d.width = Math.min(d.width, width + insets.left + insets.right);
        return d;
    }

    @Override
    public void scrollRectToVisible(Rectangle r) {
        JViewport viewport = (JViewport)ComponentUtil.getParentOfType(JViewport.class, (Component)this);
        if (viewport != null) {
            r = SwingUtilities.convertRectangle(this, r, viewport);
            viewport.scrollRectToVisible(r);
        }
    }

    @Override
    @NotNull
    public StatusText getEmptyText() {
        TextComponentEmptyText textComponentEmptyText = this.myEmptyText;
        if (textComponentEmptyText == null) {
            JBTextArea.$$$reportNull$$$0(0);
        }
        return textComponentEmptyText;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.myEmptyText.getStatusTriggerText().isEmpty() && this.myEmptyText.isStatusVisible()) {
            g.setColor(this.getBackground());
            Rectangle rect = new Rectangle(this.getSize());
            JBInsets.removeFrom((Rectangle)rect, (Insets)this.getInsets());
            JBInsets.removeFrom((Rectangle)rect, (Insets)this.getMargin());
            ((Graphics2D)g).fill(rect);
            g.setColor(this.getForeground());
        }
        this.myEmptyText.paintStatusText(g);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/components/JBTextArea", "getEmptyText"));
    }
}

